/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import us.amon.stormward.capability.IStormwardCapProvider;
import us.amon.stormward.capability.shardstorage.IShardStorage;
import us.amon.stormward.capability.shardstorage.ShardStorageProvider;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.capability.tusks.ITusks;
import us.amon.stormward.capability.tusks.TusksHelper;
import us.amon.stormward.capability.tusks.TusksProvider;

public class StormwardCapabilities {
    public static final ResourceLocation TUSKS_KEY = new ResourceLocation("stormward", "tusks");
    public static final ResourceLocation SHARD_STORAGE_KEY = new ResourceLocation("stormward", "shard_storage");
    public static final Capability<IStormlightStorage> STORMLIGHT = CapabilityManager.get((CapabilityToken)new CapabilityToken<IStormlightStorage>(){});
    public static final Capability<ITusks> TUSKS = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITusks>(){});
    public static final Capability<IShardStorage> SHARD_STORAGE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IShardStorage>(){});

    public static void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_6095_() == EntityType.f_20532_) {
            event.addCapability(TUSKS_KEY, (ICapabilityProvider)new TusksProvider());
            event.addCapability(SHARD_STORAGE_KEY, (ICapabilityProvider)new ShardStorageProvider());
        }
    }

    private static void addNonPlayerCapability(AttachCapabilitiesEvent<Entity> pEvent, ResourceLocation pKey, IStormwardCapProvider pProvider) {
        pEvent.addCapability(pKey, (ICapabilityProvider)pProvider);
        pEvent.addListener(pProvider::invalidate);
    }

    public static void onPlayerLoggedIn(Player pPlayer) {
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            TusksHelper.update(serverPlayer);
        }
    }

    public static void onPlayerClone(boolean pIsWasDeath, Player pOldPlayer, Player pNewPlayer) {
        if (pIsWasDeath) {
            pOldPlayer.reviveCaps();
            pNewPlayer.getCapability(SHARD_STORAGE).ifPresent(shards -> shards.copy((ICapabilityProvider)pOldPlayer));
            pOldPlayer.invalidateCaps();
        }
    }
}

