/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability.shardstorage;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import us.amon.stormward.capability.StormwardCapabilities;

@AutoRegisterCapability
public interface IShardStorage
extends INBTSerializable<CompoundTag> {
    default public void setPortalInfo(BlockPos pPos, ResourceKey<Level> pDimension) {
        this.setPortalInfo(pPos, pDimension.m_135782_());
    }

    public void setPortalInfo(BlockPos var1, ResourceLocation var2);

    public void clearPortalInfo();

    public BlockPos getPortalPos();

    public ResourceLocation getPortalDimension();

    public void receiveShard(int var1, ItemStack var2);

    default public void receiveShard(EquipmentSlot pSlot, ItemStack pStack) {
        this.receiveShard(pSlot.m_20750_(), pStack);
    }

    public boolean hasShards();

    public List<ItemStack> getShards();

    public List<Pair<Integer, ItemStack>> extractShards();

    default public void copy(ICapabilityProvider other) {
        other.getCapability(StormwardCapabilities.SHARD_STORAGE).ifPresent(shards -> {
            for (Pair<Integer, ItemStack> shard : shards.extractShards()) {
                this.receiveShard((Integer)shard.getFirst(), (ItemStack)shard.getSecond());
            }
            this.setPortalInfo(shards.getPortalPos(), shards.getPortalDimension());
        });
    }
}

