/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability.stormlightstorage;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;

public class StormlightStorage
implements IStormlightStorage {
    public static final String STORMLIGHT_KEY = "Stormlight";
    int maxStormlight;
    int stormlight;

    public StormlightStorage(int pMaxStormlight) {
        this(pMaxStormlight, pMaxStormlight);
    }

    public StormlightStorage(int pMaxStormlight, int pStormlight) {
        this.maxStormlight = pMaxStormlight;
        this.stormlight = pStormlight;
    }

    @Override
    public int getStormlight() {
        return this.stormlight;
    }

    @Override
    public void setStormlight(int pValue) {
        this.stormlight = pValue;
    }

    @Override
    public int getMaxStormlight() {
        return this.maxStormlight;
    }

    @Override
    public int receiveStormlight(int pAmount, boolean pSimulate) {
        int stormlightReceived = Math.min(this.getMaxStormlight() - this.getStormlight(), pAmount);
        if (!pSimulate) {
            this.setStormlight(this.getStormlight() + stormlightReceived);
        }
        return stormlightReceived;
    }

    @Override
    public int extractStormlight(int pAmount, boolean pSimulate) {
        int stormlightExtracted = Math.min(this.getStormlight(), pAmount);
        if (!pSimulate) {
            this.setStormlight(this.getStormlight() - stormlightExtracted);
        }
        return stormlightExtracted;
    }

    @Override
    public void copy(ICapabilityProvider pOther) {
        pOther.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(otherStorage -> this.deserializeNBT((CompoundTag)otherStorage.serializeNBT()));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(STORMLIGHT_KEY, this.getStormlight());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setStormlight(nbt.m_128451_(STORMLIGHT_KEY));
    }
}

