/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.armor.ShardplateMaterial;

public class SpawnShardplateTrimsCommand {
    private static final Map<Pair<ArmorMaterial, EquipmentSlot>, Item> MATERIAL_AND_SLOT_TO_ITEM = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_266706_ -> {
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.GRAVITATIONSPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.GRAVITATIONSPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.GRAVITATIONSPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.GRAVITATIONSPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.ROCKSPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.ROCKSPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.ROCKSPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.ROCKSPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.ROCKSPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.ROCKSPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.ROCKSPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.ROCKSPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.CREATIONSPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.CREATIONSPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.CREATIONSPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.CREATIONSPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.FLAMESPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.FLAMESPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.FLAMESPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.FLAMESPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.FLAMESPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.FLAMESPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.FLAMESPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.FLAMESPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.PASSIONSPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.PASSIONSPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.PASSIONSPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.PASSIONSPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.WINDSPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.WINDSPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.WINDSPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.WINDSPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.WINDSPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.WINDSPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.WINDSPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.WINDSPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LOGICSPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.LOGICSPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LOGICSPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.LOGICSPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LOGICSPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.LOGICSPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LOGICSPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.LOGICSPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LIFESPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.LIFESPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LIFESPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.LIFESPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LIFESPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.LIFESPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.LIFESPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.LIFESPREN_SHARDPLATE_BOOTS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.RAINSPREN), (Object)EquipmentSlot.HEAD), (Item)StormwardItems.RAINSPREN_SHARDPLATE_HELMET.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.RAINSPREN), (Object)EquipmentSlot.CHEST), (Item)StormwardItems.RAINSPREN_SHARDPLATE_CHESTPLATE.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.RAINSPREN), (Object)EquipmentSlot.LEGS), (Item)StormwardItems.RAINSPREN_SHARDPLATE_LEGGINGS.get());
        p_266706_.put(Pair.of((Object)((Object)ShardplateMaterial.RAINSPREN), (Object)EquipmentSlot.FEET), (Item)StormwardItems.RAINSPREN_SHARDPLATE_BOOTS.get());
    });
    private static final List<ResourceKey<TrimPattern>> VANILLA_TRIM_PATTERNS = List.of(TrimPatterns.f_265866_, TrimPatterns.f_265941_, TrimPatterns.f_265901_, TrimPatterns.f_266087_, TrimPatterns.f_266074_, TrimPatterns.f_266091_, TrimPatterns.f_266039_, TrimPatterns.f_266069_, TrimPatterns.f_266083_, TrimPatterns.f_266089_, TrimPatterns.f_265976_, TrimPatterns.f_276615_, TrimPatterns.f_276604_, TrimPatterns.f_276510_, TrimPatterns.f_276435_, TrimPatterns.f_276573_);
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.f_265905_, TrimMaterials.f_266000_, TrimMaterials.f_265896_, TrimMaterials.f_265870_, TrimMaterials.f_265969_, TrimMaterials.f_265937_, TrimMaterials.f_266071_, TrimMaterials.f_266027_, TrimMaterials.f_265981_, TrimMaterials.f_265872_);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = Util.m_214686_(VANILLA_TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = Util.m_214686_(VANILLA_TRIM_MATERIALS);

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        if (ForgeGameTestHooks.isGametestEnabled()) {
            pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn_shardplate_trims").requires(stack -> stack.m_6761_(2))).executes(stack -> SpawnShardplateTrimsCommand.spawnShardplateTrims((CommandSourceStack)stack.getSource(), (Player)((CommandSourceStack)stack.getSource()).m_81375_())));
        }
    }

    private static int spawnShardplateTrims(CommandSourceStack pSource, Player pPlayer) {
        Level level = pPlayer.m_9236_();
        NonNullList nonnulllist = NonNullList.m_122779_();
        Registry registry = level.m_9598_().m_175515_(Registries.f_266063_);
        Registry registry1 = level.m_9598_().m_175515_(Registries.f_266076_);
        registry.m_123024_().sorted(Comparator.comparing(p_266941_ -> TRIM_PATTERN_ORDER.applyAsInt((ResourceKey<TrimPattern>)((ResourceKey)registry.m_7854_(p_266941_).orElse(null))))).forEachOrdered(p_266759_ -> registry1.m_123024_().sorted(Comparator.comparing(p_267239_ -> TRIM_MATERIAL_ORDER.applyAsInt((ResourceKey<TrimMaterial>)((ResourceKey)registry1.m_7854_(p_267239_).orElse(null))))).forEachOrdered(p_267162_ -> nonnulllist.add((Object)new ArmorTrim(registry1.m_263177_(p_267162_), registry.m_263177_(p_266759_)))));
        BlockPos blockpos = pPlayer.m_20183_().m_5484_(pPlayer.m_6350_(), 5);
        int i = ShardplateMaterial.values().length;
        int j = 0;
        int k = 0;
        for (ArmorTrim armortrim : nonnulllist) {
            for (ShardplateMaterial armormaterial : ShardplateMaterial.values()) {
                double d1 = (double)blockpos.m_123341_() + 0.5 - (double)(j % registry1.m_13562_()) * 3.0;
                double d2 = (double)blockpos.m_123342_() + 0.5 + (double)(k % i) * 3.0;
                double d3 = (double)blockpos.m_123343_() + 0.5 + (double)(j / registry1.m_13562_() * 10);
                ArmorStand armorstand = new ArmorStand(level, d1, d2, d3);
                armorstand.m_146922_(180.0f);
                armorstand.m_20242_(true);
                for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                    Item item = MATERIAL_AND_SLOT_TO_ITEM.get(Pair.of((Object)((Object)armormaterial), (Object)equipmentslot));
                    if (item == null) continue;
                    ItemStack itemstack = new ItemStack((ItemLike)item);
                    StormlightStorageHelper.setFull((ICapabilityProvider)itemstack);
                    ArmorTrim.m_266570_((RegistryAccess)level.m_9598_(), (ItemStack)itemstack, (ArmorTrim)armortrim);
                    armorstand.m_8061_(equipmentslot, itemstack);
                    if (armormaterial == ShardplateMaterial.RAINSPREN) {
                        armorstand.m_6593_((Component)((TrimPattern)armortrim.m_266429_().m_203334_()).m_266463_(armortrim.m_266210_()).m_6881_().m_130946_(" ").m_7220_(((TrimMaterial)armortrim.m_266210_().m_203334_()).f_266021_()));
                        armorstand.m_20340_(true);
                    }
                    armorstand.m_6842_(true);
                }
                level.m_7967_((Entity)armorstand);
                ++k;
            }
            ++j;
        }
        pSource.m_288197_(() -> Component.m_237113_((String)"Armorstands with trimmed shardplate spawned around you"), true);
        return 1;
    }
}

