/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.datagen;

import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import us.amon.stormward.block.DuelingPitBarrierBlock;
import us.amon.stormward.block.DuelingPitBlock;
import us.amon.stormward.block.SphereCageBlock;
import us.amon.stormward.block.StormwardBlockFamilies;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.ascender.AscenderChainBlock;
import us.amon.stormward.block.stormlightstorage.StormlightStorageBlock;
import us.amon.stormward.block.stormlightstorage.TransferenceConnectorBlock;
import us.amon.stormward.block.worldgen.CognitiveBeadsBlock;
import us.amon.stormward.block.worldgen.plant.IRosharanPlant;
import us.amon.stormward.block.worldgen.plant.LavisPolypBlock;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.block.worldgen.plant.RosharanDoublePlantBlock;
import us.amon.stormward.gemstone.Gemstone;

public class StormwardBlockStateProvider
extends BlockStateProvider {
    public StormwardBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "stormward", exFileHelper);
    }

    protected void registerStatesAndModels() {
        StormwardBlockFamilies.getAllFamilies().forEach(this::family);
        this.randomRotateBlock(StormwardBlocks.SOULCAST_MEAT_BLOCK);
        this.axisBlockWithItem(StormwardBlocks.CHULL_MEAT_BLOCK, this.texture("chull_meat_block"), this.texture("chull_meat_block_top"));
        this.randomRotateBlock(StormwardBlocks.LAVIS_GRAIN_BLOCK);
        this.blockWithItem(StormwardBlocks.CHRYSALIS_SHELL);
        this.blockWithItem(StormwardBlocks.CHRYSALIS_INNARDS);
        this.blockWithItem(StormwardBlocks.LIFESPREN_BULB_BLOCK);
        this.simpleBlockWithItem((Block)StormwardBlocks.FEARSPREN_JELLY_BLOCK.get(), this.getStormwardModel("fearspren_jelly_block"));
        this.axisBlockWithItem(StormwardBlocks.GREATSHELL_BONE_BLOCK, this.texture("greatshell_bone_block_side"), this.texture("greatshell_bone_block_top"));
        this.blockWithItem(StormwardBlocks.CREM);
        this.blockWithItem(StormwardBlocks.HARDENED_CREM);
        this.rosharanGrassBlock(StormwardBlocks.STONE_GRASS_BLOCK);
        this.rosharanTintedBushBlock(StormwardBlocks.STONE_GRASS);
        this.rosharanTintedDoublePlantBlock(StormwardBlocks.TALL_STONE_GRASS);
        this.lavisPolypBlock(StormwardBlocks.LAVIS_POLYP);
        this.rockbudBlock(StormwardBlocks.ROCKBUD);
        this.rosharanBushBlock(StormwardBlocks.SNARLBRUSH);
        this.crossBlock(StormwardBlocks.MARKEL_SAPLING);
        this.branchBlock(StormwardBlocks.MARKEL_BRANCH);
        this.markelLeafBlock(StormwardBlocks.MARKEL_LEAF);
        this.beadBlock(StormwardBlocks.COGNITIVE_BEADS);
        this.blockWithItem(StormwardBlocks.COGNITIVE_OBSIDIAN);
        this.directionalCrossBlock(StormwardBlocks.FRACTAL_FERN);
        this.directionalDoubleCrossBlock(StormwardBlocks.LARGE_FRACTAL_FERN);
        this.blockWithItem(StormwardBlocks.COGNITIVE_CRYSTAL);
        this.blockWithItem(StormwardBlocks.LUMINOUS_CRYSTAL);
        this.crossBlock(StormwardBlocks.CRYSTAL_SPROUTS);
        this.crossBlock(StormwardBlocks.CRYSTAL_FRONDS);
        this.crossBlock(StormwardBlocks.CRYSTAL_SPINES);
        this.stumpweightLeavesBlock(StormwardBlocks.STUMPWEIGHT_LEAVES);
        this.crossBlock(StormwardBlocks.STUMPWEIGHT_PROPAGULE);
        this.shalebarkBlock(StormwardBlocks.YELLOW_SHALEBARK);
        this.shalebarkBlock(StormwardBlocks.ORANGE_SHALEBARK);
        this.shalebarkBlock(StormwardBlocks.RED_SHALEBARK);
        this.shalebarkBlock(StormwardBlocks.PINK_SHALEBARK);
        this.shalebarkBlock(StormwardBlocks.BLUE_SHALEBARK);
        this.blockWithItem(StormwardBlocks.SCOURED_ROCK);
        this.blockWithItem(StormwardBlocks.RED_SCOURED_ROCK);
        this.simpleBlock((Block)StormwardBlocks.PERPENDICULARITY.get(), this.getStormwardModel("perpendicularity"));
        this.logBlockWithItem(StormwardBlocks.MARKEL_LOG);
        this.axisBlockWithItem(StormwardBlocks.MARKEL_WOOD, this.texture("markel_log"));
        this.axisBlockWithItem(StormwardBlocks.STRIPPED_MARKEL_LOG, this.texture("stripped_markel_log"), this.texture("stripped_markel_log_top"));
        this.axisBlockWithItem(StormwardBlocks.STRIPPED_MARKEL_WOOD, this.texture("stripped_markel_log"));
        this.hangingSignBlock((Block)StormwardBlocks.MARKEL_HANGING_SIGN.get(), (Block)StormwardBlocks.MARKEL_WALL_HANGING_SIGN.get(), this.texture("markel_planks"));
        this.logBlockWithItem(StormwardBlocks.STUMPWEIGHT_LOG);
        this.axisBlockWithItem(StormwardBlocks.STUMPWEIGHT_WOOD, this.texture("stumpweight_log"));
        this.axisBlockWithItem(StormwardBlocks.STRIPPED_STUMPWEIGHT_LOG, this.texture("stripped_stumpweight_log"), this.texture("stripped_stumpweight_log_top"));
        this.axisBlockWithItem(StormwardBlocks.STRIPPED_STUMPWEIGHT_WOOD, this.texture("stripped_stumpweight_log"));
        this.sconceBlock(StormwardBlocks.SMOKESTONE_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.TOPAZ_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.GARNET_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.RUBY_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.AMETHYST_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.SAPPHIRE_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.ZIRCON_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.DIAMOND_SPHERE_SCONCE);
        this.sconceBlock(StormwardBlocks.EMERALD_SPHERE_SCONCE);
        this.horizontalBlock((Block)StormwardBlocks.TRANSFERENCE_STAND.get(), this.getStormwardModel("transference_stand"));
        this.sphereCageBlock(StormwardBlocks.SPHERE_CAGE);
        this.tubeBlock(StormwardBlocks.TRANSFERENCE_TUBE);
        this.tubeConnectorBlock(StormwardBlocks.TRANSFERENCE_OUTPUT, StormwardBlocks.TRANSFERENCE_TUBE);
        this.tubeConnectorBlock(StormwardBlocks.TRANSFERENCE_INPUT, StormwardBlocks.TRANSFERENCE_TUBE);
        this.horizontalBlockWithItem(StormwardBlocks.ARTIFABRIANS_TABLE, this.getStormwardModel("artifabrians_table"));
        this.detectorBlock(StormwardBlocks.STORM_DETECTOR);
        this.duelingPitBlock(StormwardBlocks.DUELING_PIT_BLOCK);
        this.duelingPitBarrierBlock(StormwardBlocks.DUELING_PIT_BARRIER);
        this.stormlightTankBlock(StormwardBlocks.STORMLIGHT_TANK);
        this.blockWithItem(StormwardBlocks.TOPAZ_ORE);
        this.blockWithItem(StormwardBlocks.RUBY_ORE);
        this.blockWithItem(StormwardBlocks.SAPPHIRE_ORE);
        this.blockWithItem(StormwardBlocks.GARNET_ORE);
        this.blockWithItem(StormwardBlocks.ZIRCON_ORE);
        this.blockWithItem(StormwardBlocks.DEEPSLATE_TOPAZ_ORE);
        this.blockWithItem(StormwardBlocks.DEEPSLATE_RUBY_ORE);
        this.blockWithItem(StormwardBlocks.DEEPSLATE_SAPPHIRE_ORE);
        this.blockWithItem(StormwardBlocks.DEEPSLATE_GARNET_ORE);
        this.blockWithItem(StormwardBlocks.DEEPSLATE_ZIRCON_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_SMOKESTONE_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_TOPAZ_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_GARNET_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_RUBY_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_AMETHYST_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_SAPPHIRE_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_ZIRCON_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_DIAMOND_ORE);
        this.blockWithItem(StormwardBlocks.SHADESMAR_EMERALD_ORE);
        this.blockWithItem(StormwardBlocks.SMOKESTONE_BLOCK);
        this.blockWithItem(StormwardBlocks.BUDDING_SMOKESTONE);
        this.directionalCrossBlock(StormwardBlocks.SMOKESTONE_CLUSTER);
        this.budBlock(StormwardBlocks.LARGE_SMOKESTONE_BUD);
        this.budBlock(StormwardBlocks.MEDIUM_SMOKESTONE_BUD);
        this.budBlock(StormwardBlocks.SMALL_SMOKESTONE_BUD);
        this.blockWithItem(StormwardBlocks.SMOKESTONE_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.TOPAZ_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.GARNET_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.RUBY_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.AMETHYST_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.SAPPHIRE_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.ZIRCON_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.DIAMOND_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.EMERALD_GEMHEART_BLOCK);
        this.blockWithItem(StormwardBlocks.TOPAZ_BLOCK);
        this.blockWithItem(StormwardBlocks.RUBY_BLOCK);
        this.blockWithItem(StormwardBlocks.GARNET_BLOCK);
        this.blockWithItem(StormwardBlocks.SAPPHIRE_BLOCK);
        this.blockWithItem(StormwardBlocks.ZIRCON_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.SMOKESTONE_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.TOPAZ_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.RUBY_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.GARNET_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.AMETHYST_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.SAPPHIRE_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.ZIRCON_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.DIAMOND_FRAGMENT_BLOCK);
        this.cubeTopBlockWithItem(StormwardBlocks.EMERALD_FRAGMENT_BLOCK);
        this.stormlightStorageCubeBlock(StormwardBlocks.CONJOINED_BLOCK);
        this.stormlightStorageCubeBlock(StormwardBlocks.REVERSED_BLOCK);
        this.stormlightStorageCubeBlock(StormwardBlocks.STICKY_CONJOINED_BLOCK);
        this.stormlightStorageCubeBlock(StormwardBlocks.STICKY_REVERSED_BLOCK);
        this.stormlightStorageHorizontalBlock(StormwardBlocks.OATHGATE);
        this.horizontalBlockWithItem(StormwardBlocks.ASCENDER_WINCH, this.getStormwardModel("ascender_winch"));
        this.ascenderChainBlock(StormwardBlocks.ASCENDER_CHAIN);
        this.simpleBlock((Block)StormwardBlocks.ASCENDER_COUNTERWEIGHT.get(), this.getStormwardModel("ascender_counterweight"));
        this.spanswitchBlock(StormwardBlocks.SPANSWITCH);
        this.cultivatorBlock(StormwardBlocks.CULTIVATOR);
    }

    private String name(RegistryObject<? extends Block> block) {
        return block.getId().m_135815_();
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private ResourceLocation blockPrefix(ResourceLocation location) {
        return location.m_246208_("block/");
    }

    private ResourceLocation itemPrefix(ResourceLocation location) {
        return location.m_246208_("item/");
    }

    private ResourceLocation texture(RegistryObject<? extends Block> block) {
        return this.blockPrefix(block.getId());
    }

    private ResourceLocation texture(String string) {
        return this.blockPrefix(this.modLoc(string));
    }

    private ModelFile getStormwardModel(String name) {
        return this.models().getExistingFile(new ResourceLocation("stormward", "block/" + name));
    }

    private ModelFile getSingleTextureModel(ResourceLocation name, ResourceLocation parentModelName) {
        return this.models().singleTexture(name.m_135815_(), this.blockPrefix(parentModelName), this.blockPrefix(name));
    }

    private ModelFile getSingleTextureModel(ResourceLocation name, ResourceLocation parentModelName, ResourceLocation textureName) {
        return this.models().singleTexture(name.m_135815_(), this.blockPrefix(parentModelName), this.blockPrefix(textureName));
    }

    private void blockItem(RegistryObject<? extends Block> blockRegistryObject) {
        this.blockItem((Block)blockRegistryObject.get());
    }

    private void blockItem(Block pBlock) {
        ResourceLocation registeredBlock = ForgeRegistries.BLOCKS.getKey((Object)pBlock);
        if (registeredBlock != null) {
            this.simpleBlockItem(pBlock, (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc(this.blockPrefix(registeredBlock).m_135815_())));
        }
    }

    private void blockWithItem(RegistryObject<? extends Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void blockWithItem(RegistryObject<? extends Block> blockRegistryObject, ResourceLocation parent) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.getSingleTextureModel(blockRegistryObject.getId(), parent));
    }

    private void blockWithBasicItem(RegistryObject<? extends Block> blockRegistryObject, ModelFile model) {
        this.simpleBlock((Block)blockRegistryObject.get(), model);
        this.basicItem(blockRegistryObject);
    }

    private void basicItem(RegistryObject<? extends Block> blockRegistryObject) {
        this.basicItem(blockRegistryObject, this.texture(blockRegistryObject));
    }

    private void basicItem(RegistryObject<? extends Block> blockRegistryObject, ResourceLocation texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.name(blockRegistryObject))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private void basicStormlightStorageItem(RegistryObject<? extends Block> blockRegistryObject, ResourceLocation texture) {
        String name = this.name(blockRegistryObject);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture)).override().predicate(this.modLoc("dun"), 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(name + "_dun")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture.m_266382_("_dun"))).end();
    }

    private void cubeTopBlockWithItem(RegistryObject<? extends Block> block) {
        ModelBuilder model = this.models().cubeTop(this.name((Block)block.get()), this.texture(block).m_266382_("_side"), this.texture(block).m_266382_("_top"));
        this.simpleBlock((Block)block.get(), (ModelFile)model);
        this.simpleBlockItem((Block)block.get(), (ModelFile)model);
    }

    private void horizontalBlockWithItem(RegistryObject<? extends Block> block, ModelFile model) {
        this.horizontalBlock((Block)block.get(), model);
        this.simpleBlockItem((Block)block.get(), model);
    }

    private void logBlockWithItem(RegistryObject<? extends RotatedPillarBlock> block) {
        this.logBlock((RotatedPillarBlock)block.get());
        this.blockItem(block);
    }

    private void axisBlockWithItem(RegistryObject<? extends Block> block, ResourceLocation texture) {
        this.axisBlockWithItem(block, texture, texture);
    }

    private void axisBlockWithItem(RegistryObject<? extends Block> block, ResourceLocation side, ResourceLocation end) {
        this.axisBlock((Block)block.get(), side, end);
        this.blockItem(block);
    }

    public void axisBlock(Block block, ResourceLocation side, ResourceLocation end) {
        this.axisBlock(block, (ModelFile)this.models().cubeColumn(this.name(block), side, end), (ModelFile)this.models().cubeColumnHorizontal(this.name(block) + "_horizontal", side, end));
    }

    public void axisBlock(Block block, ModelFile vertical, ModelFile horizontal) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile(vertical).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile(horizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile(horizontal).rotationX(90).rotationY(90).addModel();
    }

    private void crossBlock(RegistryObject<? extends Block> block) {
        this.blockWithBasicItem(block, this.crossModel(block));
    }

    private void budBlock(RegistryObject<? extends Block> block) {
        ModelBuilder modelFile = ((BlockModelBuilder)this.models().cross(this.name(block), this.texture(block))).renderType("cutout");
        this.directionalBlock((Block)block.get(), (ModelFile)modelFile);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.name(block))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/bud")))).texture("layer0", this.texture(block));
    }

    private void directionalCrossBlock(RegistryObject<? extends Block> block) {
        ModelBuilder modelFile = ((BlockModelBuilder)this.models().cross(this.name(block), this.texture(block))).renderType("cutout");
        this.directionalBlock((Block)block.get(), (ModelFile)modelFile);
        this.basicItem(block);
    }

    private void directionalDoubleCrossBlock(RegistryObject<? extends Block> block) {
        this.directionalBlock((Block)block.get(), state -> {
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)RosharanDoublePlantBlock.f_52858_);
            return this.crossModel(block, half == DoubleBlockHalf.LOWER ? "_bottom" : "_top");
        });
        this.basicItem(block, this.texture(block).m_266382_("_top"));
    }

    private void variantBlock(RegistryObject<? extends Block> block, BooleanProperty variant, ModelFile model, ModelFile variantModel) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)variant) != false ? variantModel : model).build());
    }

    private void randomRotateBlock(RegistryObject<? extends Block> block) {
        ModelFile model = this.cubeAll((Block)block.get());
        this.getVariantBuilder((Block)block.get()).partialState().setModels(ConfiguredModel.builder().modelFile(model).nextModel().modelFile(model).rotationY(90).nextModel().modelFile(model).rotationY(180).nextModel().modelFile(model).rotationY(270).build());
        this.simpleBlockItem((Block)block.get(), model);
    }

    private void stormlightStorageBlock(RegistryObject<? extends Block> block, ModelFile model, ModelFile dunModel) {
        this.variantBlock(block, StormlightStorageBlock.DUN, model, dunModel);
        this.StormlightStorageBlockItem(block, model, dunModel);
    }

    private void StormlightStorageBlockItem(RegistryObject<? extends Block> block, ModelFile model, ModelFile dunModel) {
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.name(block))).parent(model)).override().model(dunModel).predicate(this.modLoc("dun"), 1.0f).end();
    }

    private void stormlightStorageCubeBlock(RegistryObject<? extends Block> block) {
        ModelBuilder dunModel = this.models().cubeAll(this.name(block) + "_dun", this.texture(block).m_266382_("_dun"));
        this.stormlightStorageBlock(block, this.cubeAll((Block)block.get()), (ModelFile)dunModel);
    }

    private void stormlightStorageHorizontalBlock(RegistryObject<? extends Block> block) {
        ResourceLocation side = this.texture(block);
        ResourceLocation front = side.m_266382_("_front");
        ModelBuilder model = this.models().orientable(this.name(block), side, front, side);
        ModelBuilder dunModel = this.models().orientable(this.name(block) + "_dun", side, front.m_266382_("_dun"), side);
        this.horizontalBlock((Block)block.get(), arg_0 -> StormwardBlockStateProvider.lambda$stormlightStorageHorizontalBlock$2((ModelFile)dunModel, (ModelFile)model, arg_0));
        this.StormlightStorageBlockItem(block, (ModelFile)model, (ModelFile)dunModel);
    }

    private void stormlightTankBlock(RegistryObject<? extends Block> block) {
        ModelBuilder model = this.models().cubeBottomTop(this.name(block), this.texture(block), this.texture(block).m_266382_("_bottom"), this.texture(block).m_266382_("_top"));
        ModelBuilder dunModel = this.models().cubeBottomTop(this.name(block) + "_dun", this.texture(block).m_266382_("_dun"), this.texture(block).m_266382_("_bottom"), this.texture(block).m_266382_("_top_dun"));
        this.stormlightStorageBlock(block, (ModelFile)model, (ModelFile)dunModel);
    }

    private PipeParts getPipeParts(ResourceLocation pId, String pModel) {
        ResourceLocation parent = this.modLoc(pModel);
        return new PipeParts(this.getSingleTextureModel(pId.m_266382_("_front"), parent.m_266382_("_front")), this.getSingleTextureModel(pId.m_266382_("_center"), parent.m_266382_("_center")), this.getSingleTextureModel(pId.m_266382_("_back"), parent.m_266382_("_back")));
    }

    private MultiPartBlockStateBuilder pipeBlock(RegistryObject<? extends Block> block, PipeParts parts) {
        return ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.get()).part().modelFile(parts.center).addModel()).end().part().modelFile(parts.front).rotationX(-90).addModel()).condition((Property)PipeBlock.f_55152_, (Comparable[])new Boolean[]{true}).end().part().modelFile(parts.back).rotationX(-90).addModel()).condition((Property)PipeBlock.f_55153_, (Comparable[])new Boolean[]{true}).end().part().modelFile(parts.front).addModel()).condition((Property)PipeBlock.f_55148_, (Comparable[])new Boolean[]{true}).end().part().modelFile(parts.back).addModel()).condition((Property)PipeBlock.f_55150_, (Comparable[])new Boolean[]{true}).end().part().modelFile(parts.front).rotationY(90).addModel()).condition((Property)PipeBlock.f_55149_, (Comparable[])new Boolean[]{true}).end().part().modelFile(parts.back).rotationY(90).addModel()).condition((Property)PipeBlock.f_55151_, (Comparable[])new Boolean[]{true}).end();
    }

    protected void pipeItemModel(String path, PipeParts parts) {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile("block/block"));
        ItemModelBuilder front = (ItemModelBuilder)new ItemModelBuilder(null, this.itemModels().existingFileHelper).parent(parts.front);
        ItemModelBuilder center = (ItemModelBuilder)new ItemModelBuilder(null, this.itemModels().existingFileHelper).parent(parts.center);
        ItemModelBuilder back = (ItemModelBuilder)new ItemModelBuilder(null, this.itemModels().existingFileHelper).parent(parts.back);
        ((CompositeModelBuilder)builder.customLoader((itemModelBuilder, existingFileHelper) -> CompositeModelBuilder.begin(null, (ExistingFileHelper)existingFileHelper))).child("front", (ModelBuilder)front).child("center", (ModelBuilder)center).child("back", (ModelBuilder)back).end();
    }

    private void tubeBlock(RegistryObject<? extends Block> block) {
        PipeParts data = this.getPipeParts(block.getId(), "tube");
        this.pipeBlock(block, data);
        this.pipeItemModel(this.name(block), data);
    }

    private void tubeConnectorBlock(RegistryObject<? extends Block> block, RegistryObject<? extends Block> tubeBlock) {
        PipeParts data = this.getPipeParts(tubeBlock.getId(), "tube");
        ModelFile connector = this.getSingleTextureModel(block.getId(), this.modLoc("tube_connector"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.pipeBlock(block, data).part().modelFile(connector).rotationX(-90).addModel()).condition((Property)TransferenceConnectorBlock.FACING, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile(connector).rotationX(90).addModel()).condition((Property)TransferenceConnectorBlock.FACING, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile(connector).addModel()).condition((Property)TransferenceConnectorBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile(connector).rotationY(90).addModel()).condition((Property)TransferenceConnectorBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile(connector).rotationY(180).addModel()).condition((Property)TransferenceConnectorBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile(connector).rotationY(270).addModel()).condition((Property)TransferenceConnectorBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).end();
        this.pipeItemModel(this.name(block), new PipeParts(connector, data.center, data.back));
    }

    private PipeParts getBranchParts(ResourceLocation pId) {
        ResourceLocation parent = this.modLoc("branch");
        return new PipeParts(this.getSingleTextureModel(pId.m_266382_("_front"), parent.m_266382_("_front"), pId), this.getSingleTextureModel(pId.m_266382_("_center"), parent.m_266382_("_center"), pId), this.getSingleTextureModel(pId.m_266382_("_back"), parent.m_266382_("_back"), pId));
    }

    private void branchBlock(RegistryObject<? extends Block> block) {
        PipeParts data = this.getBranchParts(block.getId());
        this.pipeBlock(block, data);
        this.pipeItemModel(this.name(block), data);
    }

    private void sconceBlock(RegistryObject<? extends Block> block) {
        this.horizontalBlock((Block)block.get(), this.getSingleTextureModel(block.getId(), this.modLoc("sphere_sconce")));
        this.itemModels().basicItem(((Block)block.get()).m_5456_());
    }

    private void sphereCageBlock(RegistryObject<? extends Block> block) {
        ResourceLocation cage = this.modLoc("template_cage");
        ResourceLocation cageHanging = this.modLoc("template_cage_hanging");
        ResourceLocation path = block.getId();
        ResourceLocation hangingPath = block.getId().m_266382_("_hanging");
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Gemstone gemstone = (Gemstone)((Object)((Object)state.m_61143_(SphereCageBlock.GEMSTONE)));
            Object suffix = gemstone != Gemstone.NONE ? "_lit_" + gemstone : "";
            boolean hanging = (Boolean)state.m_61143_((Property)SphereCageBlock.HANGING);
            return ConfiguredModel.builder().modelFile(this.getSingleTextureModel((hanging ? hangingPath : path).m_266382_((String)suffix), hanging ? cageHanging : cage, path.m_266382_((String)suffix))).build();
        });
    }

    private void beadBlock(RegistryObject<? extends Block> block) {
        String name = block.getId().m_135815_();
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)CognitiveBeadsBlock.UP) != false ? this.getStormwardModel(name) : this.getStormwardModel(name + "_top")).build());
        this.simpleBlockItem((Block)block.get(), this.getStormwardModel(name + "_top"));
    }

    private void rosharanGrassBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.allYRotations((ModelFile)this.rosharanGrassBlockModel(block, this.getPlantReactionSuffix((BlockState)state)), (int)0, (boolean)false));
        this.simpleBlockItem((Block)block.get(), this.rosharanGrassBlockModel(block, ""));
    }

    private ModelFile rosharanGrassBlockModel(RegistryObject<? extends Block> block, String suffix) {
        ResourceLocation texture = this.texture(block);
        ResourceLocation top = texture.m_266382_("_top");
        ResourceLocation side = texture.m_266382_("_side");
        ResourceLocation bottom = texture.m_266382_("_bottom");
        ResourceLocation topOverlay = top.m_266382_(suffix + "_overlay");
        ResourceLocation sideOverlay = side.m_266382_(suffix + "_overlay");
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + suffix)).parent(this.getStormwardModel("rosharan_grass_block"))).texture("top", top)).texture("side", side)).texture("bottom", bottom)).texture("top_overlay", topOverlay)).texture("side_overlay", sideOverlay);
    }

    private void rosharanBushBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.crossModel(block, this.getPlantReactionSuffix((BlockState)state))).build());
        this.basicItem(block);
    }

    private ModelFile crossModel(RegistryObject<? extends Block> block) {
        return this.crossModel(block, "");
    }

    private ModelFile crossModel(RegistryObject<? extends Block> block, String suffix) {
        return ((BlockModelBuilder)this.models().singleTexture(this.name(block) + suffix, this.mcLoc("cross"), "cross", this.texture(block).m_266382_(suffix))).renderType("cutout");
    }

    private void rosharanTintedBushBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.tintedCrossModel(block, this.getPlantReactionSuffix((BlockState)state))).build());
        this.basicItem(block);
    }

    private void rosharanTintedDoublePlantBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)RosharanDoublePlantBlock.f_52858_);
            return ConfiguredModel.builder().modelFile(this.tintedCrossModel(block, (half == DoubleBlockHalf.LOWER ? "_bottom" : "_top") + this.getPlantReactionSuffix((BlockState)state))).build();
        });
        this.basicItem(block, this.texture(block).m_266382_("_top"));
    }

    private ModelFile tintedCrossModel(RegistryObject<? extends Block> block, String suffix) {
        return ((BlockModelBuilder)this.models().singleTexture(this.name(block) + suffix, this.mcLoc("tinted_cross"), "cross", this.texture(block).m_266382_(suffix))).renderType("cutout");
    }

    private String getPlantReactionSuffix(BlockState pState) {
        return switch ((PlantReaction)((Object)pState.m_61143_(IRosharanPlant.PLANT_REACTION))) {
            default -> throw new IncompatibleClassChangeError();
            case PlantReaction.RETRACTING_0, PlantReaction.EXTENDING_1 -> "_retracting_0";
            case PlantReaction.RETRACTING_1, PlantReaction.EXTENDING_0 -> "_retracting_1";
            case PlantReaction.RETRACTED -> "_retracted";
            case PlantReaction.EXTENDED -> "";
        };
    }

    private void lavisPolypBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.allYRotations((ModelFile)this.lavisPolypModel(block, (Integer)state.m_61143_((Property)LavisPolypBlock.AGE), this.getPlantReactionSuffix((BlockState)state)), (int)0, (boolean)false));
        this.simpleBlockItem((Block)block.get(), this.lavisPolypModel(block, 3, ""));
    }

    private ModelFile lavisPolypModel(RegistryObject<? extends Block> block, int stage, String suffix) {
        ResourceLocation texture = this.texture(block);
        ResourceLocation top = texture.m_266382_("_top_stage" + stage + suffix);
        ResourceLocation side = texture.m_266382_("_side_stage" + stage);
        ResourceLocation bottom = texture.m_266382_("_bottom_stage" + stage);
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + "_stage" + stage + suffix)).parent(this.getStormwardModel("polyp_stage" + stage))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
    }

    private void rockbudBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.allYRotations((ModelFile)this.rockbudModel(block, this.getPlantReactionSuffix((BlockState)state)), (int)0, (boolean)false));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.name(block))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemPrefix(block.getId()));
    }

    private ModelFile rockbudModel(RegistryObject<? extends Block> block, String suffix) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + suffix)).parent(this.getStormwardModel("template_rockbud"))).texture("rockbud", this.texture(block).m_266382_(suffix))).texture("roots", this.texture(block).m_266382_("_roots"));
    }

    private void markelLeafBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            ModelFile model = this.getStormwardModel(this.name(block) + this.getPlantReactionSuffix((BlockState)state));
            if (dir.m_122434_() == Direction.Axis.Y) {
                return ConfiguredModel.allYRotations((ModelFile)model, (int)(dir == Direction.DOWN ? 180 : 0), (boolean)false);
            }
            return ConfiguredModel.builder().modelFile(this.getStormwardModel(this.name(block) + this.getPlantReactionSuffix((BlockState)state))).rotationX(90).rotationY(((int)dir.m_122435_() + 180) % 360).build();
        });
        this.simpleBlockItem((Block)block.get(), this.getStormwardModel(this.name(block)));
    }

    private void stumpweightLeavesBlock(RegistryObject<? extends Block> block) {
        this.horizontalBlock((Block)block.get(), state -> this.getSingleTextureModel(this.modLoc(this.name(block) + this.getPlantReactionSuffix((BlockState)state)), this.modLoc("template_stumpweight_leaves")));
        this.basicItem(block);
    }

    private void detectorBlock(RegistryObject<? extends Block> block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.blockPrefix(this.mcLoc("template_daylight_detector")));
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).parent((ModelFile)parent)).texture("top", this.texture(block).m_266382_("_top"))).texture("side", this.texture(block).m_266382_("_side"));
        ModelBuilder inverted = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + "_inverted")).parent((ModelFile)parent)).texture("top", this.texture(block).m_266382_("_inverted_top"))).texture("side", this.texture(block).m_266382_("_side"));
        this.variantBlock(block, DaylightDetectorBlock.f_52378_, (ModelFile)model, (ModelFile)inverted);
        this.simpleBlockItem((Block)block.get(), (ModelFile)model);
    }

    private void shalebarkBlock(RegistryObject<? extends Block> block) {
        ResourceLocation texture = this.texture(block);
        this.horizontalBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.texture("shalebark"))).texture("big", texture)).texture("small", texture.m_266382_("_small")));
        this.basicItem(block);
    }

    private void duelingPitBarrierBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)DuelingPitBarrierBlock.UP) != false ? this.getStormwardModel("dueling_pit_barrier") : this.getStormwardModel("dueling_pit_barrier_upper")).build());
    }

    private void duelingPitBlock(RegistryObject<? extends Block> block) {
        ResourceLocation texture = this.texture(block);
        ModelBuilder closed = this.models().cubeColumn(this.name(block), texture, texture.m_266382_("_top"));
        ModelBuilder open = this.models().cubeBottomTop(this.name(block) + "_open", texture, texture.m_266382_("_top"), texture.m_266382_("_top_open"));
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> StormwardBlockStateProvider.lambda$duelingPitBlock$15((ModelFile)open, (ModelFile)closed, arg_0));
        this.simpleBlockItem((Block)block.get(), (ModelFile)closed);
    }

    private void ascenderChainBlock(RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getStormwardModel((Boolean)state.m_61143_((Property)AscenderChainBlock.SHORT) != false ? "ascender_chain_short" : "ascender_chain")).build());
    }

    private void spanswitchBlock(RegistryObject<? extends Block> block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.blockPrefix(this.modLoc("template_spanswitch")));
        ResourceLocation texture = this.texture(block);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).parent((ModelFile)parent)).texture("texture", texture)).texture("gem", texture.m_266382_("_gem"));
        ModelBuilder dunModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + "_dun")).parent((ModelFile)parent)).texture("texture", texture)).texture("gem", texture.m_266382_("_gem_dun"));
        ModelBuilder onModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + "_on")).parent((ModelFile)parent)).texture("texture", texture.m_266382_("_on"))).texture("gem", texture.m_266382_("_gem"));
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> StormwardBlockStateProvider.lambda$spanswitchBlock$17((ModelFile)dunModel, (ModelFile)onModel, (ModelFile)model, arg_0));
        this.basicStormlightStorageItem(block, this.itemPrefix(block.getId()));
    }

    private void cultivatorBlock(RegistryObject<? extends Block> block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.blockPrefix(this.modLoc("template_cultivator")));
        ResourceLocation texture = this.texture(block);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).parent((ModelFile)parent)).texture("texture", texture)).texture("gem", texture.m_266382_("_gem"));
        ModelBuilder dunModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + "_dun")).parent((ModelFile)parent)).texture("texture", texture)).texture("gem", texture.m_266382_("_gem_dun"));
        this.variantBlock(block, StormlightStorageBlock.DUN, (ModelFile)model, (ModelFile)dunModel);
        this.basicStormlightStorageItem(block, this.itemPrefix(block.getId()));
    }

    private void hangingSignBlock(Block pSignBlock, Block pWallSignBlock, ResourceLocation pTexture) {
        ModelBuilder model = this.models().sign(this.name(pSignBlock), pTexture);
        this.hangingSignBlock(pSignBlock, pWallSignBlock, (ModelFile)model);
    }

    private void hangingSignBlock(Block pSignBlock, Block pWallSignBlock, ModelFile pModel) {
        this.simpleBlock(pSignBlock, pModel);
        this.simpleBlock(pWallSignBlock, pModel);
    }

    private void family(BlockFamily pFamily) {
        Block baseBlock = pFamily.m_175951_();
        ResourceLocation baseTexture = this.blockTexture(baseBlock);
        this.simpleBlockWithItem(baseBlock, this.cubeAll(baseBlock));
        for (Map.Entry pair : pFamily.m_175954_().entrySet()) {
            Block block = (Block)pair.getValue();
            switch ((BlockFamily.Variant)pair.getKey()) {
                case FENCE: {
                    this.fenceBlock((FenceBlock)block, baseTexture);
                    this.simpleBlockItem(block, (ModelFile)this.models().singleTexture(this.blockTexture(block).m_266382_("_inventory").m_135815_(), this.blockPrefix(this.mcLoc("fence_inventory")), baseTexture));
                    break;
                }
                case FENCE_GATE: {
                    this.fenceGateBlock((FenceGateBlock)block, baseTexture);
                    this.blockItem(block);
                    break;
                }
                case WALL: {
                    this.wallBlock((WallBlock)block, baseTexture);
                    this.simpleBlockItem(block, (ModelFile)this.models().singleTexture(this.blockTexture(block).m_266382_("_inventory").m_135815_(), this.blockPrefix(this.mcLoc("wall_inventory")), "wall", baseTexture));
                    break;
                }
                case STAIRS: {
                    this.stairsBlock((StairBlock)block, baseTexture);
                    this.blockItem(block);
                    break;
                }
                case SLAB: {
                    this.slabBlock((SlabBlock)block, baseTexture, baseTexture);
                    this.blockItem(block);
                    break;
                }
                case SIGN: {
                    this.signBlock((StandingSignBlock)pFamily.m_175952_(BlockFamily.Variant.SIGN), (WallSignBlock)pFamily.m_175952_(BlockFamily.Variant.WALL_SIGN), baseTexture);
                    break;
                }
                case PRESSURE_PLATE: {
                    this.pressurePlateBlock((PressurePlateBlock)block, baseTexture);
                    this.blockItem(block);
                    break;
                }
                case BUTTON: {
                    this.buttonBlock((ButtonBlock)block, baseTexture);
                    this.simpleBlockItem(block, (ModelFile)this.models().singleTexture(this.blockTexture(block).m_266382_("_inventory").m_135815_(), this.blockPrefix(this.mcLoc("button_inventory")), baseTexture));
                    break;
                }
                case DOOR: {
                    this.doorBlockWithRenderType((DoorBlock)block, this.blockTexture(block).m_266382_("_bottom"), this.blockTexture(block).m_266382_("_top"), "cutout");
                    this.itemModels().basicItem(block.m_5456_());
                    break;
                }
                case TRAPDOOR: {
                    this.trapdoorBlockWithRenderType((TrapDoorBlock)block, this.blockTexture(block), true, "cutout");
                    this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.blockTexture(block).m_266382_("_bottom")));
                }
            }
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$spanswitchBlock$17(ModelFile dunModel, ModelFile onModel, ModelFile model, BlockState state) {
        boolean dun = (Boolean)state.m_61143_((Property)StormlightStorageBlock.DUN);
        int power = (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_);
        return ConfiguredModel.builder().modelFile(dun ? dunModel : (power > 0 ? onModel : model)).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$duelingPitBlock$15(ModelFile open, ModelFile closed, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)DuelingPitBlock.OPEN) != false ? open : closed).build();
    }

    private static /* synthetic */ ModelFile lambda$stormlightStorageHorizontalBlock$2(ModelFile dunModel, ModelFile model, BlockState state) {
        return (Boolean)state.m_61143_((Property)StormlightStorageBlock.DUN) != false ? dunModel : model;
    }

    private record PipeParts(ModelFile front, ModelFile center, ModelFile back) {
    }
}

