/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.datagen.model;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import us.amon.stormward.item.armortrim.StormwardArmorTrim;
import us.amon.stormward.item.armortrim.StormwardTrimMaterials;

public abstract class BaseItemModelProvider
extends ItemModelProvider {
    protected static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public BaseItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void handheldItem(RegistryObject<Item> item) {
        ResourceLocation resource = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)item.get())));
        this.singleTexture(item.getId().m_135815_(), this.mcLoc("item/handheld"), "layer0", resource.m_246208_("item/"));
    }

    protected void clockItem(RegistryObject<Item> item) {
        String path = "item/" + item.getId().m_135815_();
        ResourceLocation key = this.mcLoc("time");
        ResourceLocation parent = this.mcLoc("item/generated");
        ItemModelBuilder builder = (ItemModelBuilder)this.singleTexture(path, parent, "layer0", item.getId().m_246208_("item/").m_266382_("_00"));
        for (int i = 0; i < 64; ++i) {
            String name = path + String.format(Locale.ROOT, "_%02d", i);
            float value = ((float)i + 0.5f) / 64.0f;
            builder.override().predicate(key, value).model((ModelFile)((ItemModelBuilder)this.withExistingParent(name, parent)).texture("layer0", name)).end();
        }
    }

    protected void essenceDetectorItem(RegistryObject<Item> item) {
        String path = "item/" + item.getId().m_135815_();
        ResourceLocation key = this.mcLoc("angle");
        ResourceLocation parent = this.mcLoc("item/generated");
        ItemModelBuilder builder = (ItemModelBuilder)this.singleTexture(path, parent, "layer0", item.getId().m_246208_("item/").m_266382_("_00"));
        for (int i = 0; i < 20; ++i) {
            String name = path + String.format(Locale.ROOT, "_%02d", i);
            float value = (float)i / 9.0f * 0.125f;
            if (i >= 10) {
                value = 0.875f + (float)(i - 10) / 9.0f * 0.125f;
            }
            builder.override().predicate(key, value).model((ModelFile)((ItemModelBuilder)this.withExistingParent(name, parent)).texture("layer0", name)).end();
        }
        builder.override().predicate(new ResourceLocation("stormward", "inactive"), 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(path + "_inactive", parent)).texture("layer0", path + "_inactive")).end();
        builder.override().predicate(new ResourceLocation("stormward", "dun"), 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(path + "_dun", parent)).texture("layer0", path + "_dun")).end();
    }

    protected void fabrialShieldItem(RegistryObject<Item> item) {
        String path = "item/" + item.getId().m_135815_();
        ModelFile.ExistingModelFile parent = this.getExistingFile(new ResourceLocation("stormward", "fabrial_shield"));
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)parent)).texture("layer0", new ResourceLocation("stormward", path));
        this.addNewModelOverride(builder, this.mcLoc("blocking"), path + "_blocking", (ModelFile)this.getExistingFile(new ResourceLocation("stormward", "fabrial_shield_blocking")), path);
        this.addNewModelOverride(builder, new ResourceLocation("stormward", "dun"), path + "_dun", (ModelFile)parent);
    }

    protected void shardhammerItem(RegistryObject<Item> item) {
        this.twoHandedStormlightStorageItem(item, new ResourceLocation(this.modid, "shardhammer_in_hand"));
    }

    protected void shardbladeItem(RegistryObject<Item> item) {
        this.twoHandedStormlightStorageItem(item, new ResourceLocation(this.modid, "shardblade_in_hand"));
    }

    protected void twoHandedStormlightStorageItem(RegistryObject<Item> item, ResourceLocation parent) {
        String path = "item/" + item.getId().m_135815_();
        String dunPath = path + "_dun";
        this.singleOverrideSeperateTransformsItem(item, new ResourceLocation(this.modid, "dun"), this.tempItem(parent, new ResourceLocation(this.modid, path + "_in_hand")), this.separateTransformsItem(dunPath, this.tempItem(parent, new ResourceLocation(this.modid, dunPath + "_in_hand"))));
    }

    protected void spearItem(RegistryObject<Item> item) {
        String path = "item/" + item.getId().m_135815_();
        this.singleOverrideSeperateTransformsItem(item, this.mcLoc("throwing"), this.tempItem(new ResourceLocation(this.modid, "spear_in_hand"), null), this.separateTransformsItem(path + "_throwing", path, this.tempItem(new ResourceLocation(this.modid, "spear_throwing"), null)));
    }

    protected void singleOverrideSeperateTransformsItem(RegistryObject<Item> item, ResourceLocation override, ItemModelBuilder model, ItemModelBuilder overrideModel) {
        String path = "item/" + item.getId().m_135815_();
        this.separateTransformsItem(path, model).override().model((ModelFile)overrideModel).predicate(override, 1.0f).end();
    }

    protected void grandbowItem(RegistryObject<ProjectileWeaponItem> item) {
        String path = "item/" + item.getId().m_135815_();
        ResourceLocation parent = item.getId().m_266382_("_in_hand");
        ResourceLocation texture = item.getId().m_246208_("item/");
        ItemModelBuilder dunModel = this.separateTransformsItem(path + "_dun", this.tempItem(parent, texture.m_266382_("_dun_in_hand")));
        ItemModelBuilder pulling0Model = this.separateTransformsItem(path + "_pulling_0", this.tempItem(parent, texture.m_266382_("_in_hand_pulling_0")));
        ItemModelBuilder pulling1Model = this.separateTransformsItem(path + "_pulling_1", this.tempItem(parent.m_266382_("_pulling_1"), texture.m_266382_("_in_hand_pulling_1")));
        ItemModelBuilder pulling2Model = this.separateTransformsItem(path + "_pulling_2", this.tempItem(parent.m_266382_("_pulling_2"), texture.m_266382_("_in_hand_pulling_2")));
        ResourceLocation pulling = this.mcLoc("pulling");
        ResourceLocation pull = this.mcLoc("pull");
        this.separateTransformsItem(path, this.tempItem(parent, texture.m_266382_("_in_hand"))).override().model((ModelFile)dunModel).predicate(new ResourceLocation(this.modid, "dun"), 1.0f).end().override().model((ModelFile)pulling0Model).predicate(pulling, 1.0f).end().override().model((ModelFile)pulling1Model).predicate(pulling, 1.0f).predicate(pull, 0.65f).end().override().model((ModelFile)pulling2Model).predicate(pulling, 1.0f).predicate(pull, 0.9f).end();
    }

    protected ItemModelBuilder separateTransformsItem(RegistryObject<Item> item, ItemModelBuilder model) {
        return this.separateTransformsItem("item/" + item.getId().m_135815_(), model);
    }

    protected ItemModelBuilder separateTransformsItem(String path, ItemModelBuilder model) {
        return this.separateTransformsItem(path, path, model);
    }

    protected ItemModelBuilder separateTransformsItem(String path, String inventoryTexture, ItemModelBuilder model) {
        ItemModelBuilder seperateTransforms = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("particle", inventoryTexture)).guiLight(BlockModel.GuiLight.FRONT);
        ItemModelBuilder inventory = this.tempItem(new ResourceLocation(this.modid, inventoryTexture));
        ((SeparateTransformsModelBuilder)seperateTransforms.customLoader((itemModelBuilder, existingFileHelper) -> SeparateTransformsModelBuilder.begin(null, (ExistingFileHelper)existingFileHelper))).base((ModelBuilder)model).perspective(ItemDisplayContext.GUI, (ModelBuilder)inventory).perspective(ItemDisplayContext.GROUND, (ModelBuilder)inventory).perspective(ItemDisplayContext.FIXED, (ModelBuilder)inventory).end();
        return seperateTransforms;
    }

    protected ItemModelBuilder tempItem(ResourceLocation texture) {
        return this.tempItem(this.mcLoc("item/generated"), texture);
    }

    protected ItemModelBuilder tempItem(ResourceLocation parent, ResourceLocation texture) {
        ItemModelBuilder model = (ItemModelBuilder)new ItemModelBuilder(null, this.existingFileHelper).parent((ModelFile)this.getExistingFile(parent));
        if (texture != null) {
            model.texture("layer0", texture);
        }
        return model;
    }

    protected void spawnEggItem(RegistryObject<Item> item) {
        this.withExistingParent(item.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    protected void stormlightStorageItem(RegistryObject<? extends Item> item) {
        this.simpleOverrideItem(item, new ResourceLocation("stormward", "dun"));
    }

    protected void stormlightStorageItem(RegistryObject<? extends Item> item, ModelFile parent) {
        this.simpleOverrideItem(item, parent, new ResourceLocation("stormward", "dun"));
    }

    protected void handheldStormlightStorageItem(RegistryObject<Item> item) {
        this.stormlightStorageItem(item, (ModelFile)this.getExistingFile(this.mcLoc("item/handheld")));
    }

    protected void simpleOverrideItem(RegistryObject<? extends Item> item, ResourceLocation override) {
        this.simpleOverrideItem(item, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), override);
    }

    protected void simpleOverrideItem(RegistryObject<? extends Item> item, ModelFile parent, ResourceLocation override) {
        String path = "item/" + item.getId().m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent(parent)).texture("layer0", new ResourceLocation("stormward", path));
        this.addNewModelOverride(builder, override, path + "_" + override.m_135815_(), parent);
    }

    protected void trimmedShardplateItem(RegistryObject<Item> item) {
        this.trimmedArmorItem((Item)item.get(), "stormward:trims/items/shardplate_");
        this.stormlightStorageItem(item);
    }

    protected void trimmedArmorItem(RegistryObject<Item> item) {
        this.trimmedArmorItem((Item)item.get(), "trims/items/");
    }

    protected void trimmedArmorItem(Item item) {
        this.trimmedArmorItem(item, "trims/items/");
    }

    protected void trimmedArmorItem(Item item, String trimPathPrefix) {
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            String armorType = switch (armorItem.m_40402_()) {
                case EquipmentSlot.HEAD -> "helmet";
                case EquipmentSlot.CHEST -> "chestplate";
                case EquipmentSlot.LEGS -> "leggings";
                case EquipmentSlot.FEET -> "boots";
                default -> "";
            };
            String armorItemPath = "item/" + armorItem;
            ResourceLocation armorItemResLoc = new ResourceLocation(this.modid, armorItemPath);
            trimMaterials.forEach((trimMaterial, trimValue) -> {
                String trimSuffix = StormwardArmorTrim.getColorPaletteSuffix((ResourceKey<TrimMaterial>)trimMaterial, armorItem.m_40401_());
                String currentTrimName = armorItemPath + "_" + trimSuffix + "_trim";
                ResourceLocation trimResLoc = new ResourceLocation(trimPathPrefix + armorType + "_trim_" + trimSuffix);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                if (!this.modid.equals("minecraft") || !trimMaterial.m_135782_().m_135827_().equals("minecraft")) {
                    ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                }
                ((ItemModelBuilder)this.withExistingParent(armorItem.toString(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(this.modid, currentTrimName))).predicate(this.mcLoc("trim_type"), trimValue.floatValue()).end().texture("layer0", new ResourceLocation(this.modid, "item/" + armorItem));
            });
        }
    }

    protected void addNewModelOverride(ItemModelBuilder builder, ResourceLocation predicate, String name) {
        this.addNewModelOverride(builder, predicate, name, (ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
    }

    protected void addNewModelOverride(ItemModelBuilder builder, ResourceLocation predicate, String name, ModelFile parent) {
        this.addNewModelOverride(builder, predicate, name, parent, name);
    }

    protected void addNewModelOverride(ItemModelBuilder builder, ResourceLocation predicate, String name, ModelFile parent, String texture) {
        this.addNewModelOverride(builder, predicate, name, parent, "layer0", new ResourceLocation(builder.getLocation().m_135827_(), texture));
    }

    protected void addNewModelOverride(ItemModelBuilder builder, ResourceLocation predicate, String name, ModelFile parent, ResourceLocation texture) {
        this.addNewModelOverride(builder, predicate, name, parent, "layer0", texture);
    }

    protected void addNewModelOverride(ItemModelBuilder builder, ResourceLocation predicate, String name, ModelFile parent, String textureKey, ResourceLocation texture) {
        builder.override().predicate(predicate, 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(parent)).texture(textureKey, texture)).end();
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put(StormwardTrimMaterials.SMOKESTONE, Float.valueOf(0.25f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put(StormwardTrimMaterials.RUBY, Float.valueOf(0.35f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put(StormwardTrimMaterials.GARNET, Float.valueOf(0.45f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put(StormwardTrimMaterials.TOPAZ, Float.valueOf(0.55f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put(StormwardTrimMaterials.ZIRCON, Float.valueOf(0.85f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put(StormwardTrimMaterials.SAPPHIRE, Float.valueOf(0.95f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

