/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.entity.goal.CognitiveFlameWanderGoal;
import us.amon.stormward.entity.navigation.CognitiveMoveControl;
import us.amon.stormward.entity.navigation.CognitivePathNavigation;
import us.amon.stormward.sound.StormwardSoundEvents;

public class CognitiveFlame
extends PathfinderMob {
    public CognitiveFlame(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new CognitiveMoveControl((Mob)this);
        this.m_274367_(1.0f);
    }

    public static boolean checkSpawnRules(EntityType<CognitiveFlame> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_()) {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            return belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP) || belowState.m_60713_((Block)StormwardBlocks.COGNITIVE_BEADS.get());
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return CognitiveFlame.m_21552_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 4.0);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new CognitivePathNavigation((Mob)this, pLevel);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new CognitiveFlameWanderGoal(this, 0.8));
    }

    public boolean m_6673_(@NotNull DamageSource pSource) {
        return super.m_6673_(pSource) || pSource.m_276093_(DamageTypes.f_268722_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_213877_() && this.f_19796_.m_188503_(8) == 0) {
            double x = this.m_20185_();
            double y = this.m_20186_() + 1.875;
            double z = this.m_20189_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        AABB aabb = this.m_20191_().m_82406_((double)1.0E-5f);
        int overworldHeight = Math.max(Math.max(CognitiveFlame.getOverworldHeight((LevelAccessor)this.m_9236_(), Mth.m_14107_((double)aabb.f_82288_), Mth.m_14107_((double)aabb.f_82290_)), CognitiveFlame.getOverworldHeight((LevelAccessor)this.m_9236_(), Mth.m_14107_((double)aabb.f_82291_), Mth.m_14107_((double)aabb.f_82290_))), Math.max(CognitiveFlame.getOverworldHeight((LevelAccessor)this.m_9236_(), Mth.m_14107_((double)aabb.f_82288_), Mth.m_14107_((double)aabb.f_82293_)), CognitiveFlame.getOverworldHeight((LevelAccessor)this.m_9236_(), Mth.m_14107_((double)aabb.f_82291_), Mth.m_14107_((double)aabb.f_82293_))));
        Vec3 deltaMovement = this.m_20184_();
        double deltaY = this.m_20186_() + deltaMovement.f_82480_ - (double)overworldHeight;
        if (deltaY < (double)-1.0E-5f) {
            this.m_6034_(this.m_20185_(), overworldHeight, this.m_20189_());
            this.m_20334_(deltaMovement.f_82479_, 0.0, deltaMovement.f_82481_);
            this.m_20242_(true);
        } else if (deltaY > (double)1.0E-5f) {
            this.m_20242_(false);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        int overworldHeight = CognitiveFlame.getOverworldHeight((LevelAccessor)pLevel, this.m_146903_(), this.m_146907_());
        if ((double)overworldHeight > this.m_20186_()) {
            this.m_6034_(this.m_20185_(), overworldHeight, this.m_20189_());
        }
        this.m_20242_(true);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static int getOverworldHeight(LevelAccessor pLevel, int pX, int pZ) {
        int height = pLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pX, pZ);
        return 63 - (height - 63);
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(@NotNull Entity pEntity) {
    }

    protected void m_7324_(@NotNull Entity pEntity) {
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.COGNITIVE_FLAME_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.COGNITIVE_FLAME_DEATH.get();
    }

    protected int m_7302_(int pCurrentAir) {
        return super.m_7302_(pCurrentAir);
    }

    public boolean m_5825_() {
        return true;
    }

    protected float m_6118_() {
        return 0.42f;
    }

    @NotNull
    public Vec3 m_21074_(@NotNull Vec3 pDeltaMovement, float pFriction) {
        pFriction = 0.6f;
        this.m_19920_(this.m_21330_(pFriction), pDeltaMovement);
        this.m_20256_(this.m_21297_(this.m_20184_()));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 vec3 = this.m_20184_();
        if ((this.f_19862_ || this.f_20899_) && (this.m_6147_() || this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)this))) {
            vec3 = new Vec3(vec3.f_82479_, 0.2, vec3.f_82481_);
        }
        return vec3.m_82542_((double)(pFriction * 0.91f), (double)0.98f, (double)(pFriction * 0.91f));
    }

    public boolean m_147223_() {
        return true;
    }

    private Vec3 m_21297_(Vec3 pDeltaMovement) {
        if (this.m_6147_()) {
            this.m_183634_();
            double d0 = Mth.m_14008_((double)pDeltaMovement.f_82479_, (double)-0.15f, (double)0.15f);
            double d1 = Mth.m_14008_((double)pDeltaMovement.f_82481_, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(pDeltaMovement.f_82480_, (double)-0.15f);
            if (d2 < 0.0 && !this.m_146900_().isScaffolding((LivingEntity)this) && this.m_5791_()) {
                d2 = 0.0;
            }
            pDeltaMovement = new Vec3(d0, d2, d1);
        }
        return pDeltaMovement;
    }

    private float m_21330_(float pFriction) {
        return this.m_6113_() * (0.21600002f / (pFriction * pFriction * pFriction));
    }

    public boolean m_6072_() {
        return false;
    }
}

