/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.CremBlock;
import us.amon.stormward.damage.StormwardDamageSources;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.tag.StormwardBlockTags;

public class CremSludge
extends AbstractHurtingProjectile
implements ItemSupplier {
    public CremSludge(double pX, double pY, double pZ, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel) {
        super((EntityType)StormwardEntities.CREM.get(), pX, pY, pZ, pOffsetX, pOffsetY, pOffsetZ, pLevel);
    }

    public CremSludge(EntityType<? extends AbstractHurtingProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static void fallOnBlock(Level pLevel, BlockPos pPos) {
        Vec3 center = pPos.m_6630_(48).m_122030_(24).m_252807_();
        CremSludge crem = new CremSludge(center.f_82479_, center.f_82480_, center.f_82481_, -1.0, -2.0, 0.0, pLevel);
        pLevel.m_7967_((Entity)crem);
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.m_9236_().m_5776_()) {
            BlockPos hitPos = pResult.m_82425_();
            if (!this.m_9236_().m_8055_(hitPos).m_204336_(StormwardBlockTags.CREM) && (Block.m_49936_((BlockGetter)this.m_9236_(), (BlockPos)hitPos) || Block.m_49863_((LevelReader)this.m_9236_(), (BlockPos)hitPos, (Direction)Direction.UP))) {
                BlockPos placePos = hitPos.m_121945_(pResult.m_82434_());
                if (this.m_9236_().m_8055_(placePos).m_247087_()) {
                    BlockState state = ((CremBlock)((Object)StormwardBlocks.CREM.get())).m_49966_();
                    this.m_9236_().m_46597_(placePos, state);
                    CremSludge.playLandEffects(this.m_9236_(), placePos, state, 20.0f, pResult.m_82434_().m_122424_());
                }
            }
        }
    }

    public static void playLandEffects(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, float pFallDistance, Direction pDirection) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            SoundEvent sound = ((CremBlock)((Object)StormwardBlocks.CREM.get())).getSoundType(pState, (LevelReader)pLevel, pPos, null).m_56777_();
            serverLevel.m_5594_(null, pPos, sound, SoundSource.BLOCKS, 0.3f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
            double d4 = 0.2f + (float)Mth.m_14167_((float)pFallDistance) / 15.0f;
            int i = (int)(150.0 * d4);
            Vec3 center = pPos.m_252807_().m_231075_(pDirection, 0.5);
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, pState).setPos(pPos), center.f_82479_, center.f_82480_, center.f_82481_, i, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.m_9236_().m_5776_()) {
            Entity entity = pResult.m_82443_();
            DamageSource source = StormwardDamageSources.highstorm(this.m_9236_());
            entity.m_6469_(source, 4.0f);
        }
    }

    @NotNull
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)StormwardItems.CREM_SLUDGE.get());
    }

    protected boolean m_5931_() {
        return false;
    }

    @NotNull
    protected ParticleOptions m_5967_() {
        return new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_());
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return false;
    }
}

