/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain;

import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.entity.shardbearer.Shardbearer;
import us.amon.stormward.entity.spren.overworld.Angerspren;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.weapon.TwoHandedWeaponItem;

public class ShardbearerAi {
    private static final TargetingConditions GRANDBOW_TARGET_CONDITIONS = TargetingConditions.m_148352_().m_26883_(30.0);
    private static final TargetingConditions GRANDBOW_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = TargetingConditions.m_148352_().m_26883_(30.0).m_26893_();
    private static final TargetingConditions GRANDBOW_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = TargetingConditions.m_148352_().m_26883_(30.0).m_148355_();
    private static final TargetingConditions GRANDBOW_TARGET_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT = TargetingConditions.m_148352_().m_26883_(30.0).m_148355_().m_26893_();

    public static boolean hasRangedWeapon(LivingEntity pEntity) {
        return ShardbearerAi.hasBow(pEntity) || ShardbearerAi.hasCrossbow(pEntity);
    }

    public static boolean hasBow(LivingEntity pEntity) {
        return pEntity.m_21093_(stack -> stack.m_150930_((Item)StormwardItems.GRANDBOW.get()) && !StormlightStorageHelper.isDun((ICapabilityProvider)stack) || stack.m_41720_() instanceof BowItem);
    }

    public static boolean hasCrossbow(LivingEntity pEntity) {
        return pEntity.m_21093_(stack -> stack.m_41720_() instanceof CrossbowItem);
    }

    public static boolean hasMeleeWeapon(LivingEntity pEntity) {
        return pEntity.m_21093_(stack -> stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof TwoHandedWeaponItem);
    }

    public static boolean hasTwoHandedWeapon(LivingEntity pEntity) {
        return pEntity.m_21093_(stack -> stack.m_41720_() instanceof TwoHandedWeaponItem);
    }

    public static boolean isEntityAttackable(LivingEntity pAttacker, LivingEntity pTarget) {
        return pAttacker.m_21055_((Item)StormwardItems.GRANDBOW.get()) ? ShardbearerAi.isEntityAttackableWithGrandbow(pAttacker, pTarget) : Sensor.m_148312_((LivingEntity)pAttacker, (LivingEntity)pTarget);
    }

    public static boolean isEntityAttackableWithGrandbow(LivingEntity pAttacker, LivingEntity pTarget) {
        return pAttacker.m_6274_().m_21938_(MemoryModuleType.f_26372_, (Object)pTarget) ? GRANDBOW_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.m_26885_(pAttacker, pTarget) : GRANDBOW_TARGET_CONDITIONS.m_26885_(pAttacker, pTarget);
    }

    public static boolean isEntityAttackableIgnoringLineOfSight(LivingEntity pAttacker, LivingEntity pTarget) {
        return pAttacker.m_21055_((Item)StormwardItems.GRANDBOW.get()) ? ShardbearerAi.isEntityAttackableWithGrandbowIgnoringLineOfSight(pAttacker, pTarget) : Sensor.m_182377_((LivingEntity)pAttacker, (LivingEntity)pTarget);
    }

    public static boolean isEntityAttackableWithGrandbowIgnoringLineOfSight(LivingEntity pAttacker, LivingEntity pTarget) {
        return pAttacker.m_6274_().m_21938_(MemoryModuleType.f_26372_, (Object)pTarget) ? GRANDBOW_TARGET_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.m_26885_(pAttacker, pTarget) : GRANDBOW_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.m_26885_(pAttacker, pTarget);
    }

    protected static void maybeRetaliate(Shardbearer pShardbearer, LivingEntity pTarget, List<? extends Shardbearer> pOthers) {
        if (ShardbearerAi.isEntityAttackableIgnoringLineOfSight((LivingEntity)pShardbearer, pTarget) && !BehaviorUtils.m_22598_((LivingEntity)pShardbearer, (LivingEntity)pTarget, (double)4.0)) {
            if (pTarget.m_6095_() == EntityType.f_20532_ && pShardbearer.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                ShardbearerAi.setAngerTargetToNearestTargetablePlayerIfFound(pShardbearer, pTarget);
                ShardbearerAi.broadcastUniversalAnger(pOthers);
            } else {
                ShardbearerAi.setAngerTarget((LivingEntity)pShardbearer, pTarget);
                ShardbearerAi.broadcastAngerTarget(pOthers, pTarget);
            }
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(Shardbearer pShardbearer, LivingEntity pCurrentTarget) {
        Optional<Player> optional = ShardbearerAi.getNearestVisibleTargetablePlayer(pShardbearer);
        if (optional.isPresent()) {
            ShardbearerAi.setAngerTarget((LivingEntity)pShardbearer, (LivingEntity)optional.get());
        } else {
            ShardbearerAi.setAngerTarget((LivingEntity)pShardbearer, pCurrentTarget);
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(Shardbearer pShardbearer, LivingEntity pCurrentTarget) {
        Optional<LivingEntity> optional = ShardbearerAi.getAngerTarget((LivingEntity)pShardbearer);
        LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)pShardbearer, optional, (LivingEntity)pCurrentTarget);
        if (optional.isEmpty() || optional.get() != livingentity) {
            ShardbearerAi.setAngerTarget((LivingEntity)pShardbearer, livingentity);
        }
    }

    protected static void broadcastAngerTarget(List<? extends Shardbearer> pOthers, LivingEntity pTarget) {
        pOthers.forEach(entity -> ShardbearerAi.setAngerTargetIfCloserThanCurrent(entity, pTarget));
    }

    protected static void broadcastUniversalAnger(List<? extends Shardbearer> pOthers) {
        pOthers.forEach(entity -> ShardbearerAi.getNearestVisibleTargetablePlayer(entity).ifPresent(player -> ShardbearerAi.setAngerTarget((LivingEntity)entity, (LivingEntity)player)));
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(Shardbearer pShardbearer) {
        return pShardbearer.m_6274_().m_21874_(MemoryModuleType.f_148206_) ? pShardbearer.m_6274_().m_21952_(MemoryModuleType.f_148206_) : Optional.empty();
    }

    protected static void setAngerTarget(LivingEntity pEntity, LivingEntity pTarget) {
        if (ShardbearerAi.isEntityAttackableIgnoringLineOfSight(pEntity, pTarget)) {
            pEntity.m_6274_().m_21936_(MemoryModuleType.f_26326_);
            pEntity.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)pTarget.m_20148_(), 600L);
            if (pTarget.m_6095_() == EntityType.f_20532_ && pEntity.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                pEntity.m_6274_().m_21882_(MemoryModuleType.f_26335_, (Object)true, 600L);
            }
            Angerspren.tryAddForEntity(pEntity);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(LivingEntity pEntity) {
        return BehaviorUtils.m_22610_((LivingEntity)pEntity, (MemoryModuleType)MemoryModuleType.f_26334_);
    }
}

