/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.VillageBoundRandomStroll;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.schedule.Activity;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.brain.ShardbearerAi;
import us.amon.stormward.entity.brain.activity.StormwardActivities;
import us.amon.stormward.entity.brain.behavior.BowAttack;
import us.amon.stormward.entity.brain.behavior.LongDistancePatrol;
import us.amon.stormward.entity.brain.behavior.NoShelterPanic;
import us.amon.stormward.entity.brain.behavior.SetWalkTargetToShelter;
import us.amon.stormward.entity.brain.memory.StormwardMemoryModules;
import us.amon.stormward.entity.shardbearer.AlethiSoldier;
import us.amon.stormward.sound.StormwardSoundEvents;

public class SoldierAi
extends ShardbearerAi {
    private static final TargetingConditions CHALLENGER_TARGET_CONDITIONS = TargetingConditions.m_148352_().m_148355_().m_26893_();

    public static Brain<?> makeBrain(AlethiSoldier pSoldier, Brain<AlethiSoldier> pBrain) {
        SoldierAi.initCoreActivity(pBrain);
        SoldierAi.initIdleActivity(pBrain);
        SoldierAi.initFightActivity(pSoldier, pBrain);
        SoldierAi.initPatrolActivity(pBrain);
        SoldierAi.initHideActivity(pBrain);
        pBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        pBrain.m_21944_(Activity.f_37979_);
        pBrain.m_21962_();
        return pBrain;
    }

    public static void initMemories(AlethiSoldier pSoldier, RandomSource pRandom) {
    }

    private static void initCoreActivity(Brain<AlethiSoldier> pBrain) {
        pBrain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new Swim(0.8f), (Object)InteractWithDoor.m_257893_(), (Object)StopBeingAngryIfTargetDead.m_257993_()));
    }

    private static void initIdleActivity(Brain<AlethiSoldier> pBrain) {
        pBrain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257741_(AlethiSoldier::canStartAttacking, SoldierAi::findNearestValidAttackTarget), SoldierAi.createIdleLookBehaviors(), SoldierAi.createIdleMovementBehaviors(), (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)));
    }

    private static void initFightActivity(AlethiSoldier pSoldier, Brain<AlethiSoldier> pBrain) {
        pBrain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257990_(entity -> !SoldierAi.isNearestValidAttackTarget(pSoldier, entity)), (Object)BehaviorBuilder.m_257845_(ShardbearerAi::hasRangedWeapon, (OneShot)BackUpIfTooClose.m_257698_((int)5, (float)0.75f)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)MeleeAttack.m_257733_((int)20), (Object)new CrossbowAttack(), new BowAttack()), MemoryModuleType.f_26372_);
    }

    private static void initPatrolActivity(Brain<AlethiSoldier> pBrain) {
        pBrain.m_21891_((Activity)StormwardActivities.PATROL.get(), 10, ImmutableList.of((Object)StartAttacking.m_257741_(AlethiSoldier::canStartAttacking, SoldierAi::findNearestValidAttackTarget), SoldierAi.createIdleLookBehaviors(), new LongDistancePatrol(0.7f, 0.595f), (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)));
    }

    private static void initHideActivity(Brain<AlethiSoldier> pBrain) {
        pBrain.m_21895_(Activity.f_37987_, 10, ImmutableList.of((Object)StartAttacking.m_257741_(AlethiSoldier::canStartAttacking, SoldierAi::findNearestValidAttackTarget), SetWalkTargetToShelter.create(1.0f), (Object)((Object)new NoShelterPanic(1.0f))), (MemoryModuleType)StormwardMemoryModules.EXPOSED_TO_HIGHSTORM.get());
    }

    private static BehaviorControl<LivingEntity> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.builder().add((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f), (Object)1)).add((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()), (float)8.0f), (Object)1)).add((Object)Pair.of((Object)SetEntityLookTarget.m_257660_((float)8.0f), (Object)1)).add((Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)).build());
    }

    private static RunOne<AlethiSoldier> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)VillageBoundRandomStroll.m_257910_((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.6f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(AlethiSoldier pSoldier) {
        Brain<AlethiSoldier> brain = pSoldier.m_6274_();
        Activity prevActivity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37987_, (Object)Activity.f_37979_));
        Activity activity = brain.m_21968_().orElse(null);
        if (pSoldier.isPatrolling() && activity == Activity.f_37979_) {
            brain.m_21889_((Activity)StormwardActivities.PATROL.get());
            activity = (Activity)StormwardActivities.PATROL.get();
        }
        if (prevActivity != activity) {
            SoldierAi.getSoundForCurrentActivity(pSoldier).ifPresent(pSoldier::playSoundEvent);
        }
        pSoldier.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    public static void wasHurtBy(AlethiSoldier pSoldier, LivingEntity pTarget) {
        if (!(pTarget instanceof AlethiSoldier) && pSoldier.getDuel() == null) {
            SoldierAi.maybeRetaliate(pSoldier, pTarget, SoldierAi.getAlethiSoldiers(pSoldier));
        }
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(AlethiSoldier pSoldier) {
        Brain<AlethiSoldier> brain = pSoldier.m_6274_();
        Optional nearestChallenger = brain.m_21952_((MemoryModuleType)StormwardMemoryModules.NEAREST_CHALLENGER.get());
        if (nearestChallenger.isPresent() && CHALLENGER_TARGET_CONDITIONS.m_26885_((LivingEntity)pSoldier, (LivingEntity)nearestChallenger.get())) {
            return nearestChallenger;
        }
        Optional angryAt = BehaviorUtils.m_22610_((LivingEntity)pSoldier, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (angryAt.isPresent() && SoldierAi.isEntityAttackableIgnoringLineOfSight((LivingEntity)pSoldier, (LivingEntity)angryAt.get())) {
            return angryAt;
        }
        Optional attacker = brain.m_21952_((MemoryModuleType)StormwardMemoryModules.VILLAGE_ATTACKER.get());
        if (attacker.isPresent() && SoldierAi.isEntityAttackableIgnoringLineOfSight((LivingEntity)pSoldier, (LivingEntity)attacker.get())) {
            return attacker;
        }
        Optional nearestTarget = brain.m_21952_(MemoryModuleType.f_148194_);
        if (nearestTarget.isPresent() && SoldierAi.isEntityAttackable((LivingEntity)pSoldier, (LivingEntity)nearestTarget.get())) {
            return nearestTarget;
        }
        return Optional.empty();
    }

    private static boolean isNearestValidAttackTarget(AlethiSoldier pSoldier, LivingEntity pTarget) {
        return SoldierAi.findNearestValidAttackTarget(pSoldier).filter(entity -> entity == pTarget).isPresent();
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(AlethiSoldier pSoldier) {
        return pSoldier.m_6274_().m_21968_().map(SoldierAi::getSoundForActivity);
    }

    private static SoundEvent getSoundForActivity(Activity pActivity) {
        if (pActivity == Activity.f_37988_) {
            return (SoundEvent)StormwardSoundEvents.ALETHI_SOLDIER_ANGRY.get();
        }
        return (SoundEvent)StormwardSoundEvents.ALETHI_SOLDIER_AMBIENT.get();
    }

    public static Optional<Integer> getSoundIntervalForCurrentActivity(AlethiSoldier pSoldier) {
        return pSoldier.m_6274_().m_21968_().map(SoldierAi::getSoundIntervalForActivity);
    }

    private static int getSoundIntervalForActivity(Activity pActivity) {
        if (pActivity == Activity.f_37988_) {
            return 120;
        }
        return 80;
    }

    private static List<AlethiSoldier> getAlethiSoldiers(AlethiSoldier pSoldier) {
        return (List)pSoldier.m_6274_().m_21952_((MemoryModuleType)StormwardMemoryModules.NEARBY_ALETHI_SOLDIERS.get()).orElse(ImmutableList.of());
    }
}

