/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.brain.memory.StormwardMemoryModules;
import us.amon.stormward.entity.patrol.IPatroller;

public class LongDistancePatrol<T extends PathfinderMob>
extends Behavior<T> {
    private final float speedModifier;
    private final float leaderSpeedModifier;

    public LongDistancePatrol(float pSpeedModifier, float pLeaderSpeedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)StormwardMemoryModules.PATROL_COMPANIONS.get()), (Object)MemoryStatus.REGISTERED), 1200);
        this.speedModifier = pSpeedModifier;
        this.leaderSpeedModifier = pLeaderSpeedModifier;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel pLevel, @NotNull T pOwner) {
        return ((IPatroller)pOwner).isPatrolling();
    }

    protected boolean canStillUse(@NotNull ServerLevel pLevel, @NotNull T pEntity, long pGameTime) {
        return this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void tick(@NotNull ServerLevel pLevel, @NotNull T pOwner, long pGameTime) {
        if (pOwner.m_21573_().m_26571_()) {
            BlockPos target = ((IPatroller)pOwner).getPatrolTarget();
            if (target == null) {
                return;
            }
            Brain brain = pOwner.m_6274_();
            Optional companions = brain.m_21952_((MemoryModuleType)StormwardMemoryModules.PATROL_COMPANIONS.get());
            if (companions.isPresent() && ((List)companions.get()).isEmpty()) {
                ((IPatroller)pOwner).setPatrolTarget(null);
                return;
            }
            if (((IPatroller)pOwner).isPatrolLeader() && target.m_203195_((Position)pOwner.m_20182_(), 10.0)) {
                ((IPatroller)pOwner).findPatrolTarget();
                return;
            }
            Vec3 targetVec = Vec3.m_82539_((Vec3i)target);
            Vec3 mobVec = pOwner.m_20182_();
            Vec3 deltaVec = mobVec.m_82546_(targetVec);
            targetVec = deltaVec.m_82524_(90.0f).m_82490_(0.4).m_82549_(targetVec);
            Vec3 newTargetVec = targetVec.m_82546_(mobVec).m_82541_().m_82490_(10.0).m_82549_(mobVec);
            BlockPos newTarget = BlockPos.m_274446_((Position)newTargetVec);
            newTarget = pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, newTarget);
            brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(newTarget, ((IPatroller)pOwner).isPatrolLeader() ? this.leaderSpeedModifier : this.speedModifier, 1));
            if (((IPatroller)pOwner).isPatrolLeader() && companions.isPresent()) {
                for (IPatroller companion : (List)companions.get()) {
                    companion.setPatrolTarget(newTarget);
                }
            }
        }
    }
}

