/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain.memory;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import us.amon.stormward.entity.patrol.IPatroller;
import us.amon.stormward.entity.shardbearer.AlethiSoldier;
import us.amon.stormward.entity.shardbearer.WarformListener;

public class StormwardMemoryModules {
    public static final DeferredRegister<MemoryModuleType<?>> MEMORY_MODULES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MEMORY_MODULE_TYPES, (String)"stormward");
    public static final RegistryObject<MemoryModuleType<List<WarformListener>>> NEARBY_WARFORM_LISTENERS = StormwardMemoryModules.registerModule("nearby_warform_listeners");
    public static final RegistryObject<MemoryModuleType<LivingEntity>> NEAREST_TARGETABLE_PLAYER_WEARING_CARAPACE = StormwardMemoryModules.registerModule("nearest_targetable_player_wearing_carapace");
    public static final RegistryObject<MemoryModuleType<BlockPos>> GEMHEART = StormwardMemoryModules.registerModule("gemheart");
    public static final RegistryObject<MemoryModuleType<Boolean>> EXTRACTOR = StormwardMemoryModules.registerModule("extractor");
    public static final RegistryObject<MemoryModuleType<Boolean>> EXTRACTING_GEMHEART = StormwardMemoryModules.registerModule("extracting_gemheart");
    public static final RegistryObject<MemoryModuleType<Boolean>> CELEBRATING = StormwardMemoryModules.registerModule("celebrating");
    public static final RegistryObject<MemoryModuleType<Boolean>> EXPOSED_TO_HIGHSTORM = StormwardMemoryModules.registerModule("in_highstorm");
    public static final RegistryObject<MemoryModuleType<BlockPos>> SHELTER = StormwardMemoryModules.registerModule("shelter");
    public static final RegistryObject<MemoryModuleType<List<AlethiSoldier>>> NEARBY_ALETHI_SOLDIERS = StormwardMemoryModules.registerModule("nearby_alethi_soldiers");
    public static final RegistryObject<MemoryModuleType<Player>> NEAREST_CHALLENGER = StormwardMemoryModules.registerModule("nearest_challenger");
    public static final RegistryObject<MemoryModuleType<List<IPatroller>>> PATROL_COMPANIONS = StormwardMemoryModules.registerModule("patrol_companions");
    public static final RegistryObject<MemoryModuleType<Player>> VILLAGE_ATTACKER = StormwardMemoryModules.registerModule("village_attacker");

    private static <U> RegistryObject<MemoryModuleType<U>> registerModule(String pIdentifier) {
        return StormwardMemoryModules.registerModule(pIdentifier, Optional.empty());
    }

    private static <U> RegistryObject<MemoryModuleType<U>> registerModule(String pIdentifier, Optional<Codec<U>> pCodec) {
        return MEMORY_MODULES.register(pIdentifier, () -> new MemoryModuleType(pCodec));
    }

    public static void register(IEventBus eventBus) {
        MEMORY_MODULES.register(eventBus);
    }
}

