/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.chasmfiend;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.attribute.StormwardAttributes;
import us.amon.stormward.block.MeatBlock;
import us.amon.stormward.damage.StormwardDamageTypes;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.chasmfiend.ChasmfiendLeg;
import us.amon.stormward.entity.chasmfiend.ChasmfiendPart;
import us.amon.stormward.entity.chasmfiend.LargeMonster;
import us.amon.stormward.entity.chasmfiend.goal.DigGoal;
import us.amon.stormward.entity.chasmfiend.goal.EatLureGoal;
import us.amon.stormward.entity.chasmfiend.goal.EmergeGoal;
import us.amon.stormward.entity.chasmfiend.goal.LargeMonsterFloatGoal;
import us.amon.stormward.entity.chasmfiend.goal.LegAttackGoal;
import us.amon.stormward.entity.chasmfiend.goal.RoarAttackGoal;
import us.amon.stormward.entity.shardbearer.AlethiSoldier;
import us.amon.stormward.entity.shardbearer.WarformListener;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.sound.StormwardSoundEvents;

public class Chasmfiend
extends LargeMonster {
    public static double LEG_ATTACK_RANGE = 10.0;
    public static double ROAR_RANGE = 24.0;
    private static final EntityDataAccessor<Byte> DATA_CLIMBING = SynchedEntityData.m_135353_(Chasmfiend.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_ATTACKING_LEFT = SynchedEntityData.m_135353_(Chasmfiend.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ATTACKING_RIGHT = SynchedEntityData.m_135353_(Chasmfiend.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_LEFTLEG1_HEALTH = SynchedEntityData.m_135353_(Chasmfiend.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_RIGHTLEG1_HEALTH = SynchedEntityData.m_135353_(Chasmfiend.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_LEFTLEG2_HEALTH = SynchedEntityData.m_135353_(Chasmfiend.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_RIGHTLEG2_HEALTH = SynchedEntityData.m_135353_(Chasmfiend.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    public AnimationState emergeState = new AnimationState();
    public AnimationState digState = new AnimationState();
    public final AnimationState roarState = new AnimationState();
    public final AnimationState biteState = new AnimationState();
    public final AnimationState leftAttackState = new AnimationState();
    public final AnimationState rightAttackState = new AnimationState();
    public final ChasmfiendLeg leftLeg1;
    public final ChasmfiendLeg rightLeg1;
    public final ChasmfiendLeg leftLeg2;
    public final ChasmfiendLeg rightLeg2;
    public final ChasmfiendLeg[] legs;
    private final ChasmfiendPart tail1;
    private final ChasmfiendPart tail2;
    private final ChasmfiendPart tail3;
    private final ChasmfiendPart head;
    private final ChasmfiendPart[] subEntities;
    public float xTailRot;
    public float yTailRot;
    public float xTailRotO;
    public float yTailRotO;
    private Optional<BlockPos> lurePos = Optional.empty();
    private BlockPattern.BlockPatternMatch lureMatch;
    private boolean ateLure = false;

    public Chasmfiend(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super((EntityType<? extends Monster>)((EntityType)StormwardEntities.CHASMFIEND.get()), pLevel);
        this.leftLeg1 = new ChasmfiendLeg(this, 3.0f, 6.0f, Leg.FRONT_LEFT_LEG, DATA_LEFTLEG1_HEALTH);
        this.rightLeg1 = new ChasmfiendLeg(this, 3.0f, 6.0f, Leg.FRONT_RIGHT_LEG, DATA_RIGHTLEG1_HEALTH);
        this.leftLeg2 = new ChasmfiendLeg(this, 3.0f, 6.0f, Leg.BACK_LEFT_LEG, DATA_LEFTLEG2_HEALTH);
        this.rightLeg2 = new ChasmfiendLeg(this, 3.0f, 6.0f, Leg.BACK_RIGHT_LEG, DATA_RIGHTLEG2_HEALTH);
        this.legs = new ChasmfiendLeg[]{this.leftLeg1, this.rightLeg1, this.leftLeg2, this.rightLeg2};
        this.tail1 = new ChasmfiendPart(this, 3.0f, 3.0f);
        this.tail2 = new ChasmfiendPart(this, 2.5f, 2.5f);
        this.tail3 = new ChasmfiendPart(this, 2.25f, 2.25f);
        this.head = new ChasmfiendPart(this, 4.5f, 4.5f);
        this.subEntities = new ChasmfiendPart[]{this.leftLeg1, this.rightLeg1, this.leftLeg2, this.rightLeg2, this.tail1, this.tail2, this.tail3, this.head};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.f_21364_ = 50;
        this.m_274367_(2.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Chasmfiend.m_33035_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)StormwardAttributes.JUMP_HEIGHT_ADDITION.get(), 4.25);
    }

    public static boolean checkSpawnRules(EntityType<Chasmfiend> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Chasmfiend.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLIMBING, (Object)0);
        this.f_19804_.m_135372_(DATA_ATTACKING_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ATTACKING_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_LEFTLEG1_HEALTH, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_RIGHTLEG1_HEALTH, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_LEFTLEG2_HEALTH, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_RIGHTLEG2_HEALTH, (Object)Float.valueOf(1.0f));
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(pId + i + 1);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new EmergeGoal(this, 40));
        this.f_21345_.m_25352_(1, (Goal)new DigGoal(this, 40));
        this.f_21345_.m_25352_(2, (Goal)new LargeMonsterFloatGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RoarAttackGoal(this, 50, 200, ROAR_RANGE));
        this.f_21345_.m_25352_(4, (Goal)new LegAttackGoal(this, 15, 60, LEG_ATTACK_RANGE, 30.0f, 2.5f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new EatLureGoal(this, 1.0, 8.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WarformListener.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AlethiSoldier.class, false, false));
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ListTag legsTag = new ListTag();
        for (ChasmfiendLeg leg : this.legs) {
            CompoundTag legTag = new CompoundTag();
            legTag.m_128350_("Health", leg.getHealth());
            legsTag.add((Object)legTag);
        }
        pCompound.m_128365_("Legs", (Tag)legsTag);
        if (this.getLurePos().isPresent()) {
            pCompound.m_128365_("LurePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getLurePos().get()));
        }
        pCompound.m_128379_("AteLure", this.hasAteLure());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ListTag legsTag = pCompound.m_128437_("Legs", 10);
        for (int i = 0; i < legsTag.size(); ++i) {
            CompoundTag leg = legsTag.m_128728_(i);
            this.legs[i].setHealth(leg.m_128457_("Health"));
        }
        if (pCompound.m_128441_("LurePos")) {
            this.setLurePos(NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("LurePos")));
        }
        this.setAteLure(pCompound.m_128471_("AteLure"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.xTailRot = 0.0f;
        this.yTailRot = this.f_20883_;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (this.m_9236_().f_46443_) {
            this.updateSyncedDataAnim(pKey, DATA_ATTACKING_LEFT, this.leftAttackState);
            this.updateSyncedDataAnim(pKey, DATA_ATTACKING_RIGHT, this.rightAttackState);
            if (f_19806_.equals(pKey)) {
                switch (this.m_20089_()) {
                    case EMERGING: {
                        this.emergeState.m_216977_(this.f_19797_);
                        break;
                    }
                    case DIGGING: {
                        this.digState.m_216977_(this.f_19797_);
                    }
                    case ROARING: {
                        this.roarState.m_216977_(this.f_19797_);
                    }
                }
            }
        }
        if (this.legs != null) {
            for (ChasmfiendLeg leg : this.legs) {
                leg.m_7350_(pKey);
            }
        }
    }

    protected void updateSyncedDataAnim(EntityDataAccessor<?> pKey, EntityDataAccessor<Boolean> pAccessor, AnimationState pState) {
        if (pKey == pAccessor) {
            if (((Boolean)this.f_19804_.m_135370_(pAccessor)).booleanValue()) {
                pState.m_216977_(this.f_19797_);
            } else {
                pState.m_216973_();
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.TRIGGERED) {
            this.m_20124_(Pose.EMERGING);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public ChasmfiendPart[] getSubEntities() {
        return this.subEntities;
    }

    public void m_6075_() {
        super.m_6075_();
        for (ChasmfiendPart part : this.subEntities) {
            part.subEntityTick();
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.lurePos.isPresent() && (this.getLureMatch() == null || !MeatBlock.checkPatternBlocks(this.m_9236_(), this.getLureMatch()))) {
            this.setAteLure(false);
            this.setLurePos(null);
            this.lureMatch = null;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.biteState.m_246184_(this.f_20911_, this.f_19797_);
            switch (this.m_20089_()) {
                case EMERGING: {
                    this.clientDiggingParticles(this.emergeState);
                    break;
                }
                case DIGGING: {
                    this.clientDiggingParticles(this.digState);
                }
            }
        } else {
            this.setClimbing(this.f_19862_);
        }
        if (!(this.m_213877_() || this.m_21224_() || this.m_21525_())) {
            int i;
            Vec3[] avec3 = new Vec3[this.subEntities.length];
            for (int i2 = 0; i2 < this.subEntities.length; ++i2) {
                avec3[i2] = new Vec3(this.subEntities[i2].m_20185_(), this.subEntities[i2].m_20186_(), this.subEntities[i2].m_20189_());
            }
            float yRot = this.f_20883_ * ((float)Math.PI / 180);
            float xRot = 0.0f;
            if (this.m_9236_().f_46443_) {
                int animTicks;
                if (this.isRoaring() && (animTicks = Mth.m_14143_((float)((float)this.roarState.m_216981_() / 1000.0f * 20.0f))) >= 10 && animTicks <= 30 && animTicks % 3 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)StormwardParticles.ROAR.get(), this.m_20185_() - (double)Mth.m_14031_((float)yRot) * 8.8, this.m_20186_() + 8.8, this.m_20189_() + (double)Mth.m_14089_((float)yRot) * 8.8, 0.39269908169872414, (double)yRot, 0.0);
                }
                this.playLegAttackEffects(Leg.FRONT_LEFT_LEG, yRot);
                this.playLegAttackEffects(Leg.FRONT_RIGHT_LEG, yRot);
            }
            this.tickPart(this.head, yRot, 0.0f, 3.0f, 7.0f);
            this.tickPart(this.leftLeg1, yRot, -5.0f, 0.0f, 4.5f);
            this.tickPart(this.rightLeg1, yRot, 5.0f, 0.0f, 4.5f);
            this.tickPart(this.leftLeg2, yRot, -5.0f, 0.0f, 1.5f);
            this.tickPart(this.rightLeg2, yRot, 5.0f, 0.0f, 1.5f);
            this.xTailRotO = this.xTailRot;
            this.xTailRot *= 0.75f;
            this.xTailRot += (float)(this.f_19855_ - this.m_20186_()) * 20.0f;
            this.xTailRot = Mth.m_14036_((float)this.xTailRot, (float)-80.0f, (float)80.0f);
            this.yTailRotO = this.yTailRot;
            this.yTailRot *= 0.75f;
            this.yTailRot += (this.f_20884_ - this.f_20883_) * 2.0f;
            this.yTailRot = Mth.m_14177_((float)this.yTailRot);
            float xTail = Mth.m_14031_((float)yRot) * 3.0f;
            float yTail = 2.5f;
            float zTail = -Mth.m_14089_((float)yRot) * 3.0f;
            for (i = 0; i < 3; ++i) {
                yTail += 2.5f * Mth.m_14031_((float)(xRot += this.xTailRot * ((float)Math.PI / 180) / 3.0f));
                float horizontalRad = 2.5f * Mth.m_14089_((float)xRot);
                xTail += horizontalRad * Mth.m_14031_((float)(yRot += this.yTailRot * ((float)Math.PI / 180) / 3.0f));
                zTail -= horizontalRad * Mth.m_14089_((float)yRot);
                this.tickPart(switch (i) {
                    case 0 -> this.tail1;
                    case 1 -> this.tail2;
                    default -> this.tail3;
                }, xTail, yTail, zTail);
            }
            for (i = 0; i < this.subEntities.length; ++i) {
                this.subEntities[i].f_19854_ = avec3[i].f_82479_;
                this.subEntities[i].f_19855_ = avec3[i].f_82480_;
                this.subEntities[i].f_19856_ = avec3[i].f_82481_;
                this.subEntities[i].f_19790_ = avec3[i].f_82479_;
                this.subEntities[i].f_19791_ = avec3[i].f_82480_;
                this.subEntities[i].f_19792_ = avec3[i].f_82481_;
            }
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIMBING) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_CLIMBING);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_CLIMBING, (Object)b0);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void tickPart(ChasmfiendPart pPart, float yRot, float pX, float pY, float pZ) {
        float bodyX = -pX * Mth.m_14089_((float)yRot) - pZ * Mth.m_14031_((float)yRot);
        float bodyZ = -pX * Mth.m_14031_((float)yRot) + pZ * Mth.m_14089_((float)yRot);
        this.tickPart(pPart, bodyX, pY, bodyZ);
    }

    private void tickPart(ChasmfiendPart pPart, double pOffsetX, double pOffsetY, double pOffsetZ) {
        pPart.m_6034_(this.m_20185_() + pOffsetX, this.m_20186_() + pOffsetY, this.m_20189_() + pOffsetZ);
    }

    public void m_246865_(@NotNull Vec3 pAddend) {
        if (pAddend.m_82556_() > 0.010000000000000002) {
            super.m_246865_(pAddend);
        }
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_276093_(StormwardDamageTypes.HIGHSTORM) || super.m_6673_(pSource);
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_().m_82377_(8.0, 0.0, 8.0);
    }

    @NotNull
    protected AABB m_292684_() {
        return super.m_292684_().m_82377_(4.0, 0.0, 4.0);
    }

    protected void m_21203_() {
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= 15) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
    }

    public void m_6457_(@NotNull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(@NotNull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void setLurePos(BlockPos pPos) {
        this.lurePos = Optional.ofNullable(pPos);
        if (pPos != null) {
            this.lureMatch = MeatBlock.getOrCreateLurePattern().m_61184_((LevelReader)this.m_9236_(), pPos);
        }
    }

    public Optional<BlockPos> getLurePos() {
        return this.lurePos;
    }

    public BlockPattern.BlockPatternMatch getLureMatch() {
        return this.lureMatch;
    }

    public void setAteLure(boolean bAteLure) {
        this.ateLure = bAteLure;
    }

    public boolean hasAteLure() {
        return this.ateLure;
    }

    public void setRoaring(boolean pRoaring) {
        this.m_20124_(pRoaring ? Pose.ROARING : Pose.STANDING);
    }

    public boolean isRoaring() {
        return this.m_20089_() == Pose.ROARING;
    }

    public void setLegAttacking(Leg pLeg, boolean pAttacking) {
        switch (pLeg) {
            case FRONT_LEFT_LEG: {
                this.f_19804_.m_135381_(DATA_ATTACKING_LEFT, (Object)pAttacking);
                break;
            }
            case FRONT_RIGHT_LEG: {
                this.f_19804_.m_135381_(DATA_ATTACKING_RIGHT, (Object)pAttacking);
            }
        }
    }

    public boolean isLegAttacking(Leg pLeg) {
        return switch (pLeg) {
            case Leg.FRONT_LEFT_LEG -> (Boolean)this.f_19804_.m_135370_(DATA_ATTACKING_LEFT);
            case Leg.FRONT_RIGHT_LEG -> (Boolean)this.f_19804_.m_135370_(DATA_ATTACKING_RIGHT);
            default -> false;
        };
    }

    public void playLegAttackEffects(Leg pLeg, float pYRot) {
        int animTicks;
        if (this.isLegAttacking(pLeg) && (animTicks = Mth.m_14143_((float)((float)(pLeg == Leg.FRONT_LEFT_LEG ? this.leftAttackState : this.rightAttackState).m_216981_() / 1000.0f * 20.0f))) < 10) {
            this.addLegAttackParticle(pLeg, pYRot, (float)animTicks / 10.0f);
            this.addLegAttackParticle(pLeg, pYRot, ((float)animTicks + 0.5f) / 10.0f);
        }
    }

    private void addLegAttackParticle(Leg pLeg, float pYRot, float pPercent) {
        float swingRot = 0.2f + 1.5707964f * pPercent;
        double xSpeed = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.03;
        double ySpeed = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.03;
        double zSpeed = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.03;
        if (pLeg == Leg.FRONT_LEFT_LEG) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + (double)Mth.m_14089_((float)(pYRot + swingRot)) * LEG_ATTACK_RANGE, this.m_20186_() + 1.0 + (double)((1.0f - pPercent) * 3.0f), this.m_20189_() + (double)Mth.m_14031_((float)(pYRot + swingRot)) * LEG_ATTACK_RANGE, xSpeed, ySpeed, zSpeed);
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() - (double)Mth.m_14089_((float)(pYRot - swingRot)) * LEG_ATTACK_RANGE, this.m_20186_() + 1.0 + (double)((1.0f - pPercent) * 3.0f), this.m_20189_() - (double)Mth.m_14031_((float)(pYRot - swingRot)) * LEG_ATTACK_RANGE, xSpeed, ySpeed, zSpeed);
        }
    }

    public boolean isDigging() {
        return this.m_217003_(Pose.DIGGING);
    }

    public boolean isEmerging() {
        return this.m_217003_(Pose.EMERGING);
    }

    public boolean isDiggingOrEmerging() {
        return this.isDigging() || this.isEmerging();
    }

    private void clientDiggingParticles(AnimationState pAnimationState) {
        if ((float)pAnimationState.m_216981_() < 1500.0f) {
            AABB aabb = this.m_20191_();
            double maxDist = aabb.m_82362_() * 0.5 * (aabb.m_82385_() * 0.5);
            BlockPos.m_121886_((int)Mth.m_14107_((double)aabb.f_82288_), (int)(this.m_146904_() - 1), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14165_((double)aabb.f_82291_), (int)(this.m_146904_() - 1), (int)Mth.m_14165_((double)aabb.f_82293_)).forEach(pos -> {
                BlockState blockState;
                if (pos.m_123331_((Vec3i)this.m_20097_()) <= maxDist && (blockState = this.m_9236_().m_8055_(pos)).m_60799_() != RenderShape.INVISIBLE) {
                    for (int i = 0; i < 4; ++i) {
                        double d0 = (double)((float)pos.m_123341_() + 0.5f) + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.7f, (float)0.7f);
                        double d1 = this.m_20186_();
                        double d2 = (double)((float)pos.m_123343_() + 0.5f) + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.7f, (float)0.7f);
                        this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            });
        }
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.head.m_20185_(), this.head.m_20186_(), this.head.m_20189_(), pSound, this.m_5720_(), pVolume, pPitch);
        }
    }

    public void playSoundFromCenter(@NotNull SoundEvent pSound, float pVolume, float pPitch) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), pSound, this.m_5720_(), pVolume, pPitch);
        }
    }

    public int m_8100_() {
        return 120;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)StormwardSoundEvents.CHASMFIEND_AMBIENT.get();
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.CHASMFIEND_HURT.get();
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.CHASMFIEND_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSoundFromCenter((SoundEvent)StormwardSoundEvents.CHASMFIEND_STEP.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.playBiteSound();
        return super.m_7327_(pEntity);
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.playBiteSound();
        }
        super.m_7822_(pId);
    }

    public void playRoarSound() {
        this.f_21363_ = -this.m_8100_();
        this.m_5496_((SoundEvent)StormwardSoundEvents.CHASMFIEND_ROAR.get(), 5.0f, this.m_6100_());
    }

    public void playEmergeSound() {
        this.f_21363_ = -this.m_8100_();
        this.playSoundFromCenter((SoundEvent)StormwardSoundEvents.CHASMFIEND_EMERGE.get(), 5.0f, 1.0f);
    }

    public void playDigSound() {
        this.f_21363_ = -this.m_8100_();
        this.playSoundFromCenter((SoundEvent)StormwardSoundEvents.CHASMFIEND_DIG.get(), 5.0f, 1.0f);
    }

    public void playBiteSound() {
        this.f_21363_ = -this.m_8100_();
        this.m_5496_((SoundEvent)StormwardSoundEvents.CHASMFIEND_BITE.get(), this.m_6121_(), this.m_6100_());
    }

    public void playSweepSound() {
        this.playSoundFromCenter((SoundEvent)StormwardSoundEvents.CHASMFIEND_SWEEP.get(), 2.0f, this.m_6100_());
    }

    public static enum Leg {
        FRONT_LEFT_LEG,
        FRONT_RIGHT_LEG,
        BACK_LEFT_LEG,
        BACK_RIGHT_LEG;

    }
}

