/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.chasmfiend.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import us.amon.stormward.block.MeatBlock;
import us.amon.stormward.entity.chasmfiend.Chasmfiend;

public class EatLureGoal
extends Goal {
    protected final Chasmfiend chasmfiend;
    protected final double speedModifier;
    protected final double eatRange;
    private Path path;
    private int ticksUntilNextPathRecalculation;

    public EatLureGoal(Chasmfiend pChasmfiend, double pSpeedModifier, double pEatRange) {
        this.chasmfiend = pChasmfiend;
        this.speedModifier = pSpeedModifier;
        this.eatRange = pEatRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.chasmfiend.getLurePos().isEmpty()) {
            return false;
        }
        this.path = this.getPath(this.chasmfiend.getLurePos().get());
        return this.path != null;
    }

    public void m_8056_() {
        this.chasmfiend.m_21573_().m_26536_(this.path, this.speedModifier);
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void m_8041_() {
        this.chasmfiend.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.chasmfiend.getLurePos().isPresent()) {
            BlockPos lurePos = this.chasmfiend.getLurePos().get();
            double sqrDist = this.chasmfiend.m_20238_(lurePos.m_252807_());
            if (sqrDist <= this.eatRange * this.eatRange) {
                this.chasmfiend.setLurePos(null);
                this.chasmfiend.setAteLure(true);
                MeatBlock.clearPatternBlocks(this.chasmfiend.m_9236_(), this.chasmfiend.getLureMatch());
                MeatBlock.updatePatternBlocks(this.chasmfiend.m_9236_(), this.chasmfiend.getLureMatch());
                this.chasmfiend.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 1200, 0));
                this.chasmfiend.playBiteSound();
                return;
            }
            this.chasmfiend.m_21563_().m_24964_(lurePos.m_252807_());
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.ticksUntilNextPathRecalculation = 4 + this.chasmfiend.m_217043_().m_188503_(7);
                if (sqrDist > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (sqrDist > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                this.path = this.getPath(lurePos);
                if (this.path == null || !this.chasmfiend.m_21573_().m_26536_(this.path, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
        }
    }

    protected Path getPath(BlockPos pLurePos) {
        return this.chasmfiend.m_21573_().m_7864_(pLurePos, 2);
    }
}

