/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.chasmfiend.goal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import us.amon.stormward.entity.chasmfiend.Chasmfiend;
import us.amon.stormward.entity.chasmfiend.goal.ChasmfiendAbilityGoal;

public class LegAttackGoal
extends ChasmfiendAbilityGoal {
    private final double range;
    private final float damage;
    private final float knockback;
    private Chasmfiend.Leg currentLeg;
    List<LivingEntity> targets;

    public LegAttackGoal(Chasmfiend pChasmfiend, int pActiveTicks, int pCooldownTicks, double pRange, float pDamage, float pKnockback) {
        super(pChasmfiend, pActiveTicks, pCooldownTicks);
        this.range = pRange;
        this.damage = pDamage;
        this.knockback = pKnockback;
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || this.chasmfiend.isRoaring() || this.chasmfiend.isDiggingOrEmerging() || this.chasmfiend.leftLeg1.isDead() && this.chasmfiend.rightLeg1.isDead()) {
            return false;
        }
        Vec3 forward = Vec3.m_82498_((float)0.0f, (float)this.chasmfiend.f_20883_);
        Vec3 right = Vec3.m_82498_((float)0.0f, (float)(this.chasmfiend.f_20883_ + 90.0f));
        ArrayList<LivingEntity> leftTargets = new ArrayList<LivingEntity>();
        ArrayList<LivingEntity> rightTargets = new ArrayList<LivingEntity>();
        for (LivingEntity target : this.getTargetsInRange(this.range)) {
            Vec3 delta = target.m_20182_().m_82546_(this.chasmfiend.m_20182_());
            if (!(delta.m_82526_(forward) > 0.0)) continue;
            double dot = delta.m_82541_().m_82526_(right);
            if (dot >= -0.25) {
                rightTargets.add(target);
            }
            if (!(dot <= 0.25)) continue;
            leftTargets.add(target);
        }
        if (this.chasmfiend.leftLeg1.isDead()) {
            leftTargets.clear();
        }
        if (this.chasmfiend.rightLeg1.isDead()) {
            rightTargets.clear();
        }
        int numLeft = this.getNumEnemies(leftTargets);
        int numRight = this.getNumEnemies(rightTargets);
        if (numLeft <= 0 && numRight <= 0) {
            return false;
        }
        if (numLeft > numRight) {
            this.currentLeg = Chasmfiend.Leg.FRONT_LEFT_LEG;
            this.targets = leftTargets;
        } else if (numRight > numLeft) {
            this.currentLeg = Chasmfiend.Leg.FRONT_RIGHT_LEG;
            this.targets = rightTargets;
        } else {
            this.currentLeg = this.chasmfiend.m_217043_().m_188499_() ? Chasmfiend.Leg.FRONT_LEFT_LEG : Chasmfiend.Leg.FRONT_RIGHT_LEG;
            this.targets = this.currentLeg == Chasmfiend.Leg.FRONT_LEFT_LEG ? leftTargets : rightTargets;
        }
        return true;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.chasmfiend.setLegAttacking(this.currentLeg, true);
        for (LivingEntity target : this.targets) {
            if (!this.chasmfiend.m_6779_(target)) continue;
            target.m_6469_(this.chasmfiend.m_269291_().m_269333_((LivingEntity)this.chasmfiend), this.damage);
            Vec3 delta = this.chasmfiend.m_20182_().m_82546_(target.m_20182_());
            Vec3 dir = new Vec3(delta.f_82479_, 0.0, delta.f_82481_).m_82541_();
            target.m_147240_((double)this.knockback, dir.f_82479_, dir.f_82481_);
        }
        this.chasmfiend.playSweepSound();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.chasmfiend.setLegAttacking(this.currentLeg, false);
    }
}

