/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterShadersEvent;
import us.amon.stormward.entity.client.renderer.HighsprenShadesmarRenderer;

public class StormwardRenderTypes {
    public static RenderType entityCutoutUnlit(ResourceLocation pTexture) {
        return CustomRenderTypes.ENTITY_CUTOUT_UNLIT.apply(pTexture);
    }

    public static RenderType highspren() {
        return CustomRenderTypes.HIGHSPREN;
    }

    public static RenderType shardplateCrumbling(ResourceLocation pTexture) {
        return CustomRenderTypes.SHARDPLATE_CRUMBLING.apply(pTexture);
    }

    public static RenderType shardplateTrim() {
        return CustomRenderTypes.SHARDPLATE_TRIM;
    }

    public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("stormward", "rendertype_entity_cutout_unlit"), DefaultVertexFormat.f_85812_), shaderInstance -> {
            CustomRenderTypes.entityCutoutUnlitShader = shaderInstance;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("stormward", "rendertype_highspren"), DefaultVertexFormat.f_85814_), shaderInstance -> {
            CustomRenderTypes.highsprenShader = shaderInstance;
        });
    }

    private static class CustomRenderTypes
    extends RenderType {
        private static ShaderInstance entityCutoutUnlitShader;
        private static ShaderInstance highsprenShader;
        private static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_CUTOUT_UNLIT_SHADER;
        private static final RenderStateShard.ShaderStateShard RENDERTYPE_HIGHSPREN_SHADER;
        public static Function<ResourceLocation, RenderType> ENTITY_CUTOUT_UNLIT;
        public static RenderType HIGHSPREN;
        public static Function<ResourceLocation, RenderType> SHARDPLATE_CRUMBLING;
        public static RenderType SHARDPLATE_TRIM;

        private CustomRenderTypes(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
            super(s, v, m, i, b, b2, r, r2);
            throw new IllegalStateException("This class is not meant to be constructed!");
        }

        private static RenderType entityCutoutUnlit(ResourceLocation pTexture) {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ENTITY_CUTOUT_UNLIT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(pTexture, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
            return CustomRenderTypes.m_173215_((String)"stormward_entity_cutout_unlit", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
        }

        private static RenderType highspren() {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_HIGHSPREN_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(HighsprenShadesmarRenderer.SKY_TEXTURE, false, false).m_173132_(HighsprenShadesmarRenderer.STARS_TEXTURE, false, false).m_173131_()).m_110691_(false);
            return CustomRenderTypes.m_173215_((String)"stormward_highspren", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
        }

        private static RenderType shardplateCrumbling(ResourceLocation pTexture) {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173085_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(pTexture, false, false)).m_110685_(f_110138_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110669_(f_110119_).m_110663_(f_110112_).m_110691_(true);
            return RenderType.m_173215_((String)"stormward_shardplate_crumbling", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
        }

        private static RenderType shardplateTrim() {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173111_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(Sheets.f_265912_, false, false)).m_110685_(f_110134_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110669_(f_110119_).m_110663_(f_110112_).m_110691_(true);
            return RenderType.m_173215_((String)"stormward_shardplate_trim", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
        }

        static {
            RENDERTYPE_ENTITY_CUTOUT_UNLIT_SHADER = new RenderStateShard.ShaderStateShard(() -> entityCutoutUnlitShader);
            RENDERTYPE_HIGHSPREN_SHADER = new RenderStateShard.ShaderStateShard(() -> highsprenShader);
            ENTITY_CUTOUT_UNLIT = Util.m_143827_(CustomRenderTypes::entityCutoutUnlit);
            HIGHSPREN = CustomRenderTypes.highspren();
            SHARDPLATE_CRUMBLING = Util.m_143827_(CustomRenderTypes::shardplateCrumbling);
            SHARDPLATE_TRIM = CustomRenderTypes.shardplateTrim();
        }
    }
}

