/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.tusks.ITusks;
import us.amon.stormward.entity.client.model.WhitespineTuskModel;

public class WhitespineTuskLayer<T extends LivingEntity, M extends PlayerModel<T>>
extends StuckInBodyLayer<T, M> {
    private static final ResourceLocation TUSK_LOCATION = new ResourceLocation("stormward", "textures/entity/whitespine/tusk.png");
    private final WhitespineTuskModel model;

    public WhitespineTuskLayer(EntityRendererProvider.Context pContext, LivingEntityRenderer<T, M> pRenderer) {
        super(pRenderer);
        this.model = new WhitespineTuskModel(pContext.m_174023_(WhitespineTuskModel.LAYER_LOCATION));
    }

    protected int m_7040_(T pEntity) {
        return pEntity.getCapability(StormwardCapabilities.TUSKS).map(ITusks::getTusks).orElse(0);
    }

    protected void m_5558_(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull Entity pEntity, float pX, float pY, float pZ, float pPartialTick) {
        float dist = Mth.m_14116_((float)(pX * pX + pZ * pZ));
        float yRot = (float)(Math.atan2(pX, pZ) * 57.2957763671875);
        float zRot = (float)(Math.atan2(pY, dist) * 57.2957763671875);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(yRot - 90.0f));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(zRot));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        pPoseStack.m_252880_(0.0f, -1.2f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110446_((ResourceLocation)TUSK_LOCATION));
        this.model.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

