/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.Chull;
import us.amon.stormward.entity.client.animation.ChullAnimations;

public class ChullModel<T extends Chull>
extends AgeableHierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "chull"), "main");
    public static final ModelLayerLocation SADDLE_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "chull"), "saddle");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart rightAntenna;
    private final ModelPart leftAntenna;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftFrontFoot;
    private final ModelPart leftMidLeg;
    private final ModelPart leftMidFoot;
    private final ModelPart leftBackLeg;
    private final ModelPart leftBackFoot;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightFrontFoot;
    private final ModelPart rightMidLeg;
    private final ModelPart rightMidFoot;
    private final ModelPart rightBackLeg;
    private final ModelPart rightBackFoot;
    private final ModelPart leftArm;
    private final ModelPart leftHand;
    private final ModelPart rightArm;
    private final ModelPart rightHand;
    private final ModelPart leftChest;
    private final ModelPart rightChest;

    public ChullModel(ModelPart pRoot) {
        super(0.5f, 24.0f);
        this.root = pRoot;
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leftEye = this.head.m_171324_("leftEye");
        this.rightEye = this.head.m_171324_("rightEye");
        this.rightAntenna = this.head.m_171324_("rightAntenna");
        this.leftAntenna = this.head.m_171324_("leftAntenna");
        this.leftFrontLeg = this.body.m_171324_("leftFrontLeg");
        this.leftFrontFoot = this.leftFrontLeg.m_171324_("leftFrontFoot");
        this.leftMidLeg = this.body.m_171324_("leftMidLeg");
        this.leftMidFoot = this.leftMidLeg.m_171324_("leftMidFoot");
        this.leftBackLeg = this.body.m_171324_("leftBackLeg");
        this.leftBackFoot = this.leftBackLeg.m_171324_("leftBackFoot");
        this.rightFrontLeg = this.body.m_171324_("rightFrontLeg");
        this.rightFrontFoot = this.rightFrontLeg.m_171324_("rightFrontFoot");
        this.rightMidLeg = this.body.m_171324_("rightMidLeg");
        this.rightMidFoot = this.rightMidLeg.m_171324_("rightMidFoot");
        this.rightBackLeg = this.body.m_171324_("rightBackLeg");
        this.rightBackFoot = this.rightBackLeg.m_171324_("rightBackFoot");
        this.leftArm = this.body.m_171324_("leftArm");
        this.leftHand = this.leftArm.m_171324_("leftHand");
        this.rightArm = this.body.m_171324_("rightArm");
        this.rightHand = this.rightArm.m_171324_("rightHand");
        this.leftChest = this.body.m_171324_("leftChest");
        this.rightChest = this.body.m_171324_("rightChest");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-9.0f, -16.0f, -10.0f, 18.0f, 16.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -26.0f, -8.0f, 14.0f, 10.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.75f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(44, 7).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-10.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(0.0f, -4.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-3.0f, (float)-1.0f, (float)-0.2608f, (float)0.0226f, (float)0.0843f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-1.0f, -4.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-3.0f, (float)-1.0f, (float)-0.2608f, (float)-0.0226f, (float)-0.0843f));
        PartDefinition rightAntenna = head.m_171599_("rightAntenna", CubeListBuilder.m_171558_().m_171514_(48, -16).m_171488_(0.0f, -1.0f, -16.0f, 0.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-2.0f, (float)-3.0f, (float)-0.2628f, (float)0.0843f, (float)-0.0226f));
        PartDefinition leftAntenna = head.m_171599_("leftAntenna", CubeListBuilder.m_171558_().m_171514_(48, -16).m_171488_(0.0f, -1.0f, -16.0f, 0.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-2.0f, (float)-3.0f, (float)-0.2628f, (float)-0.0843f, (float)0.0226f));
        PartDefinition leftFrontLeg = body.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(76, 50).m_171488_(-3.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)-1.0f, (float)-6.0f, (float)0.3876f, (float)0.3614f, (float)0.8571f));
        PartDefinition leftFrontFoot = leftFrontLeg.m_171599_("leftFrontFoot", CubeListBuilder.m_171558_().m_171514_(88, 44).m_171488_(0.0f, -2.0f, -1.5f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-9.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leftMidLeg = body.m_171599_("leftMidLeg", CubeListBuilder.m_171558_().m_171514_(76, 50).m_171488_(-3.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)10.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leftMidFoot = leftMidLeg.m_171599_("leftMidFoot", CubeListBuilder.m_171558_().m_171514_(88, 44).m_171488_(0.0f, -2.0f, -1.5f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-9.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leftBackLeg = body.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(76, 50).m_171488_(-3.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)-1.0f, (float)6.0f, (float)-0.3876f, (float)-0.3614f, (float)0.8571f));
        PartDefinition leftBackFoot = leftBackLeg.m_171599_("leftBackFoot", CubeListBuilder.m_171558_().m_171514_(88, 44).m_171488_(0.0f, -2.0f, -1.5f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-9.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightFrontLeg = body.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(76, 50).m_171480_().m_171488_(0.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-9.0f, (float)-1.0f, (float)-6.0f, (float)0.3876f, (float)-0.3614f, (float)-0.8571f));
        PartDefinition rightFrontFoot = rightFrontLeg.m_171599_("rightFrontFoot", CubeListBuilder.m_171558_().m_171514_(88, 44).m_171480_().m_171488_(-4.0f, -2.0f, -1.5f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-9.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition rightMidLeg = body.m_171599_("rightMidLeg", CubeListBuilder.m_171558_().m_171514_(76, 50).m_171480_().m_171488_(0.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-10.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightMidFoot = rightMidLeg.m_171599_("rightMidFoot", CubeListBuilder.m_171558_().m_171514_(88, 44).m_171480_().m_171488_(-4.0f, -2.0f, -1.5f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-9.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition rightBackLeg = body.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(76, 50).m_171480_().m_171488_(0.0f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-9.0f, (float)-1.0f, (float)6.0f, (float)-0.3876f, (float)0.3614f, (float)-0.8571f));
        PartDefinition rightBackFoot = rightBackLeg.m_171599_("rightBackFoot", CubeListBuilder.m_171558_().m_171514_(88, 44).m_171480_().m_171488_(-4.0f, -2.0f, -1.5f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-9.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(56, 35).m_171488_(0.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-2.0f, (float)-10.0f, (float)0.0f, (float)0.5236f, (float)-0.5236f));
        PartDefinition leftHand = leftArm.m_171599_("leftHand", CubeListBuilder.m_171558_().m_171514_(56, 39).m_171488_(-8.0f, -2.0f, -3.0f, 10.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(56, 35).m_171480_().m_171488_(-7.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)-2.0f, (float)-10.0f, (float)0.0f, (float)-0.5236f, (float)0.5236f));
        PartDefinition rightHand = rightArm.m_171599_("rightHand", CubeListBuilder.m_171558_().m_171514_(56, 39).m_171480_().m_171488_(-2.0f, -2.0f, -3.0f, 10.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition leftChest = body.m_171599_("leftChest", CubeListBuilder.m_171558_().m_171514_(60, 8).m_171488_(0.0f, 0.0f, -1.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-26.0f, (float)0.0f));
        PartDefinition rightChest = body.m_171599_("rightChest", CubeListBuilder.m_171558_().m_171514_(60, 8).m_171480_().m_171488_(-3.0f, 0.0f, -1.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-7.0f, (float)-26.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(@NotNull T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (((Chull)((Object)pEntity)).hasChest()) {
            this.leftChest.f_104207_ = true;
            this.rightChest.f_104207_ = true;
        } else {
            this.leftChest.f_104207_ = false;
            this.rightChest.f_104207_ = false;
        }
        this.m_233381_(((Chull)((Object)pEntity)).antennaeAnimationState, ChullAnimations.ANTENNAE, pAgeInTicks);
        this.m_233381_(((Chull)((Object)pEntity)).armsAnimationState, ChullAnimations.ARMS, pAgeInTicks);
        float scale = Math.min((pAgeInTicks - (float)((Chull)((Object)pEntity)).animStartTick) / 8.0f, 1.0f);
        switch (((Chull)((Object)pEntity)).getState()) {
            case IDLING: {
                this.m_267799_(ChullAnimations.WALK, pLimbSwing, pLimbSwingAmount, 10.0f, 5.0f);
                break;
            }
            case HIDING: {
                this.m_267799_(ChullAnimations.HIDE, 0.0f, scale, 1.0f, 1.0f);
                break;
            }
            case HIDDEN: {
                this.m_288214_(ChullAnimations.HIDE);
                break;
            }
            case REVEALING: {
                this.m_267799_(ChullAnimations.HIDE, 0.0f, 1.0f - scale, 1.0f, 1.0f);
            }
        }
        if (!((Chull)((Object)pEntity)).isHiding()) {
            this.head.f_104203_ += pHeadPitch * ((float)Math.PI / 180);
            this.head.f_104204_ += pNetHeadYaw * ((float)Math.PI / 180);
        }
    }
}

