/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.Cremling;

public class CremlingModel<T extends Cremling>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "cremling"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leftAntenna;
    private final ModelPart rightAntenna;
    private final ModelPart body;
    private final ModelPart waist;
    private final ModelPart tail;
    private final ModelPart fork;
    private final ModelPart[] bodyParts;

    public CremlingModel(ModelPart pRoot) {
        this.root = pRoot;
        this.body = this.root.m_171324_("body");
        this.head = this.root.m_171324_("head");
        this.leftAntenna = this.head.m_171324_("leftAntenna");
        this.rightAntenna = this.head.m_171324_("rightAntenna");
        this.waist = this.root.m_171324_("waist");
        this.tail = this.root.m_171324_("tail");
        this.fork = this.root.m_171324_("fork");
        this.bodyParts = new ModelPart[]{this.head, this.body, this.waist, this.tail, this.fork};
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(5, 0).m_171488_(-3.0f, -4.0f, 0.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(22, 4).m_171488_(0.0f, -6.0f, 0.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-2.5f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -2.0f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-2.5f));
        PartDefinition leftAntenna = head.m_171599_("leftAntenna", CubeListBuilder.m_171558_().m_171514_(14, 10).m_171488_(0.0f, 0.0f, -6.0f, 1.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-1.0f, (float)-2.0f));
        PartDefinition rightAntenna = head.m_171599_("rightAntenna", CubeListBuilder.m_171558_().m_171514_(14, 10).m_171488_(-1.0f, 0.0f, -6.0f, 1.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-1.0f, (float)-2.0f));
        PartDefinition waist = partdefinition.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.0f, -3.0f, 0.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(22, 9).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)2.5f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(12, 9).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)4.5f));
        PartDefinition fork = partdefinition.m_171599_("fork", CubeListBuilder.m_171558_().m_171514_(19, 13).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)6.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        for (int i = 0; i < this.bodyParts.length; ++i) {
            this.bodyParts[i].f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.1f * (float)(1 + Math.abs(i - 1)) * limbSwingAmount;
            this.bodyParts[i].f_104200_ = Mth.m_14031_((float)(ageInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.4f * (float)Math.abs(i - 1) * limbSwingAmount;
        }
        this.leftAntenna.f_104204_ -= 0.08726646f;
        this.rightAntenna.f_104204_ += 0.08726646f;
        CremlingModel.bobAntennae(this.leftAntenna, ageInTicks * 2.0f, -1.0f);
        CremlingModel.bobAntennae(this.rightAntenna, ageInTicks * 2.0f, 1.0f);
    }

    public static void bobAntennae(ModelPart pModelPart, float pAgeInTicks, float pMultiplier) {
        pModelPart.f_104203_ += pMultiplier * Mth.m_14031_((float)(pAgeInTicks * 0.067f)) * 0.05f;
        pModelPart.f_104204_ += pMultiplier * (Mth.m_14089_((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f);
    }
}

