/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.spren.shadesmar.OathgateSpren;
import us.amon.stormward.entity.spren.shadesmar.OathgateSprenVariant;

public class OathgateSprenModel<T extends OathgateSpren>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "oathgate_spren"), "main");
    private final ModelPart body;
    private final ModelPart legs;
    private final ModelPart rightShoulder;
    private final ModelPart rightArm;
    private final ModelPart rightSpear;
    private final ModelPart leftShoulder;
    private final ModelPart leftArm;
    private final ModelPart leftSpear;
    private final ModelPart head;

    public OathgateSprenModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.legs = this.body.m_171324_("legs");
        this.rightShoulder = this.body.m_171324_("right_shoulder");
        this.rightArm = this.body.m_171324_("right_arm");
        this.rightSpear = this.rightArm.m_171324_("right_spear");
        this.leftShoulder = this.body.m_171324_("left_shoulder");
        this.leftArm = this.body.m_171324_("left_arm");
        this.leftSpear = this.leftArm.m_171324_("left_spear");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(27, 31).m_171488_(-5.0f, -21.0f, -3.0f, 10.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(22, 14).m_171488_(-6.0f, -28.0f, -5.0f, 12.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-6.0f, -32.0f, -5.0f, 12.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_().m_171514_(27, 42).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)-3.0f));
        PartDefinition right_shoulder = body.m_171599_("right_shoulder", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-5.0f, -2.0f, -3.0f, 5.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-26.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(11, 31).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-25.0f, (float)0.0f));
        PartDefinition right_spear = right_arm.m_171599_("right_spear", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-2.0f, (float)9.0f, (float)-2.0f, (float)1.5708f, (float)0.0f, (float)0.5236f));
        PartDefinition guard_r1 = right_spear.m_171599_("guard_r1", CubeListBuilder.m_171558_().m_171514_(4, 35).m_171488_(-0.5f, -11.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(4, 33).m_171488_(-0.5f, 24.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-0.5f, -7.0f, -0.5f, 1.0f, 30.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = right_spear.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(4, 44).m_171488_(0.0f, -19.0f, -4.5f, 0.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_shoulder = body.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(66, 18).m_171488_(1.0f, -2.0f, -3.0f, 5.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-26.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(59, 31).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-25.0f, (float)0.0f));
        PartDefinition left_spear = left_arm.m_171599_("left_spear", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)2.0f, (float)9.0f, (float)-2.0f, (float)1.5708f, (float)0.0f, (float)-0.5236f));
        PartDefinition guard_r2 = left_spear.m_171599_("guard_r2", CubeListBuilder.m_171558_().m_171514_(4, 35).m_171488_(-0.5f, -11.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(4, 33).m_171488_(-0.5f, 24.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-0.5f, -7.0f, -0.5f, 1.0f, 30.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r2 = left_spear.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(4, 44).m_171488_(0.0f, -19.0f, -4.5f, 0.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(82, 0).m_171488_(-4.5f, -10.5f, -4.5f, 9.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-28.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(@NotNull OathgateSpren entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isLeft;
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        this.body.f_104201_ += (float)Math.cos(ageInTicks * 4.5f * ((float)Math.PI / 180)) * 0.5f;
        this.legs.f_104203_ = 0.17404424f;
        AnimationUtils.m_102082_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        this.leftSpear.f_104207_ = isLeft = entity.getVariant() == OathgateSprenVariant.BLACK;
        boolean bl = this.rightSpear.f_104207_ = !isLeft;
        if (isLeft) {
            this.leftArm.f_104203_ -= 1.5707964f;
        } else {
            this.rightArm.f_104203_ -= 1.5707964f;
        }
        this.rightShoulder.f_104203_ = this.rightArm.f_104203_ * 0.2f;
        this.rightShoulder.f_104204_ = this.rightArm.f_104204_ * 0.5f;
        this.rightShoulder.f_104205_ = this.rightArm.f_104205_ * 0.5f;
        this.leftShoulder.f_104203_ = this.leftArm.f_104203_ * 0.2f;
        this.leftShoulder.f_104204_ = this.leftArm.f_104204_ * 0.5f;
        this.leftShoulder.f_104205_ = this.leftArm.f_104205_ * 0.5f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

