/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class PlayerLikeModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;

    public PlayerLikeModel(ModelPart pRoot) {
        this(pRoot, RenderType::m_110458_);
    }

    public PlayerLikeModel(ModelPart pRoot, Function<ResourceLocation, RenderType> pRenderType) {
        super(pRoot, pRenderType);
        this.leftSleeve = pRoot.m_171324_("left_sleeve");
        this.rightSleeve = pRoot.m_171324_("right_sleeve");
        this.leftPants = pRoot.m_171324_("left_pants");
        this.rightPants = pRoot.m_171324_("right_pants");
        this.jacket = pRoot.m_171324_("jacket");
    }

    public static MeshDefinition createMesh(CubeDeformation pCubeDeformation, boolean pSlim) {
        MeshDefinition mesh = PlayerModel.m_170825_((CubeDeformation)pCubeDeformation, (boolean)pSlim);
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("ear", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("cloak", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return mesh;
    }

    public static LayerDefinition createBodyLayer(boolean pSlim) {
        return LayerDefinition.m_171565_((MeshDefinition)PlayerLikeModel.createMesh(CubeDeformation.f_171458_, pSlim), (int)64, (int)64);
    }

    public static LayerDefinition createInnerArmorLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171107_, (float)0.0f), (int)64, (int)32);
    }

    public static LayerDefinition createOuterArmorLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171106_, (float)0.0f), (int)64, (int)32);
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.leftPants, (Object)this.rightPants, (Object)this.leftSleeve, (Object)this.rightSleeve, (Object)this.jacket));
    }

    public void m_6973_(@NotNull T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.leftPants.m_104315_(this.f_102814_);
        this.rightPants.m_104315_(this.f_102813_);
        this.leftSleeve.m_104315_(this.f_102812_);
        this.rightSleeve.m_104315_(this.f_102811_);
        this.jacket.m_104315_(this.f_102810_);
    }

    public void m_8009_(boolean pVisible) {
        super.m_8009_(pVisible);
        this.leftSleeve.f_104207_ = pVisible;
        this.rightSleeve.f_104207_ = pVisible;
        this.leftPants.f_104207_ = pVisible;
        this.rightPants.f_104207_ = pVisible;
        this.jacket.f_104207_ = pVisible;
    }
}

