/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.chasmfiend.Chasmfiend;
import us.amon.stormward.entity.chasmfiend.ChasmfiendLeg;
import us.amon.stormward.entity.client.layer.ChasmfiendEyesLayer;
import us.amon.stormward.entity.client.model.ChasmfiendModel;

public class ChasmfiendRenderer
extends MobRenderer<Chasmfiend, ChasmfiendModel<Chasmfiend>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("stormward", "textures/entity/chasmfiend/chasmfiend.png");

    public ChasmfiendRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new ChasmfiendModel(pContext.m_174023_(ChasmfiendModel.LAYER_LOCATION)), 5.0f);
        this.m_115326_((RenderLayer)new ChasmfiendEyesLayer(this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Chasmfiend pEntity) {
        return TEXTURE;
    }

    public void render(@NotNull Chasmfiend pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Direction direction;
        Entity entity;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)pEntity, (LivingEntityRenderer)this, pPartialTicks, pPoseStack, pBuffer, pPackedLight))) {
            return;
        }
        pPoseStack.m_85836_();
        ((ChasmfiendModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)pEntity, pPartialTicks);
        ((ChasmfiendModel)this.f_115290_).f_102609_ = shouldSit = pEntity.m_20159_() && pEntity.m_20202_() != null && pEntity.m_20202_().shouldRiderSit();
        ((ChasmfiendModel)this.f_115290_).f_102610_ = pEntity.m_6162_();
        float f = Mth.m_14189_((float)pPartialTicks, (float)pEntity.f_20884_, (float)pEntity.f_20883_);
        float f1 = Mth.m_14189_((float)pPartialTicks, (float)pEntity.f_20886_, (float)pEntity.f_20885_);
        float netHeadYaw = f1 - f;
        if (shouldSit && pEntity.m_20202_() instanceof LivingEntity && (entity = pEntity.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.m_14189_((float)pPartialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = f1 - f;
            float f6 = Mth.m_14177_((float)netHeadYaw);
            if (f6 < -85.0f) {
                f6 = -85.0f;
            }
            if (f6 >= 85.0f) {
                f6 = 85.0f;
            }
            f = f1 - f6;
            if (f6 * f6 > 2500.0f) {
                f += f6 * 0.2f;
            }
            netHeadYaw = f1 - f;
        }
        float headPitch = Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19860_, (float)pEntity.m_146909_());
        if (ChasmfiendRenderer.m_194453_((LivingEntity)pEntity)) {
            headPitch *= -1.0f;
            netHeadYaw *= -1.0f;
        }
        if (pEntity.m_217003_(Pose.SLEEPING) && (direction = pEntity.m_21259_()) != null) {
            float f3 = pEntity.m_20236_(Pose.STANDING) - 0.1f;
            pPoseStack.m_252880_((float)(-direction.m_122429_()) * f3, 0.0f, (float)(-direction.m_122431_()) * f3);
        }
        float ageInTicks = this.m_6930_((LivingEntity)pEntity, pPartialTicks);
        this.m_7523_((LivingEntity)pEntity, pPoseStack, ageInTicks, f, pPartialTicks);
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_((LivingEntity)pEntity, pPoseStack, pPartialTicks);
        pPoseStack.m_252880_(0.0f, -1.501f, 0.0f);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && pEntity.m_6084_()) {
            limbSwingAmount = pEntity.f_267362_.m_267711_(pPartialTicks);
            limbSwing = pEntity.f_267362_.m_267590_(pPartialTicks);
            if (pEntity.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        ((ChasmfiendModel)this.f_115290_).m_6839_((Entity)pEntity, limbSwing, limbSwingAmount, pPartialTicks);
        ((ChasmfiendModel)this.f_115290_).setupAnim(pEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_((LivingEntity)pEntity);
        boolean flag1 = !flag && !pEntity.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)pEntity);
        RenderType rendertype = this.m_7225_((LivingEntity)pEntity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = pBuffer.m_6299_(rendertype);
            int overlayCoords = ChasmfiendRenderer.getOverlayCoords(this.m_6931_((LivingEntity)pEntity, pPartialTicks), false);
            int hurtOverlayCoords = ChasmfiendRenderer.getOverlayCoords(this.m_6931_((LivingEntity)pEntity, pPartialTicks), true);
            ((ChasmfiendModel)this.f_115290_).m_7695_(pPoseStack, vertexconsumer, pPackedLight, ChasmfiendRenderer.isChasmfiendHurt(pEntity) ? hurtOverlayCoords : overlayCoords, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
            pPoseStack.m_85836_();
            ((ChasmfiendModel)this.f_115290_).translateAndRotateForLegs(pPoseStack);
            for (ChasmfiendLeg leg : pEntity.legs) {
                ((ChasmfiendModel)this.f_115290_).setupLegAnim(leg, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                ((ChasmfiendModel)this.f_115290_).renderLegToBuffer(leg.getLeg(), pPoseStack, vertexconsumer, pPackedLight, ChasmfiendRenderer.isLegHurt(leg) ? hurtOverlayCoords : overlayCoords, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
            }
            pPoseStack.m_85849_();
        }
        if (!pEntity.m_5833_()) {
            for (RenderLayer renderlayer : this.f_115291_) {
                renderlayer.m_6494_(pPoseStack, pBuffer, pPackedLight, (Entity)pEntity, limbSwing, limbSwingAmount, pPartialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
        pPoseStack.m_85849_();
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)pEntity, (LivingEntityRenderer)this, pPartialTicks, pPoseStack, pBuffer, pPackedLight));
    }

    public static int getOverlayCoords(float pU, boolean pHurt) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)pU), (int)OverlayTexture.m_118096_((boolean)pHurt));
    }

    public static boolean isChasmfiendHurt(Chasmfiend pChasmfiend) {
        return pChasmfiend.f_20916_ > 0 || pChasmfiend.f_20919_ > 0;
    }

    public static boolean isLegHurt(ChasmfiendLeg pChasmfiendLeg) {
        return pChasmfiendLeg.hurtTime > 0 && ((Chasmfiend)pChasmfiendLeg.getParent()).f_19797_ > 15 || ((Chasmfiend)pChasmfiendLeg.getParent()).f_20919_ > 0;
    }
}

