/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.duel;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.VanillaGameEvent;
import org.apache.commons.lang3.ArrayUtils;
import us.amon.stormward.block.DuelingPitBarrierBlock;
import us.amon.stormward.block.DuelingPitBlock;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.blockentity.DuelingPitEntity;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.entity.Axehound;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.Whitespine;
import us.amon.stormward.entity.duel.IDuelist;
import us.amon.stormward.entity.shardbearer.AlethiSoldier;
import us.amon.stormward.entity.shardbearer.Shardbearer;
import us.amon.stormward.entity.spren.overworld.Gloryspren;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.level.Duels;
import us.amon.stormward.sound.StormwardSoundEvents;

public class Duel {
    private static final int COUNTDOWN_TICKS = 300;
    private static final int CELEBRATION_TICKS = 600;
    private static final int POINTS_PER_PLAYER = 8;
    private static final int MAX_OMEN = 5;
    private static final int POINTS_PER_OMEN = 2;
    private static final int MIN_SPAWN_RADIUS = 2;
    private static final int MAX_SPAWN_RADIUS = 14;
    private static final int BARRIER_HEIGHT = 4;
    private static final int BARRIER_RAISE_INTERVAL = 10;
    private static final ResourceLocation REWARD_LOOT = new ResourceLocation("stormward", "chests/dueling_pit");
    private static final int REWARD_NUM = 4;
    private static final int REWARD_INTERVAL = 10;
    private static final UUID FOLLOW_RANGE_UUID = UUID.fromString("df4a7cf9-7e3b-43c1-8c36-3d6aaa4a592c");
    private static final AttributeModifier FOLLOW_RANGE_MODIFIER = new AttributeModifier(FOLLOW_RANGE_UUID, "Duel modifier", 32.0, AttributeModifier.Operation.ADDITION);
    private static final UUID ELITE_HEALTH_UUID = UUID.fromString("81c98af2-dca5-4218-8a78-1142b0edb449");
    private static final AttributeModifier ELITE_HEALTH_MODIFIER = new AttributeModifier(ELITE_HEALTH_UUID, "Elite modifier", 2.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private final int id;
    private final ServerLevel level;
    private final BlockPos arenaCenter;
    private static final int DUEL_EVENT_RADIUS = 32;
    private static final Component DUEL_NAME_COMPONENT = Component.m_237115_((String)"event.stormward.duel");
    private static final Component DUEL_VICTORY_COMPONENT = Component.m_237115_((String)"event.stormward.duel.victory");
    private static final Component DUEL_DEFEAT_COMPONENT = Component.m_237115_((String)"event.stormward.duel.defeat");
    private static final Component DUEL_FORFEIT_COMPONENT = Component.m_237115_((String)"event.stormward.duel.forfeit");
    private final ServerBossEvent duelEvent = new ServerBossEvent(DUEL_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private final Set<IDuelist> duelists = new HashSet<IDuelist>();
    private final Set<UUID> challengerIds = new HashSet<UUID>();
    private final Set<Player> challengers = new HashSet<Player>();
    private final int badOmenLevel;
    private boolean active;
    private DuelStatus status;
    private long ticksActive;
    private int delay;
    private float totalHealth;
    private DuelistType boss;

    public Duel(int pId, ServerLevel pLevel, BlockPos pArenaCenter) {
        this.id = pId;
        this.level = pLevel;
        this.arenaCenter = pArenaCenter;
        this.status = DuelStatus.ONGOING;
        this.delay = 300;
        this.duelEvent.m_142711_(0.0f);
        List players = this.level.m_8795_(player -> player.m_6084_() && !player.m_5833_() && DuelingPitBlock.isInArena(pArenaCenter, (Entity)player));
        int omens = 0;
        for (ServerPlayer player2 : players) {
            this.challengerIds.add(player2.m_20148_());
            this.challengers.add((Player)player2);
            if (!player2.m_21023_(MobEffects.f_19594_)) continue;
            omens += player2.m_21124_(MobEffects.f_19594_).m_19564_() + 1;
            player2.m_21195_(MobEffects.f_19594_);
        }
        this.badOmenLevel = Math.min(omens, 5);
        this.setBlockActive(true);
    }

    public Duel(ServerLevel pLevel, CompoundTag pCompound) {
        this.level = pLevel;
        this.id = pCompound.m_128451_("Id");
        this.arenaCenter = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("ArenaCenter"));
        this.status = DuelStatus.getByName(pCompound.m_128461_("Status"));
        this.active = pCompound.m_128471_("Active");
        this.ticksActive = pCompound.m_128454_("TicksActive");
        this.delay = pCompound.m_128451_("Delay");
        this.totalHealth = pCompound.m_128457_("TotalHealth");
        this.badOmenLevel = pCompound.m_128451_("BadOmenLevel");
        if (pCompound.m_128441_("Boss")) {
            this.boss = DuelistType.getByName(pCompound.m_128461_("Boss"));
            this.duelEvent.m_6456_(this.boss.getComponent());
        }
        if (pCompound.m_128425_("Challengers", 9)) {
            for (Tag tag : pCompound.m_128437_("Challengers", 11)) {
                this.challengerIds.add(NbtUtils.m_129233_((Tag)tag));
            }
        }
    }

    public CompoundTag save(CompoundTag pCompound) {
        pCompound.m_128405_("Id", this.id);
        pCompound.m_128365_("ArenaCenter", (Tag)NbtUtils.m_129224_((BlockPos)this.arenaCenter));
        pCompound.m_128359_("Status", this.status.getName());
        pCompound.m_128379_("Active", this.active);
        pCompound.m_128356_("TicksActive", this.ticksActive);
        pCompound.m_128405_("Delay", this.delay);
        pCompound.m_128350_("TotalHealth", this.totalHealth);
        pCompound.m_128405_("BadOmenLevel", this.badOmenLevel);
        if (this.boss != null) {
            pCompound.m_128359_("Boss", this.boss.getName());
        }
        ListTag challengersTag = new ListTag();
        for (UUID uuid : this.challengerIds) {
            challengersTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        pCompound.m_128365_("Challengers", (Tag)challengersTag);
        return pCompound;
    }

    public void tick() {
        if (!this.isStopped()) {
            boolean oldActive = this.active;
            this.active = this.level.m_46805_(this.arenaCenter);
            if (oldActive != this.active) {
                this.duelEvent.m_8321_(this.active);
            }
            if (!this.active) {
                return;
            }
            this.updatePlayers();
            ++this.ticksActive;
            if (this.ticksActive >= 48000L) {
                this.stop();
                return;
            }
            if (this.status == DuelStatus.ONGOING) {
                if (this.level.m_46791_() == Difficulty.PEACEFUL) {
                    this.stop();
                    return;
                }
                if (this.ticksActive % 10L == 0L) {
                    for (LivingEntity entity : DuelingPitBlock.getLivingEntitiesInArena((Level)this.level, this.arenaCenter)) {
                        IDuelist duelist;
                        if (this.challengerIds.contains(entity.m_20148_()) || entity instanceof IDuelist && this.duelists.contains(duelist = (IDuelist)entity)) continue;
                        this.forfeit();
                        return;
                    }
                    if (DuelingPitBlock.isArenaObstructed((Level)this.level, this.arenaCenter) || DuelingPitBlock.isArenaUnstable((Level)this.level, this.arenaCenter)) {
                        this.forfeit();
                        return;
                    }
                }
                if (this.delay > 0) {
                    if (this.delay >= 270 && this.delay % 10 == 0) {
                        this.setBarrierLayer((300 - this.delay) / 10, ((DuelingPitBarrierBlock)((Object)StormwardBlocks.DUELING_PIT_BARRIER.get())).m_49966_());
                    }
                    if (--this.delay <= 0) {
                        this.spawnDuelists();
                        this.level.m_5594_(null, this.arenaCenter, (SoundEvent)StormwardSoundEvents.DUELING_PIT_START.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
                    }
                    this.duelEvent.m_142711_(Mth.m_14036_((float)((float)(300 - this.delay) / 300.0f), (float)0.0f, (float)1.0f));
                } else if (this.duelists.isEmpty()) {
                    this.victory();
                }
            } else if (this.isOver()) {
                BlockEntity duelist;
                if (this.delay >= 570 && this.delay % 10 == 0) {
                    this.setBarrierLayer(3 - (600 - this.delay) / 10, Blocks.f_50016_.m_49966_());
                }
                int rewards = 4 * this.challengers.size();
                if (this.isVictory() && this.delay >= 600 - (rewards - 1) * 10 && this.delay % 10 == 0 && (duelist = this.level.m_7702_(this.arenaCenter)) instanceof DuelingPitEntity) {
                    LootParams params;
                    DuelingPitEntity duelingPitEntity = (DuelingPitEntity)duelist;
                    LootTable table = this.level.m_7654_().m_278653_().m_278676_(REWARD_LOOT);
                    ObjectArrayList items = table.m_287214_(params = new LootParams.Builder(this.level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.arenaCenter)).m_287235_(LootContextParamSets.f_81411_), this.arenaCenter.m_121878_() + this.ticksActive);
                    if (!items.isEmpty()) {
                        duelingPitEntity.popOutItem((ItemStack)items.get(0));
                    }
                }
                if (--this.delay > 0) {
                    this.duelEvent.m_142711_(0.0f);
                    this.duelEvent.m_6456_(this.status.getComponent());
                } else {
                    this.stop();
                }
            }
        }
    }

    private void spawnDuelists() {
        ArrayList<DuelistType> types = new ArrayList<DuelistType>();
        int points = this.challengerIds.size() * 8 + this.badOmenLevel * 2;
        int numBosses = this.challengerIds.size();
        this.boss = DuelistType.AXEHOUND;
        for (int i = 0; i < numBosses; ++i) {
            DuelistType[] options = this.badOmenLevel > 0 ? (i == 0 ? DuelistType.OMEN_BOSSES : DuelistType.ALL_BOSSES) : DuelistType.BOSSES;
            DuelistType type = this.getRandomType(options, points - DuelistType.BOSSES[0].getPoints() * (numBosses - i - 1));
            types.add(type);
            points -= type.getPoints();
            if (type.getPoints() <= this.boss.getPoints()) continue;
            this.boss = type;
        }
        this.duelEvent.m_6456_(this.boss.getComponent());
        while (points > 0) {
            DuelistType type = this.getRandomType(DuelistType.MINIONS, points);
            types.add(type);
            points -= type.getPoints();
        }
        DifficultyInstance difficulty = this.level.m_6436_(this.arenaCenter);
        this.totalHealth = 0.0f;
        for (DuelistType type : types) {
            IDuelist duelist = this.spawnDuelist(type, difficulty);
            if (duelist == null) continue;
            this.totalHealth += duelist.asMob().m_21223_();
        }
        this.updateBossbar();
        this.setDirty();
    }

    private DuelistType getRandomType(DuelistType[] pOptions, int pPoints) {
        int offset = this.level.f_46441_.m_188503_(pOptions.length);
        for (int i = pOptions.length - 1; i >= 0; --i) {
            DuelistType type = pOptions[(i + offset) % pOptions.length];
            if (type.getPoints() > pPoints) continue;
            return type;
        }
        return pOptions[0];
    }

    private IDuelist spawnDuelist(DuelistType pType, DifficultyInstance pDifficulty) {
        BlockPos.MutableBlockPos spawnPos = this.arenaCenter.m_122032_();
        float angle = this.level.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
        float distance = 2.0f + this.level.f_46441_.m_188501_() * 12.0f;
        spawnPos.m_142451_(this.arenaCenter.m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)angle) * distance)));
        spawnPos.m_142443_(this.arenaCenter.m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)angle) * distance)));
        spawnPos.m_142448_(this.level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)spawnPos).m_123342_());
        if (!this.level.m_143340_((BlockPos)spawnPos)) {
            return null;
        }
        IDuelist duelist = switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case DuelistType.AXEHOUND -> (Axehound)((EntityType)StormwardEntities.AXEHOUND.get()).m_20615_((Level)this.level);
            case DuelistType.DARKEYES_MELEE -> this.soldierWithItem(new ItemStack((ItemLike)StormwardItems.IRON_SPEAR.get()));
            case DuelistType.DARKEYES_RANGED -> this.soldierWithItem(new ItemStack((ItemLike)Items.f_42717_));
            case DuelistType.LIGHTEYES -> {
                AlethiSoldier soldier = (AlethiSoldier)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()).m_20615_((Level)this.level);
                if (soldier != null) {
                    soldier.setLighteyes(true);
                    soldier.populateDefaultEquipment(pDifficulty);
                }
                yield soldier;
            }
            case DuelistType.SWORDMASTER -> this.soldierWithItem(new ItemStack((ItemLike)Items.f_42388_), true);
            case DuelistType.WHITESPINE -> (Whitespine)((EntityType)StormwardEntities.WHITESPINE.get()).m_20615_((Level)this.level);
            case DuelistType.DEMOLISHER -> this.soldierWithItem(new ItemStack((ItemLike)StormwardItems.SHARDHAMMER.get()), true);
            case DuelistType.SHARPSHOOTER -> this.soldierWithItem(new ItemStack((ItemLike)StormwardItems.GRANDBOW.get()), true);
            case DuelistType.SHARDBEARER -> {
                AlethiSoldier soldier = (AlethiSoldier)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()).m_20615_((Level)this.level);
                if (soldier != null) {
                    soldier.setShardbearer();
                    soldier.populateDefaultEquipment(pDifficulty);
                }
                yield soldier;
            }
        };
        if (duelist != null) {
            PathfinderMob mob = duelist.asMob();
            mob.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
            mob.m_6518_((ServerLevelAccessor)this.level, pDifficulty, MobSpawnType.EVENT, null, null);
            this.level.m_47205_((Entity)mob);
            this.addMob(duelist);
            mob.m_21373_();
        }
        return duelist;
    }

    private AlethiSoldier soldierWithItem(ItemStack pItem) {
        return this.soldierWithItem(pItem, false);
    }

    private AlethiSoldier soldierWithItem(ItemStack pItem, boolean pElite) {
        AlethiSoldier soldier = (AlethiSoldier)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()).m_20615_((Level)this.level);
        if (soldier != null) {
            StormlightStorageHelper.setFull((ICapabilityProvider)pItem);
            soldier.m_8061_(EquipmentSlot.MAINHAND, pItem);
            if (pElite) {
                this.setElite(soldier);
            }
        }
        return soldier;
    }

    private void setElite(AlethiSoldier pSoldier) {
        pSoldier.setLighteyes(true);
        pSoldier.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
        pSoldier.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42473_));
        pSoldier.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42474_));
        pSoldier.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42475_));
        Shardbearer.trimArmorForEntity((LivingEntity)pSoldier);
        pSoldier.m_21051_(Attributes.f_22276_).m_22125_(ELITE_HEALTH_MODIFIER);
        pSoldier.m_21153_(pSoldier.m_21233_());
    }

    public void addMob(IDuelist pDuelist) {
        this.duelists.add(pDuelist);
        pDuelist.setDuel(this);
        pDuelist.asMob().m_21051_(Attributes.f_22277_).m_22118_(FOLLOW_RANGE_MODIFIER);
        pDuelist.asMob().m_21446_(this.arenaCenter, 15);
        this.updateBossbar();
    }

    public void removeMob(IDuelist pDuelist) {
        this.duelists.remove(pDuelist);
        pDuelist.setDuel(null);
        pDuelist.asMob().m_21051_(Attributes.f_22277_).m_22120_(FOLLOW_RANGE_UUID);
        pDuelist.asMob().m_147271_();
    }

    public void discardMobs() {
        for (IDuelist duelist : this.duelists) {
            duelist.asMob().m_21373_();
            duelist.asMob().m_146870_();
        }
        this.duelists.clear();
    }

    private boolean canSeeBossbar(ServerPlayer pPlayer) {
        return DuelingPitBlock.isInArenaHorizontal(this.arenaCenter, (Entity)pPlayer) || this.arenaCenter.m_203193_((Position)pPlayer.m_20182_()) <= 1024.0;
    }

    private void updatePlayers() {
        if (this.ticksActive % 20L == 0L) {
            for (ServerPlayer serverPlayer : this.level.m_8795_(this::canSeeBossbar)) {
                if (this.isChallenger((LivingEntity)serverPlayer)) {
                    this.challengers.add((Player)serverPlayer);
                }
                this.duelEvent.m_6543_(serverPlayer);
            }
            for (ServerPlayer serverPlayer : this.duelEvent.m_8324_()) {
                if (this.canSeeBossbar(serverPlayer)) continue;
                this.duelEvent.m_6539_(serverPlayer);
            }
        }
        if (!this.isOver()) {
            for (Player player : this.challengers) {
                if (!DuelingPitBlock.isInArena(this.arenaCenter, (Entity)player)) {
                    this.forfeit();
                    return;
                }
                if (!player.m_21224_()) continue;
                if (this.challengerIds.size() == 1) {
                    this.loss();
                    return;
                }
                this.challengerIds.remove(player.m_20148_());
                this.challengers.remove(player);
            }
        }
    }

    private void setBarrierLayer(int pLayer, BlockState pState) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double checkRadiusSqr = 225.0;
        AtomicInteger i = new AtomicInteger();
        DuelingPitBlock.getBlockStream(this.arenaCenter, pLayer, pLayer).filter(pos -> pos.m_123331_((Vec3i)this.arenaCenter) >= checkRadiusSqr).forEach(pos -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                mutable.m_122159_((Vec3i)pos, direction);
                if (DuelingPitBlock.isInArenaHorizontal(this.arenaCenter, (Vec3i)mutable)) continue;
                BlockState state = this.level.m_8055_((BlockPos)mutable);
                if (!state.m_60795_() && !state.m_60713_((Block)StormwardBlocks.DUELING_PIT_BARRIER.get())) {
                    this.level.m_46961_((BlockPos)mutable, true);
                }
                if (state.equals(pState)) continue;
                this.level.m_7731_((BlockPos)mutable, pState, 3);
                if (i.incrementAndGet() % 4 != 0) continue;
                SoundType type = ((DuelingPitBarrierBlock)((Object)((Object)StormwardBlocks.DUELING_PIT_BARRIER.get()))).getSoundType(((DuelingPitBarrierBlock)((Object)((Object)StormwardBlocks.DUELING_PIT_BARRIER.get()))).m_49966_(), (LevelReader)this.level, (BlockPos)mutable, null);
                if (pState.m_60795_()) {
                    this.level.m_5594_(null, (BlockPos)mutable, type.m_56775_(), SoundSource.BLOCKS, (type.m_56773_() + 1.0f) / 2.0f, type.m_56774_() * 0.8f);
                    continue;
                }
                this.level.m_5594_(null, (BlockPos)mutable, type.m_56777_(), SoundSource.BLOCKS, (type.m_56773_() + 1.0f) / 2.0f, type.m_56774_() * 0.8f);
            }
        });
    }

    public void onDuelistDamaged(IDuelist duelist) {
        IDuelist attackerDuelist;
        LivingEntity attacker = duelist.asMob().m_21188_();
        if (!(attacker == null || this.isChallenger(attacker) || attacker instanceof IDuelist && this.duelists.contains(attackerDuelist = (IDuelist)attacker))) {
            this.forfeit();
            return;
        }
        this.updateBossbar();
    }

    public void updateBossbar() {
        if (!this.isOver()) {
            this.duelEvent.m_142711_(Mth.m_14036_((float)(this.getHealthOfLivingDuelists() / this.totalHealth), (float)0.0f, (float)1.0f));
        }
    }

    public float getHealthOfLivingDuelists() {
        float total = 0.0f;
        for (IDuelist duelist : this.duelists) {
            total += duelist.asMob().m_21223_();
        }
        return total;
    }

    private void setDirty() {
        Duels.get(this.level).m_77762_();
    }

    public int getId() {
        return this.id;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getArenaCenter() {
        return this.arenaCenter;
    }

    public boolean isChallenger(LivingEntity pEntity) {
        return this.challengerIds.contains(pEntity.m_20148_());
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss() || this.isForfeit();
    }

    public boolean isVictory() {
        return this.status == DuelStatus.VICTORY;
    }

    public void victory() {
        this.status = DuelStatus.VICTORY;
        this.delay = 600;
        for (Player player : this.challengers) {
            Gloryspren.tryAddForEntity((LivingEntity)player);
        }
        this.setBlockActive(false);
        this.setDirty();
    }

    public boolean isLoss() {
        return this.status == DuelStatus.LOSS;
    }

    public void loss() {
        this.status = DuelStatus.LOSS;
        this.delay = 600;
        this.discardMobs();
        this.collectItems();
        this.setBlockActive(false);
        this.setDirty();
    }

    public boolean isForfeit() {
        return this.status == DuelStatus.FORFEIT;
    }

    public void forfeit() {
        this.loss();
        this.status = DuelStatus.FORFEIT;
    }

    public boolean isStopped() {
        return this.status == DuelStatus.STOPPED;
    }

    public void stop() {
        this.status = DuelStatus.STOPPED;
        this.active = false;
        this.duelEvent.m_7706_();
        this.discardMobs();
        for (int i = 0; i < 4; ++i) {
            this.setBarrierLayer(i, Blocks.f_50016_.m_49966_());
        }
        this.setBlockActive(false);
    }

    private void setBlockActive(boolean pActive) {
        BlockState state = this.level.m_8055_(this.arenaCenter);
        if (state.m_60713_((Block)StormwardBlocks.DUELING_PIT_BLOCK.get())) {
            this.level.m_7731_(this.arenaCenter, (BlockState)state.m_61124_((Property)DuelingPitBlock.ACTIVE, (Comparable)Boolean.valueOf(pActive)), 3);
        }
    }

    private void collectItems() {
        BlockEntity blockEntity = this.level.m_7702_(this.arenaCenter);
        if (blockEntity instanceof DuelingPitEntity) {
            DuelingPitEntity duelingPitEntity = (DuelingPitEntity)blockEntity;
            for (ItemEntity entity2 : DuelingPitBlock.getEntitiesInArena((Level)this.level, this.arenaCenter, ItemEntity.class, entity -> true)) {
                duelingPitEntity.addItem(entity2.m_32055_());
                entity2.m_146870_();
            }
            for (Player player : this.challengers) {
                Inventory inventory = player.m_150109_();
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    duelingPitEntity.addItem(inventory.m_8020_(i));
                }
                inventory.m_6211_();
            }
        }
    }

    public static void onVanillaGameEvent(VanillaGameEvent event) {
        IDuelist duelist;
        Entity entity;
        if (!event.getLevel().f_46443_ && event.getVanillaEvent() == GameEvent.f_223707_) {
            IDuelist duelist2;
            Entity entity2 = event.getContext().f_223711_();
            if (entity2 instanceof IDuelist && (duelist2 = (IDuelist)entity2).getDuel() != null) {
                duelist2.getDuel().removeMob(duelist2);
            }
        } else if (event.getVanillaEvent() == GameEvent.f_223706_ && (entity = event.getContext().f_223711_()) instanceof IDuelist && (duelist = (IDuelist)entity).getDuel() != null) {
            duelist.getDuel().onDuelistDamaged(duelist);
        }
    }

    static enum DuelStatus {
        ONGOING(DUEL_NAME_COMPONENT),
        VICTORY(DUEL_VICTORY_COMPONENT),
        LOSS(DUEL_DEFEAT_COMPONENT),
        FORFEIT(DUEL_FORFEIT_COMPONENT),
        STOPPED(DUEL_NAME_COMPONENT);

        private final Component component;
        private static final DuelStatus[] VALUES;

        private DuelStatus(Component pComponent) {
            this.component = pComponent;
        }

        static DuelStatus getByName(String pName) {
            for (DuelStatus status : VALUES) {
                if (!pName.equalsIgnoreCase(status.name())) continue;
                return status;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Component getComponent() {
            return this.component;
        }

        static {
            VALUES = DuelStatus.values();
        }
    }

    static enum DuelistType {
        AXEHOUND(1, DUEL_NAME_COMPONENT),
        DARKEYES_MELEE(2, DUEL_NAME_COMPONENT),
        DARKEYES_RANGED(2, DUEL_NAME_COMPONENT),
        LIGHTEYES(3, DUEL_NAME_COMPONENT),
        SWORDMASTER(4, (Component)Component.m_237115_((String)"event.stormward.duel.boss.swordmaster")),
        WHITESPINE(5, (Component)Component.m_237115_((String)"event.stormward.duel.boss.whitespine")),
        DEMOLISHER(5, (Component)Component.m_237115_((String)"event.stormward.duel.boss.demolisher")),
        SHARPSHOOTER(6, (Component)Component.m_237115_((String)"event.stormward.duel.boss.sharpshooter")),
        SHARDBEARER(10, (Component)Component.m_237115_((String)"event.stormward.duel.boss.shardbearer"));

        static final DuelistType[] MINIONS;
        static final DuelistType[] BOSSES;
        static final DuelistType[] OMEN_BOSSES;
        static final DuelistType[] ALL_BOSSES;
        private static final DuelistType[] VALUES;
        private final int points;
        private final Component component;

        private DuelistType(int pPoints, Component pComponent) {
            this.points = pPoints;
            this.component = pComponent;
        }

        static DuelistType getByName(String pName) {
            for (DuelistType type : VALUES) {
                if (!pName.equalsIgnoreCase(type.name())) continue;
                return type;
            }
            return AXEHOUND;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public int getPoints() {
            return this.points;
        }

        public Component getComponent() {
            return this.component;
        }

        static {
            MINIONS = new DuelistType[]{AXEHOUND, DARKEYES_MELEE, DARKEYES_RANGED, LIGHTEYES};
            BOSSES = new DuelistType[]{SWORDMASTER, WHITESPINE, DEMOLISHER, SHARPSHOOTER};
            OMEN_BOSSES = new DuelistType[]{SHARDBEARER};
            ALL_BOSSES = (DuelistType[])ArrayUtils.addAll((Object[])BOSSES, (Object[])OMEN_BOSSES);
            VALUES = DuelistType.values();
        }
    }
}

