/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.goal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;

public class GoToNearbyBlockGoal
extends Goal {
    private final PathfinderMob mob;
    private final int interval;
    private final double speedModifier;
    private final int distance;
    private final Predicate<BlockState> predicate;
    private BlockPos blockPos;

    public GoToNearbyBlockGoal(PathfinderMob pMob, int pInterval, double pSpeedModifier, int pDistance, Predicate<BlockState> pPredicate) {
        this.mob = pMob;
        this.interval = pInterval;
        this.speedModifier = pSpeedModifier;
        this.distance = pDistance;
        this.predicate = pPredicate;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.m_217005_()) {
            return false;
        }
        if (this.mob.m_21216_() >= 100) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(GoToNearbyBlockGoal.m_186073_((int)this.interval)) != 0) {
            return false;
        }
        BlockPos randomPos = this.findRandomBlock();
        if (randomPos != null) {
            this.blockPos = randomPos;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_217005_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_(), this.speedModifier);
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    private BlockPos findRandomBlock() {
        BlockPos center = this.mob.m_20183_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> options = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= (double)this.distance) {
            int j = 0;
            while ((double)j < (double)this.distance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        pos.m_122154_((Vec3i)center, k, i - 1, l);
                        if (center.m_123314_((Vec3i)pos, (double)this.distance) && this.predicate.test(this.mob.m_9236_().m_8055_((BlockPos)pos))) {
                            options.add(pos.m_7949_());
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return options.isEmpty() ? null : (BlockPos)options.get(this.mob.m_217043_().m_188503_(options.size()));
    }
}

