/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.navigation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.attribute.StormwardAttributes;
import us.amon.stormward.entity.chasmfiend.LargeMonster;

public class LargeNodeEvaluator
extends NodeEvaluator {
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();
    protected LargeMonster monster;
    protected int margin;

    public void m_6028_(@NotNull PathNavigationRegion pLevel, @NotNull Mob pMob) {
        super.m_6028_(pLevel, pMob);
        this.monster = (LargeMonster)pMob;
        this.f_77315_ = Mth.m_14143_((float)(this.monster.getBlockBBWidth() + 1.0f));
        this.f_77316_ = Mth.m_14143_((float)(this.monster.getBlockBBHeight() + 1.0f));
        this.f_77317_ = Mth.m_14143_((float)(this.monster.getBlockBBWidth() + 1.0f));
        this.margin = Mth.m_14107_((double)((double)(this.monster.m_20205_() - this.monster.getBlockBBWidth()) * 0.5));
        pMob.m_284177_();
    }

    public void m_6802_() {
        this.monster.m_284461_();
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        super.m_6802_();
    }

    @NotNull
    public Node m_7171_() {
        Node node = this.m_5676_(Mth.m_14107_((double)this.monster.m_20191_().f_82288_), Mth.m_14107_((double)this.monster.m_20191_().f_82289_), Mth.m_14107_((double)this.monster.m_20191_().f_82290_));
        node.f_77282_ = this.getBlockPathType((Mob)this.monster, node.m_77288_());
        node.f_77281_ = this.monster.m_21439_(node.f_77282_);
        return node;
    }

    @NotNull
    public Target m_7568_(double pX, double pY, double pZ) {
        return this.m_230615_(this.m_5676_(Mth.m_14107_((double)pX), Mth.m_14107_((double)pY), Mth.m_14107_((double)pZ)));
    }

    public int m_6065_(Node @NotNull [] pOutputArray, Node pNode) {
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        Node node2;
        Node node1;
        double d0;
        Node node;
        int i = 0;
        int j = 0;
        BlockPathTypes blockpathtypes = this.getCachedBlockType((Mob)this.monster, pNode.f_77271_, pNode.f_77272_ + 1, pNode.f_77273_);
        BlockPathTypes blockpathtypes1 = this.getCachedBlockType((Mob)this.monster, pNode.f_77271_, pNode.f_77272_, pNode.f_77273_);
        if (this.monster.m_21439_(blockpathtypes) >= 0.0f && blockpathtypes1 != BlockPathTypes.STICKY_HONEY) {
            j = Mth.m_14107_((double)this.getMobJumpHeight());
        }
        if (this.isNeighborValid(node = this.findAcceptedNode(pNode.f_77271_, pNode.f_77272_, pNode.f_77273_ + 1, j, d0 = this.getFloorLevel(new BlockPos(pNode.f_77271_, pNode.f_77272_, pNode.f_77273_)), Direction.SOUTH, blockpathtypes1), pNode)) {
            pOutputArray[i++] = node;
        }
        if (this.isNeighborValid(node1 = this.findAcceptedNode(pNode.f_77271_ - 1, pNode.f_77272_, pNode.f_77273_, j, d0, Direction.WEST, blockpathtypes1), pNode)) {
            pOutputArray[i++] = node1;
        }
        if (this.isNeighborValid(node2 = this.findAcceptedNode(pNode.f_77271_ + 1, pNode.f_77272_, pNode.f_77273_, j, d0, Direction.EAST, blockpathtypes1), pNode)) {
            pOutputArray[i++] = node2;
        }
        if (this.isNeighborValid(node3 = this.findAcceptedNode(pNode.f_77271_, pNode.f_77272_, pNode.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1), pNode)) {
            pOutputArray[i++] = node3;
        }
        if (this.isDiagonalValid(pNode, node1, node3, node4 = this.findAcceptedNode(pNode.f_77271_ - 1, pNode.f_77272_, pNode.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1))) {
            pOutputArray[i++] = node4;
        }
        if (this.isDiagonalValid(pNode, node2, node3, node5 = this.findAcceptedNode(pNode.f_77271_ + 1, pNode.f_77272_, pNode.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1))) {
            pOutputArray[i++] = node5;
        }
        if (this.isDiagonalValid(pNode, node1, node, node6 = this.findAcceptedNode(pNode.f_77271_ - 1, pNode.f_77272_, pNode.f_77273_ + 1, j, d0, Direction.SOUTH, blockpathtypes1))) {
            pOutputArray[i++] = node6;
        }
        if (this.isDiagonalValid(pNode, node2, node, node7 = this.findAcceptedNode(pNode.f_77271_ + 1, pNode.f_77272_, pNode.f_77273_ + 1, j, d0, Direction.SOUTH, blockpathtypes1))) {
            pOutputArray[i++] = node7;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable Node pNeighbor, Node pNode) {
        return pNeighbor != null && !pNeighbor.f_77279_ && (pNeighbor.f_77281_ >= 0.0f || pNode.f_77281_ < 0.0f);
    }

    protected boolean isDiagonalValid(Node pRoot, @Nullable Node pXNode, @Nullable Node pZNode, @Nullable Node pDiagonal) {
        if (pDiagonal != null && pZNode != null && pXNode != null) {
            if (pDiagonal.f_77279_) {
                return false;
            }
            if (pZNode.f_77272_ <= pRoot.f_77272_ && pXNode.f_77272_ <= pRoot.f_77272_) {
                if (pXNode.f_77282_ != BlockPathTypes.WALKABLE_DOOR && pZNode.f_77282_ != BlockPathTypes.WALKABLE_DOOR && pDiagonal.f_77282_ != BlockPathTypes.WALKABLE_DOOR) {
                    boolean flag = pZNode.f_77282_ == BlockPathTypes.FENCE && pXNode.f_77282_ == BlockPathTypes.FENCE && (double)this.monster.getBlockBBWidth() < 0.5;
                    return pDiagonal.f_77281_ >= 0.0f && (pZNode.f_77272_ < pRoot.f_77272_ || pZNode.f_77281_ >= 0.0f || flag) && (pXNode.f_77272_ < pRoot.f_77272_ || pXNode.f_77281_ >= 0.0f || flag);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static boolean doesBlockHavePartialCollision(BlockPathTypes pBlockPathType) {
        return pBlockPathType == BlockPathTypes.FENCE || pBlockPathType == BlockPathTypes.DOOR_WOOD_CLOSED || pBlockPathType == BlockPathTypes.DOOR_IRON_CLOSED;
    }

    private boolean canReachWithoutCollision(Node pNode) {
        AABB aabb = this.monster.getBlockCollisionBox();
        Vec3 vec3 = new Vec3((double)pNode.f_77271_ - this.monster.m_20185_() + aabb.m_82362_() / 2.0, (double)pNode.f_77272_ - this.monster.m_20186_() + aabb.m_82376_() / 2.0, (double)pNode.f_77273_ - this.monster.m_20189_() + aabb.m_82385_() / 2.0);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / aabb.m_82309_()));
        vec3 = vec3.m_82490_((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aabb = aabb.m_82383_(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPos pPos) {
        return (this.m_77361_() || this.isAmphibious()) && this.f_77312_.m_6425_(pPos).m_205070_(FluidTags.f_13131_) ? (double)pPos.m_123342_() + 0.5 : LargeNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, pPos);
    }

    public static double getFloorLevel(BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        VoxelShape voxelshape = pLevel.m_8055_(blockpos).m_60812_(pLevel, blockpos);
        return (double)blockpos.m_123342_() + (voxelshape.m_83281_() ? 0.0 : voxelshape.m_83297_(Direction.Axis.Y));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected Node findAcceptedNode(int pX, int pY, int pZ, int pVerticalDeltaLimit, double pNodeFloorLevel, Direction pDirection, BlockPathTypes pPathType) {
        Node node = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double d0 = this.getFloorLevel((BlockPos)blockpos$mutableblockpos.m_122178_(pX, pY, pZ));
        if (d0 - pNodeFloorLevel > this.getMobJumpHeight()) {
            return null;
        }
        BlockPathTypes blockpathtypes = this.getCachedBlockType((Mob)this.monster, pX, pY, pZ);
        float f = this.monster.m_21439_(blockpathtypes);
        double d1 = (double)this.monster.getBlockBBWidth() / 2.0;
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(pX, pY, pZ, blockpathtypes, f);
        }
        if (LargeNodeEvaluator.doesBlockHavePartialCollision(pPathType) && node != null && node.f_77281_ >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (!(blockpathtypes == BlockPathTypes.WALKABLE || this.isAmphibious() && blockpathtypes == BlockPathTypes.WATER)) {
            double d3;
            double d2;
            AABB aabb;
            if ((node == null || node.f_77281_ < 0.0f) && pVerticalDeltaLimit > 0 && (blockpathtypes != BlockPathTypes.FENCE || this.m_255100_()) && blockpathtypes != BlockPathTypes.UNPASSABLE_RAIL && blockpathtypes != BlockPathTypes.TRAPDOOR && blockpathtypes != BlockPathTypes.POWDER_SNOW && (node = this.findAcceptedNode(pX, pY + 1, pZ, pVerticalDeltaLimit - 1, pNodeFloorLevel, pDirection, pPathType)) != null && (node.f_77282_ == BlockPathTypes.OPEN || node.f_77282_ == BlockPathTypes.WALKABLE) && this.monster.getBlockBBWidth() < 1.0f && this.hasCollisions(aabb = new AABB((d2 = (double)(pX - pDirection.m_122429_()) + 0.5) - d1, this.getFloorLevel((BlockPos)blockpos$mutableblockpos.m_122169_(d2, (double)(pY + 1), d3 = (double)(pZ - pDirection.m_122431_()) + 0.5)) + 0.001, d3 - d1, d2 + d1, (double)this.monster.getBlockBBHeight() + this.getFloorLevel((BlockPos)blockpos$mutableblockpos.m_122169_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_)) - 0.002, d3 + d1))) {
                node = null;
            }
            if (!this.isAmphibious() && blockpathtypes == BlockPathTypes.WATER && !this.m_77361_()) {
                if (this.getCachedBlockType((Mob)this.monster, pX, pY - 1, pZ) != BlockPathTypes.WATER) {
                    return node;
                }
                while (pY > this.monster.m_9236_().m_141937_()) {
                    if ((blockpathtypes = this.getCachedBlockType((Mob)this.monster, pX, --pY, pZ)) != BlockPathTypes.WATER) {
                        return node;
                    }
                    node = this.getNodeAndUpdateCostToMax(pX, pY, pZ, blockpathtypes, this.monster.m_21439_(blockpathtypes));
                }
            }
            if (blockpathtypes == BlockPathTypes.OPEN) {
                int j = 0;
                int i = pY;
                while (blockpathtypes == BlockPathTypes.OPEN) {
                    if (--pY < this.monster.m_9236_().m_141937_()) {
                        return this.getBlockedNode(pX, i, pZ);
                    }
                    if (j++ >= this.monster.m_6056_()) {
                        return this.getBlockedNode(pX, pY, pZ);
                    }
                    blockpathtypes = this.getCachedBlockType((Mob)this.monster, pX, pY, pZ);
                    f = this.monster.m_21439_(blockpathtypes);
                    if (blockpathtypes != BlockPathTypes.OPEN && f >= 0.0f) {
                        node = this.getNodeAndUpdateCostToMax(pX, pY, pZ, blockpathtypes, f);
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    return this.getBlockedNode(pX, pY, pZ);
                }
            }
            if (LargeNodeEvaluator.doesBlockHavePartialCollision(blockpathtypes) && node == null) {
                node = this.m_5676_(pX, pY, pZ);
                node.f_77279_ = true;
                node.f_77282_ = blockpathtypes;
                node.f_77281_ = blockpathtypes.m_77124_();
            }
            return node;
        }
        return node;
    }

    private double getMobJumpHeight() {
        AttributeInstance jumpHeight = this.monster.m_21051_((Attribute)StormwardAttributes.JUMP_HEIGHT_ADDITION.get());
        return Math.max(1.0 + (jumpHeight != null ? jumpHeight.m_22135_() : 0.0), (double)this.monster.getStepHeight());
    }

    private Node getNodeAndUpdateCostToMax(int pX, int pY, int pZ, BlockPathTypes pType, float pCostMalus) {
        Node node = this.m_5676_(pX, pY, pZ);
        node.f_77282_ = pType;
        node.f_77281_ = Math.max(node.f_77281_, pCostMalus);
        return node;
    }

    private Node getBlockedNode(int pX, int pY, int pZ) {
        Node node = this.m_5676_(pX, pY, pZ);
        node.f_77282_ = BlockPathTypes.BLOCKED;
        node.f_77281_ = -1.0f;
        return node;
    }

    private boolean hasCollisions(AABB pBoundingBox) {
        return this.collisionCache.computeIfAbsent((Object)pBoundingBox, p_192973_ -> !this.f_77312_.m_45756_((Entity)this.monster, pBoundingBox));
    }

    public BlockPathTypes m_7209_(BlockGetter pLevel, int pX, int pY, int pZ, Mob pMob) {
        EnumSet<BlockPathTypes> enumset = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockpathtypes = BlockPathTypes.BLOCKED;
        blockpathtypes = this.getBlockPathTypes(pLevel, pX, pY, pZ, enumset, blockpathtypes, pMob.m_20183_());
        if (enumset.contains(BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        if (enumset.contains(BlockPathTypes.UNPASSABLE_RAIL)) {
            return BlockPathTypes.UNPASSABLE_RAIL;
        }
        BlockPathTypes blockpathtypes1 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockpathtypes2 : enumset) {
            if (pMob.m_21439_(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(pMob.m_21439_(blockpathtypes2) >= pMob.m_21439_(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockpathtypes == BlockPathTypes.OPEN && pMob.m_21439_(blockpathtypes1) == 0.0f && this.f_77315_ <= 1 ? BlockPathTypes.OPEN : blockpathtypes1;
    }

    public BlockPathTypes getBlockPathTypes(BlockGetter pLevel, int pXOffset, int pYOffset, int pZOffset, EnumSet<BlockPathTypes> pOutput, BlockPathTypes pFallbackPathType, BlockPos pPos) {
        for (int i = 0; i < this.f_77315_; ++i) {
            for (int j = 0; j < this.f_77316_; ++j) {
                for (int k = 0; k < this.f_77317_; ++k) {
                    int l = i + pXOffset + this.margin;
                    int i1 = j + pYOffset;
                    int j1 = k + pZOffset + this.margin;
                    BlockPathTypes blockpathtypes = this.m_8086_(pLevel, l, i1, j1);
                    blockpathtypes = this.evaluateBlockPathType(pLevel, pPos, blockpathtypes);
                    if (i == 0 && j == 0 && k == 0) {
                        pFallbackPathType = blockpathtypes;
                    }
                    pOutput.add(blockpathtypes);
                }
            }
        }
        return pFallbackPathType;
    }

    protected BlockPathTypes evaluateBlockPathType(BlockGetter pLevel, BlockPos pPos, BlockPathTypes pPathTypes) {
        boolean flag = this.m_77357_();
        if (pPathTypes == BlockPathTypes.DOOR_WOOD_CLOSED && this.m_77360_() && flag) {
            pPathTypes = BlockPathTypes.WALKABLE_DOOR;
        }
        if (pPathTypes == BlockPathTypes.DOOR_OPEN && !flag) {
            pPathTypes = BlockPathTypes.BLOCKED;
        }
        if (pPathTypes == BlockPathTypes.RAIL && !(pLevel.m_8055_(pPos).m_60734_() instanceof BaseRailBlock) && !(pLevel.m_8055_(pPos.m_7495_()).m_60734_() instanceof BaseRailBlock)) {
            pPathTypes = BlockPathTypes.UNPASSABLE_RAIL;
        }
        return pPathTypes;
    }

    protected BlockPathTypes getBlockPathType(Mob pEntityliving, BlockPos pPos) {
        return this.getCachedBlockType(pEntityliving, pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
    }

    protected BlockPathTypes getCachedBlockType(Mob pEntity, int pX, int pY, int pZ) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)pX, (int)pY, (int)pZ), p_265015_ -> this.m_7209_((BlockGetter)this.f_77312_, pX, pY, pZ, pEntity));
    }

    public BlockPathTypes m_8086_(BlockGetter pLevel, int pX, int pY, int pZ) {
        return LargeNodeEvaluator.getBlockPathTypeStatic(pLevel, new BlockPos.MutableBlockPos(pX, pY, pZ), this.monster);
    }

    public static BlockPathTypes getBlockPathTypeStatic(BlockGetter pLevel, BlockPos.MutableBlockPos pPos, LargeMonster pMonster) {
        int i = pPos.m_123341_();
        int j = pPos.m_123342_();
        int k = pPos.m_123343_();
        BlockPathTypes blockpathtypes = LargeNodeEvaluator.getBlockPathTypeRaw(pLevel, (BlockPos)pPos, pMonster);
        if (blockpathtypes == BlockPathTypes.OPEN && j >= pLevel.m_141937_() + 1) {
            BlockPathTypes blockpathtypes1 = LargeNodeEvaluator.getBlockPathTypeRaw(pLevel, (BlockPos)pPos.m_122178_(i, j - 1, k), pMonster);
            BlockPathTypes blockPathTypes = blockpathtypes = blockpathtypes1 != BlockPathTypes.WALKABLE && blockpathtypes1 != BlockPathTypes.OPEN && blockpathtypes1 != BlockPathTypes.WATER && blockpathtypes1 != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_FIRE) {
                blockpathtypes = BlockPathTypes.DAMAGE_FIRE;
            }
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_OTHER) {
                blockpathtypes = BlockPathTypes.DAMAGE_OTHER;
            }
            if (blockpathtypes1 == BlockPathTypes.STICKY_HONEY) {
                blockpathtypes = BlockPathTypes.STICKY_HONEY;
            }
            if (blockpathtypes1 == BlockPathTypes.POWDER_SNOW) {
                blockpathtypes = BlockPathTypes.DANGER_POWDER_SNOW;
            }
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_CAUTIOUS) {
                blockpathtypes = BlockPathTypes.DAMAGE_CAUTIOUS;
            }
        }
        if (blockpathtypes == BlockPathTypes.WALKABLE) {
            blockpathtypes = LargeNodeEvaluator.checkNeighbourBlocks(pLevel, pPos.m_122178_(i, j, k), blockpathtypes);
        }
        return blockpathtypes;
    }

    public static BlockPathTypes checkNeighbourBlocks(BlockGetter pLevel, BlockPos.MutableBlockPos pCenterPos, BlockPathTypes pNodeType) {
        int i = pCenterPos.m_123341_();
        int j = pCenterPos.m_123342_();
        int k = pCenterPos.m_123343_();
        for (int l = -1; l <= 1; ++l) {
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int j1 = -1; j1 <= 1; ++j1) {
                    if (l == 0 && j1 == 0) continue;
                    pCenterPos.m_122178_(i + l, j + i1, k + j1);
                    BlockState blockstate = pLevel.m_8055_((BlockPos)pCenterPos);
                    BlockPathTypes blockPathType = blockstate.getAdjacentBlockPathType(pLevel, (BlockPos)pCenterPos, null, pNodeType);
                    if (blockPathType != null) {
                        return blockPathType;
                    }
                    FluidState fluidState = blockstate.m_60819_();
                    BlockPathTypes fluidPathType = fluidState.getAdjacentBlockPathType(pLevel, (BlockPos)pCenterPos, null, pNodeType);
                    if (fluidPathType != null) {
                        return fluidPathType;
                    }
                    if (blockstate.m_60713_(Blocks.f_50128_) || blockstate.m_60713_(Blocks.f_50685_)) {
                        return BlockPathTypes.DANGER_OTHER;
                    }
                    if (LargeNodeEvaluator.isBurningBlock(blockstate)) {
                        return BlockPathTypes.DANGER_FIRE;
                    }
                    if (pLevel.m_6425_((BlockPos)pCenterPos).m_205070_(FluidTags.f_13131_)) {
                        return BlockPathTypes.WATER_BORDER;
                    }
                    if (!blockstate.m_60713_(Blocks.f_50070_) && !blockstate.m_60713_(Blocks.f_152588_)) continue;
                    return BlockPathTypes.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pNodeType;
    }

    protected static BlockPathTypes getBlockPathTypeRaw(BlockGetter pLevel, BlockPos pPos, LargeMonster pMonster) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        BlockPathTypes type = blockstate.getBlockPathType(pLevel, pPos, null);
        if (type != null) {
            return type;
        }
        Block block = blockstate.m_60734_();
        if (blockstate.m_60795_() || pMonster.canDestroyBlock(pLevel, pPos, blockstate)) {
            return BlockPathTypes.OPEN;
        }
        if (!(blockstate.m_204336_(BlockTags.f_13036_) || blockstate.m_60713_(Blocks.f_50196_) || blockstate.m_60713_(Blocks.f_152545_))) {
            if (blockstate.m_60713_(Blocks.f_152499_)) {
                return BlockPathTypes.POWDER_SNOW;
            }
            if (!blockstate.m_60713_(Blocks.f_50128_) && !blockstate.m_60713_(Blocks.f_50685_)) {
                if (blockstate.m_60713_(Blocks.f_50719_)) {
                    return BlockPathTypes.STICKY_HONEY;
                }
                if (blockstate.m_60713_(Blocks.f_50262_)) {
                    return BlockPathTypes.COCOA;
                }
                if (!blockstate.m_60713_(Blocks.f_50070_) && !blockstate.m_60713_(Blocks.f_152588_)) {
                    FluidState fluidstate = pLevel.m_6425_(pPos);
                    BlockPathTypes nonLoggableFluidPathType = fluidstate.getBlockPathType(pLevel, pPos, null, false);
                    if (nonLoggableFluidPathType != null) {
                        return nonLoggableFluidPathType;
                    }
                    if (fluidstate.m_205070_(FluidTags.f_13132_)) {
                        return BlockPathTypes.LAVA;
                    }
                    if (LargeNodeEvaluator.isBurningBlock(blockstate)) {
                        return BlockPathTypes.DAMAGE_FIRE;
                    }
                    if (block instanceof DoorBlock) {
                        DoorBlock doorblock = (DoorBlock)block;
                        if (((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                            return BlockPathTypes.DOOR_OPEN;
                        }
                        return doorblock.m_278711_().f_278463_() ? BlockPathTypes.DOOR_WOOD_CLOSED : BlockPathTypes.DOOR_IRON_CLOSED;
                    }
                    if (block instanceof BaseRailBlock) {
                        return BlockPathTypes.RAIL;
                    }
                    if (block instanceof LeavesBlock) {
                        return BlockPathTypes.LEAVES;
                    }
                    if (!(blockstate.m_204336_(BlockTags.f_13039_) || blockstate.m_204336_(BlockTags.f_13032_) || block instanceof FenceGateBlock && !((Boolean)blockstate.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue())) {
                        if (!blockstate.m_60647_(pLevel, pPos, PathComputationType.LAND)) {
                            return BlockPathTypes.BLOCKED;
                        }
                        BlockPathTypes loggableFluidPathType = fluidstate.getBlockPathType(pLevel, pPos, null, true);
                        if (loggableFluidPathType != null) {
                            return loggableFluidPathType;
                        }
                        return fluidstate.m_205070_(FluidTags.f_13131_) ? BlockPathTypes.WATER : BlockPathTypes.OPEN;
                    }
                    return BlockPathTypes.FENCE;
                }
                return BlockPathTypes.DAMAGE_CAUTIOUS;
            }
            return BlockPathTypes.DAMAGE_OTHER;
        }
        return BlockPathTypes.TRAPDOOR;
    }

    public static boolean isBurningBlock(BlockState pState) {
        return pState.m_204336_(BlockTags.f_13076_) || pState.m_60713_(Blocks.f_49991_) || pState.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)pState) || pState.m_60713_(Blocks.f_152477_);
    }
}

