/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.patrol;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.shardbearer.AlethiSoldier;

public class AlethiPatrolSpawner
implements CustomSpawner {
    private int nextTick;

    public int m_7995_(@NotNull ServerLevel pLevel, boolean pSpawnEnemies, boolean pSpawnFriendlies) {
        if (!pSpawnEnemies) {
            return 0;
        }
        if (!pLevel.m_46469_().m_46207_(GameRules.f_46124_)) {
            return 0;
        }
        RandomSource randomsource = pLevel.f_46441_;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += 12000 + randomsource.m_188503_(1200);
        long i = pLevel.m_46468_() / 24000L;
        if (i >= 5L && pLevel.m_46461_()) {
            if (randomsource.m_188503_(5) != 0) {
                return 0;
            }
            int j = pLevel.m_6907_().size();
            if (j < 1) {
                return 0;
            }
            Player player = (Player)pLevel.m_6907_().get(randomsource.m_188503_(j));
            if (player.m_5833_()) {
                return 0;
            }
            if (pLevel.m_8736_(player.m_20183_(), 2)) {
                return 0;
            }
            int k = (24 + randomsource.m_188503_(24)) * (randomsource.m_188499_() ? -1 : 1);
            int l = (24 + randomsource.m_188503_(24)) * (randomsource.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = player.m_20183_().m_122032_().m_122184_(k, 0, l);
            int i1 = 10;
            if (!pLevel.m_151572_(blockpos$mutableblockpos.m_123341_() - 10, blockpos$mutableblockpos.m_123343_() - 10, blockpos$mutableblockpos.m_123341_() + 10, blockpos$mutableblockpos.m_123343_() + 10)) {
                return 0;
            }
            Holder holder = pLevel.m_204166_((BlockPos)blockpos$mutableblockpos);
            if (holder.m_203656_(BiomeTags.f_215806_)) {
                return 0;
            }
            int j1 = 0;
            int k1 = (int)Math.ceil(pLevel.m_6436_((BlockPos)blockpos$mutableblockpos).m_19056_()) + 1;
            AlethiSoldier leader = null;
            for (int l1 = 0; l1 < k1; ++l1) {
                ++j1;
                blockpos$mutableblockpos.m_142448_(pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).m_123342_());
                if (l1 == 0) {
                    leader = this.spawnPatrolMember(pLevel, (BlockPos)blockpos$mutableblockpos, randomsource, true);
                    if (leader == null) {
                        break;
                    }
                } else {
                    AlethiSoldier alethi = this.spawnPatrolMember(pLevel, (BlockPos)blockpos$mutableblockpos, randomsource, false);
                    if (alethi != null) {
                        alethi.setPatrolTarget(leader.getPatrolTarget());
                    }
                }
                blockpos$mutableblockpos.m_142451_(blockpos$mutableblockpos.m_123341_() + randomsource.m_188503_(5) - randomsource.m_188503_(5));
                blockpos$mutableblockpos.m_142443_(blockpos$mutableblockpos.m_123343_() + randomsource.m_188503_(5) - randomsource.m_188503_(5));
            }
            return j1;
        }
        return 0;
    }

    private AlethiSoldier spawnPatrolMember(ServerLevel pLevel, BlockPos pPos, RandomSource pRandom, boolean pLeader) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (!NaturalSpawner.m_47056_((BlockGetter)pLevel, (BlockPos)pPos, (BlockState)blockstate, (FluidState)blockstate.m_60819_(), (EntityType)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()))) {
            return null;
        }
        if (!AlethiSoldier.checkSpawnRules((EntityType<AlethiSoldier>)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()), (ServerLevelAccessor)pLevel, MobSpawnType.PATROL, pPos, pRandom)) {
            return null;
        }
        AlethiSoldier alethi = (AlethiSoldier)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()).m_20615_((Level)pLevel);
        if (alethi != null) {
            if (pLeader) {
                alethi.setPatrolLeader(true);
                alethi.findPatrolTarget();
            }
            alethi.m_6034_(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
            alethi.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(pPos), MobSpawnType.PATROL, null, null);
            pLevel.m_47205_((Entity)alethi);
            return alethi;
        }
        return null;
    }
}

