/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.plateaurun;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.brain.WarformAi;
import us.amon.stormward.entity.plateaurun.PlateauRunner;
import us.amon.stormward.entity.shardbearer.WarformListener;
import us.amon.stormward.entity.spren.overworld.Gloryspren;
import us.amon.stormward.tag.StormwardBlockTags;

public class PlateauRun {
    private static final Component PLATEAU_RUN_NAME_COMPONENT = Component.m_237115_((String)"event.stormward.plateaurun");
    private static final Component PLATEAU_RUN_EXTRACTION_COMPONENT = Component.m_237115_((String)"event.stormward.plateaurun.extraction");
    private static final Component PLATEAU_RUN_VICTORY_COMPONENT = Component.m_237115_((String)"event.stormward.plateaurun.victory");
    private static final Component PLATEAU_RUN_DEFEAT_COMPONENT = Component.m_237115_((String)"event.stormward.plateaurun.defeat");
    private static final double PLAYER_JOIN_RADIUS = 96.0;
    private static final double RUNNER_JOIN_RADIUS = 32.0;
    private static final int MIN_WAVE_SIZE = 3;
    private static final int BASE_WAVE_SIZE = 8;
    private static final int WAVE_COOLDOWN = 400;
    private static final int EXTRACTOR_COOLDOWN = 100;
    private static final int EXTRACTION_TIME = 2400;
    private static final int MIN_SPAWN_RADIUS = 4;
    private static final int MAX_SPAWN_RADIUS = 12;
    private final int id;
    private final ServerLevel level;
    private final BlockPos gemheartPos;
    private final ServerBossEvent plateauRunEvent = new ServerBossEvent(PLATEAU_RUN_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private boolean active;
    private boolean started;
    private PlateauRunStatus status;
    private long ticksActive;
    private int extractionTicks;
    private int celebrationTicks;
    private final Set<PlateauRunner> runners = new HashSet<PlateauRunner>();
    private PlateauRunner extractor;
    private PlateauRunner shardbearer;
    private int waveCooldownTicks;
    private int extractorCooldownTicks;
    private final Set<UUID> participants = Sets.newHashSet();

    public PlateauRun(int pId, ServerLevel pLevel, BlockPos pGemheartPos) {
        this.id = pId;
        this.level = pLevel;
        this.gemheartPos = pGemheartPos;
        this.plateauRunEvent.m_142711_(0.0f);
        this.active = true;
        this.status = PlateauRunStatus.ONGOING;
        this.waveCooldownTicks = 400;
        this.extractorCooldownTicks = 100;
    }

    public PlateauRun(ServerLevel pLevel, CompoundTag pCompound) {
        this.level = pLevel;
        this.id = pCompound.m_128451_("Id");
        this.active = pCompound.m_128471_("Active");
        this.started = pCompound.m_128471_("Started");
        this.ticksActive = pCompound.m_128454_("TicksActive");
        this.gemheartPos = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("Gemheart"));
        this.status = PlateauRunStatus.getByName(pCompound.m_128461_("Status"));
        this.extractionTicks = pCompound.m_128451_("ExtractionTicks");
        this.waveCooldownTicks = pCompound.m_128451_("WaveCooldownTicks");
        this.participants.clear();
        if (pCompound.m_128425_("Participants", 9)) {
            for (Tag tag : pCompound.m_128437_("Participants", 11)) {
                this.participants.add(NbtUtils.m_129233_((Tag)tag));
            }
        }
        this.plateauRunEvent.m_142711_(Math.min((float)this.extractionTicks / 2400.0f, 1.0f));
        this.extractorCooldownTicks = 100;
    }

    public CompoundTag save(CompoundTag pCompound) {
        pCompound.m_128405_("Id", this.id);
        pCompound.m_128379_("Active", this.active);
        pCompound.m_128379_("Started", this.started);
        pCompound.m_128356_("TicksActive", this.ticksActive);
        pCompound.m_128359_("Status", this.status.getName());
        pCompound.m_128365_("Gemheart", (Tag)NbtUtils.m_129224_((BlockPos)this.gemheartPos));
        pCompound.m_128405_("ExtractionTicks", this.extractionTicks);
        pCompound.m_128405_("WaveCooldownTicks", this.waveCooldownTicks);
        ListTag participantsTag = new ListTag();
        for (UUID uuid : this.participants) {
            participantsTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        pCompound.m_128365_("Participants", (Tag)participantsTag);
        return pCompound;
    }

    public void tick() {
        if (!this.isStopped()) {
            if (!this.isOver()) {
                boolean oldActive = this.active;
                this.active = this.level.m_46805_(this.gemheartPos);
                if (this.level.m_46791_() == Difficulty.PEACEFUL) {
                    this.stop();
                    return;
                }
                if (oldActive != this.active) {
                    this.plateauRunEvent.m_8321_(this.active);
                }
                if (!this.active) {
                    return;
                }
                ++this.ticksActive;
                if (this.ticksActive >= 24000L) {
                    this.stop();
                    if (this.level.m_8055_(this.gemheartPos).m_204336_(StormwardBlockTags.GEMHEARTS)) {
                        this.level.m_46961_(this.gemheartPos, false);
                    }
                    return;
                }
                if (this.extractionTicks >= 2400) {
                    this.loss();
                } else if (!this.level.m_8055_(this.gemheartPos).m_204336_(StormwardBlockTags.GEMHEARTS)) {
                    this.victory();
                }
                if (this.waveCooldownTicks <= 0) {
                    if (!this.isStarted() || this.runners.stream().filter(runner -> !runner.isShardbearer()).count() < 3L) {
                        this.spawnWave();
                        this.started = true;
                        this.waveCooldownTicks = 400;
                    }
                } else {
                    --this.waveCooldownTicks;
                }
                if (this.isStarted()) {
                    if (!(this.isRunnerValid(this.extractor) && this.extractor.isExtractor() || --this.extractorCooldownTicks > 0)) {
                        this.findNewExtractor();
                    }
                    if (this.isRunnerValid(this.extractor) && this.extractor.isExtractingGemheart()) {
                        ++this.extractionTicks;
                        this.setEventName(PLATEAU_RUN_EXTRACTION_COMPONENT);
                    } else {
                        this.setEventName(PLATEAU_RUN_NAME_COMPONENT);
                    }
                    this.plateauRunEvent.m_142711_(Math.min((float)this.extractionTicks / 2400.0f, 1.0f));
                } else {
                    this.plateauRunEvent.m_142711_(Mth.m_14036_((float)((float)(400 - this.waveCooldownTicks) / 400.0f), (float)0.0f, (float)1.0f));
                }
                if (this.ticksActive % 20L == 0L) {
                    this.updatePlayers();
                    this.updatePlateauRunners();
                }
            } else {
                if (++this.celebrationTicks >= 600) {
                    this.stop();
                    return;
                }
                if (this.celebrationTicks % 20 == 0) {
                    this.updatePlayers();
                    this.plateauRunEvent.m_8321_(true);
                    if (this.isVictory()) {
                        this.plateauRunEvent.m_142711_(0.0f);
                        this.setEventName(PLATEAU_RUN_VICTORY_COMPONENT);
                    } else {
                        this.setEventName(PLATEAU_RUN_DEFEAT_COMPONENT);
                    }
                }
            }
        }
    }

    public void playerDestroyedGemheart(Player pPlayer) {
        this.participants.add(pPlayer.m_20148_());
        this.victory();
    }

    private void setEventName(Component pName) {
        if (!this.plateauRunEvent.m_18861_().equals(pName)) {
            this.plateauRunEvent.m_6456_(pName);
        }
    }

    private Predicate<ServerPlayer> validPlayer() {
        return player -> player.m_6084_() && player.m_20238_(this.gemheartPos.m_252807_()) < 9216.0;
    }

    private void updatePlayers() {
        HashSet currentPlayers = Sets.newHashSet((Iterable)this.plateauRunEvent.m_8324_());
        List validPlayers = this.level.m_8795_(this.validPlayer());
        for (ServerPlayer player : validPlayers) {
            if (currentPlayers.contains(player)) continue;
            this.plateauRunEvent.m_6543_(player);
        }
        for (ServerPlayer player : currentPlayers) {
            if (validPlayers.contains(player)) continue;
            this.plateauRunEvent.m_6539_(player);
        }
    }

    private void absorbBadOmen(Player pPlayer) {
        if (pPlayer.m_21023_(MobEffects.f_19594_) && !this.isRunnerValid(this.shardbearer)) {
            this.spawnShardbearer();
        }
        pPlayer.m_21195_(MobEffects.f_19594_);
    }

    private void updatePlateauRunners() {
        List<PlateauRunner> validRunners = this.level.m_45976_(PlateauRunner.class, new AABB(this.gemheartPos).m_82400_(32.0)).stream().filter(runner -> !runner.m_213877_() && (runner.getCurrentPlateauRun() == null || runner.getCurrentPlateauRun() == this) && runner.m_9236_().m_46472_() == this.level.m_46472_() && runner.m_20238_(this.gemheartPos.m_252807_()) < 1024.0).toList();
        HashSet runnersToRemove = Sets.newHashSet();
        for (PlateauRunner runner2 : this.runners) {
            if (validRunners.contains((Object)runner2) || runner2.equals((Object)this.shardbearer)) continue;
            runnersToRemove.add(runner2);
        }
        for (PlateauRunner runner2 : runnersToRemove) {
            this.removeMob(runner2);
        }
        for (PlateauRunner runner2 : validRunners) {
            if (this.runners.contains((Object)runner2)) continue;
            this.addMob(runner2);
        }
    }

    private void findNewExtractor() {
        Vec3 center = this.gemheartPos.m_252807_();
        this.runners.stream().filter(entity -> this.isRunnerValid((PlateauRunner)((Object)entity)) && entity.canBeExtractor()).min((a, b) -> (int)(a.m_20238_(center) - b.m_20238_(center))).ifPresent(this::setExtractor);
        if (this.extractor != null) {
            this.extractorCooldownTicks = 100;
        }
    }

    private boolean isRunnerValid(PlateauRunner pRunner) {
        return pRunner != null && !pRunner.m_21224_();
    }

    private void spawnWave() {
        DifficultyInstance difficulty = this.level.m_6436_(this.gemheartPos);
        int waveSize = 8 + difficulty.m_19048_().m_19028_() - this.runners.size();
        block0: for (int i = 0; i < waveSize; ++i) {
            for (int j = 0; j < 20; ++j) {
                PlateauRunner runner = this.spawnRunner(difficulty, false);
                if (runner == null) continue;
                this.addMob(runner);
                continue block0;
            }
        }
        for (Player player : this.plateauRunEvent.m_8324_()) {
            this.absorbBadOmen(player);
        }
        this.playSound(this.gemheartPos);
    }

    private void spawnShardbearer() {
        for (int j = 0; j < 50; ++j) {
            PlateauRunner shardbearer = this.spawnRunner(this.level.m_6436_(this.gemheartPos), true);
            if (shardbearer == null) continue;
            this.addMob(shardbearer);
            this.setShardbearer(shardbearer);
            break;
        }
    }

    private void removeShardbearer() {
        if (this.isRunnerValid(this.shardbearer)) {
            this.shardbearer.m_21373_();
            this.shardbearer.m_146870_();
        }
    }

    private PlateauRunner spawnRunner(DifficultyInstance pDifficulty, boolean pShardbearer) {
        RandomSource random = this.level.f_46441_;
        BlockPos.MutableBlockPos spawnPos = this.gemheartPos.m_122032_();
        int x = (4 + random.m_188503_(8)) * (random.m_188499_() ? -1 : 1);
        int z = (4 + random.m_188503_(8)) * (random.m_188499_() ? -1 : 1);
        spawnPos.m_142451_(this.gemheartPos.m_123341_() + x);
        spawnPos.m_142443_(this.gemheartPos.m_123343_() + z);
        spawnPos.m_142448_(this.level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)spawnPos).m_123342_());
        if (!this.level.m_143340_((BlockPos)spawnPos) || Math.abs(this.gemheartPos.m_123342_() - spawnPos.m_123342_()) > 12) {
            return null;
        }
        BlockState blockState = this.level.m_8055_((BlockPos)spawnPos);
        if (!NaturalSpawner.m_47056_((BlockGetter)this.level, (BlockPos)spawnPos, (BlockState)blockState, (FluidState)blockState.m_60819_(), (EntityType)((EntityType)StormwardEntities.WARFORM_LISTENER.get()))) {
            return null;
        }
        if (!WarformListener.checkSpawnRules((EntityType<WarformListener>)((EntityType)StormwardEntities.WARFORM_LISTENER.get()), (ServerLevelAccessor)this.level, MobSpawnType.PATROL, (BlockPos)spawnPos, this.level.f_46441_)) {
            return null;
        }
        PlateauRunner runner = (PlateauRunner)((EntityType)StormwardEntities.WARFORM_LISTENER.get()).m_20615_((Level)this.level);
        if (runner != null) {
            runner.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
            if (pShardbearer) {
                runner.setShardbearer();
            }
            runner.m_6518_((ServerLevelAccessor)this.level, pDifficulty, MobSpawnType.EVENT, null, null);
            runner.populateDefaultEquipment(pDifficulty);
            this.level.m_47205_((Entity)runner);
            runner.m_21373_();
        }
        return runner;
    }

    public void playSound(BlockPos pPos) {
        Collection players = this.plateauRunEvent.m_8324_();
        long seed = this.level.f_46441_.m_188505_();
        for (ServerPlayer serverPlayer : this.level.m_6907_()) {
            Vec3 vec3 = serverPlayer.m_20182_();
            Vec3 vec31 = Vec3.m_82512_((Vec3i)pPos);
            double d0 = Math.sqrt((vec31.f_82479_ - vec3.f_82479_) * (vec31.f_82479_ - vec3.f_82479_) + (vec31.f_82481_ - vec3.f_82481_) * (vec31.f_82481_ - vec3.f_82481_));
            double d1 = vec3.f_82479_ + 13.0 / d0 * (vec31.f_82479_ - vec3.f_82479_);
            double d2 = vec3.f_82481_ + 13.0 / d0 * (vec31.f_82481_ - vec3.f_82481_);
            if (!(d0 <= 64.0) && !players.contains(serverPlayer)) continue;
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket((Holder)SoundEvents.f_12355_, SoundSource.NEUTRAL, d1, serverPlayer.m_20186_(), d2, 96.0f, 1.0f, seed));
        }
    }

    public void addMob(PlateauRunner pRunner) {
        this.runners.add(pRunner);
        pRunner.setCurrentPlateauRun(this);
        WarformAi.setGemheart((LivingEntity)pRunner, this.gemheartPos);
    }

    public void removeMob(PlateauRunner pRunner) {
        this.runners.remove((Object)pRunner);
        pRunner.setCurrentPlateauRun(null);
        WarformAi.setGemheart((LivingEntity)pRunner, null);
        if (pRunner.equals((Object)this.extractor)) {
            WarformAi.setExtractor((LivingEntity)pRunner, false);
            this.extractor = null;
        }
        if (pRunner.equals((Object)this.shardbearer)) {
            this.shardbearer = null;
        }
    }

    public void resetMobs() {
        for (PlateauRunner runner : this.runners) {
            runner.setCurrentPlateauRun(null);
            WarformAi.setGemheart((LivingEntity)runner, null);
            WarformAi.setExtractor((LivingEntity)runner, false);
        }
    }

    public int getId() {
        return this.id;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getGemheartPos() {
        return this.gemheartPos;
    }

    public boolean isActive() {
        return this.active;
    }

    public void stop() {
        this.active = false;
        this.plateauRunEvent.m_7706_();
        this.status = PlateauRunStatus.STOPPED;
        this.resetMobs();
    }

    public void victory() {
        this.status = PlateauRunStatus.VICTORY;
        for (UUID uuid : this.participants) {
            LivingEntity entity;
            Entity entity2 = this.level.m_8791_(uuid);
            if (!(entity2 instanceof LivingEntity) || (entity = (LivingEntity)entity2).m_5833_()) continue;
            Gloryspren.tryAddForEntity(entity);
        }
        this.removeShardbearer();
    }

    public void loss() {
        this.status = PlateauRunStatus.LOSS;
        this.level.m_46961_(this.gemheartPos, false);
        this.removeShardbearer();
    }

    public void setExtractor(PlateauRunner pExtractor) {
        if (this.extractor != null && !this.extractor.equals((Object)pExtractor)) {
            WarformAi.setExtractor((LivingEntity)pExtractor, false);
        }
        this.extractor = pExtractor;
        if (pExtractor != null) {
            WarformAi.setExtractor((LivingEntity)pExtractor, true);
        }
    }

    public void setShardbearer(PlateauRunner pShardbearer) {
        this.shardbearer = pShardbearer;
    }

    public void addParticipant(Entity pPlayer) {
        this.participants.add(pPlayer.m_20148_());
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isVictory() {
        return this.status == PlateauRunStatus.VICTORY;
    }

    public boolean isLoss() {
        return this.status == PlateauRunStatus.LOSS;
    }

    public boolean isStopped() {
        return this.status == PlateauRunStatus.STOPPED;
    }

    static enum PlateauRunStatus {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final PlateauRunStatus[] VALUES;

        static PlateauRunStatus getByName(String pName) {
            for (PlateauRunStatus status : VALUES) {
                if (!pName.equalsIgnoreCase(status.name())) continue;
                return status;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = PlateauRunStatus.values();
        }
    }
}

