/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.shardbearer;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.brain.SoldierAi;
import us.amon.stormward.entity.brain.memory.StormwardMemoryModules;
import us.amon.stormward.entity.brain.sensing.StormwardSensors;
import us.amon.stormward.entity.duel.Duel;
import us.amon.stormward.entity.duel.IDuelist;
import us.amon.stormward.entity.patrol.IPatroller;
import us.amon.stormward.entity.shardbearer.Shardbearer;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.armor.ShardplateItem;
import us.amon.stormward.item.weapon.ShardbladeItem;
import us.amon.stormward.sound.StormwardSoundEvents;

public class AlethiSoldier
extends Shardbearer
implements IDuelist,
CrossbowAttackMob,
IPatroller {
    private static final EntityDataAccessor<Boolean> DATA_LIGHTEYES = SynchedEntityData.m_135353_(AlethiSoldier.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(AlethiSoldier.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final ImmutableList<SensorType<? extends Sensor<? super AlethiSoldier>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_26812_, (Object)((SensorType)StormwardSensors.HIGHSTORM_SENSOR.get()), (Object)((SensorType)StormwardSensors.PATROLLER_SENSOR.get()), (Object)((SensorType)StormwardSensors.SOLDIER_SPECIFIC_SENSOR.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26379_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26372_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26373_, MemoryModuleType.f_26374_, MemoryModuleType.f_26377_, MemoryModuleType.f_26334_, MemoryModuleType.f_26335_, (MemoryModuleType)StormwardMemoryModules.NEARBY_ALETHI_SOLDIERS.get(), (MemoryModuleType)StormwardMemoryModules.NEAREST_CHALLENGER.get(), (MemoryModuleType)StormwardMemoryModules.EXPOSED_TO_HIGHSTORM.get(), (MemoryModuleType)StormwardMemoryModules.SHELTER.get(), (MemoryModuleType)StormwardMemoryModules.PATROL_COMPANIONS.get()});
    private Duel duel;
    private BlockPos patrolTarget;
    private boolean leader;

    public AlethiSoldier(EntityType<? extends AlethiSoldier> pEntityType, Level pLevel) {
        super((EntityType<? extends Shardbearer>)pEntityType, pLevel);
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(true);
        PathNavigation pathNavigation = this.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundNavigation = (GroundPathNavigation)pathNavigation;
            groundNavigation.m_26477_(true);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_LIGHTEYES, (Object)false);
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<AlethiSoldier> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> pDynamic) {
        return SoldierAi.makeBrain(this, (Brain<AlethiSoldier>)this.m_5490_().m_22073_(pDynamic));
    }

    @NotNull
    public Brain<AlethiSoldier> m_6274_() {
        return super.m_6274_();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SoldierAi.initMemories(this, pLevel.m_213780_());
        if (pReason == MobSpawnType.SPAWN_EGG && this.f_19796_.m_188503_(5) == 0) {
            this.setLighteyes(true);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void setShardbearer() {
        super.setShardbearer();
        this.setLighteyes(true);
    }

    public void m_238392_(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pOldItem, @NotNull ItemStack pNewItem) {
        super.m_238392_(pSlot, pOldItem, pNewItem);
        if (!this.m_9236_().f_46443_ && (pNewItem.m_41720_() instanceof ShardplateItem || pNewItem.m_41720_() instanceof ShardbladeItem)) {
            this.setLighteyes(true);
        }
    }

    protected void m_213945_(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        ItemStack weapon;
        super.m_213945_(pRandom, pDifficulty);
        if (this.isLighteyes()) {
            this.replaceItemInSlot(new ItemStack((ItemLike)Items.f_42469_), EquipmentSlot.CHEST);
            if (pRandom.m_188503_(3) == 0) {
                this.replaceItemInSlot(new ItemStack((ItemLike)Items.f_42468_), EquipmentSlot.HEAD);
            }
            weapon = new ItemStack((ItemLike)Items.f_42383_);
        } else {
            weapon = new ItemStack((ItemLike)(pRandom.m_188503_(3) == 0 ? Items.f_42717_ : (ItemLike)StormwardItems.IRON_SPEAR.get()));
        }
        this.replaceItemInSlot(weapon, EquipmentSlot.MAINHAND);
    }

    protected void replaceItemInSlot(ItemStack pNewItem, EquipmentSlot pSlot) {
        if (this.m_7808_(pNewItem, this.m_6844_(pSlot))) {
            this.m_8061_(pSlot, pNewItem);
        }
    }

    @Override
    protected void m_8024_() {
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        SoldierAi.updateActivity(this);
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AlethiSoldier.createShardbearerAttributes().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    public static boolean checkSpawnRules(EntityType<AlethiSoldier> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AlethiSoldier.checkAntagonistSpawnRules(type, (LevelAccessor)level, spawnType, pos, random);
    }

    public boolean canStartAttacking() {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        boolean result = super.m_6469_(pSource, pAmount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (result && pSource.m_7639_() instanceof LivingEntity) {
            SoldierAi.wasHurtBy(this, (LivingEntity)pSource.m_7639_());
        }
        return result;
    }

    protected SoundEvent m_7515_() {
        return this.m_9236_().f_46443_ ? null : (SoundEvent)SoldierAi.getSoundForCurrentActivity(this).orElse(null);
    }

    public int m_8100_() {
        return this.m_9236_().f_46443_ ? super.m_8100_() : SoldierAi.getSoundIntervalForCurrentActivity(this).orElse(super.m_8100_()).intValue();
    }

    @Override
    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.ALETHI_SOLDIER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.ALETHI_SOLDIER_DEATH.get();
    }

    public void playSoundEvent(SoundEvent pSoundEvent) {
        this.m_5496_(pSoundEvent, this.m_6121_(), this.m_6100_());
    }

    @Override
    public boolean m_5886_(@NotNull ProjectileWeaponItem pProjectileWeapon) {
        return true;
    }

    @Override
    public void m_6504_(@NotNull LivingEntity pTarget, float pVelocity) {
        if (this.m_21093_(stack -> stack.m_41720_() instanceof CrossbowItem)) {
            this.m_32336_((LivingEntity)this, 1.6f);
        } else {
            super.m_6504_(pTarget, pVelocity);
        }
    }

    public void m_5811_(@NotNull LivingEntity pTarget, @NotNull ItemStack pCrossbowStack, @NotNull Projectile pProjectile, float pProjectileAngle) {
        this.m_32322_((LivingEntity)this, pTarget, pProjectile, pProjectileAngle, 1.6f);
    }

    public LivingEntity m_5448_() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public SoldierArmPose getArmPose() {
        if (this.m_5912_() && SoldierAi.hasBow((LivingEntity)this)) {
            return SoldierArmPose.BOW;
        }
        if (this.isChargingCrossbow()) {
            return SoldierArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_5912_() && SoldierAi.hasCrossbow((LivingEntity)this)) {
            return SoldierArmPose.CROSSBOW_HOLD;
        }
        if (SoldierAi.hasTwoHandedWeapon((LivingEntity)this)) {
            return SoldierArmPose.TWO_HANDED;
        }
        return SoldierArmPose.DEFAULT;
    }

    public void setLighteyes(boolean pLighteyes) {
        this.f_19804_.m_135381_(DATA_LIGHTEYES, (Object)pLighteyes);
    }

    public boolean isLighteyes() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LIGHTEYES);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Lighteyes", this.isLighteyes());
        this.addDuelistSaveData(pCompound);
        this.addPatrollerSaveData(pCompound);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setLighteyes(pCompound.m_128471_("Lighteyes"));
        this.readDuelistSaveData(this.m_9236_(), pCompound);
        this.readPatrollerSaveData(pCompound);
    }

    @Override
    @Nullable
    public Duel getDuel() {
        return this.duel;
    }

    @Override
    public void setDuel(Duel pDuel) {
        this.duel = pDuel;
    }

    @Override
    @Nullable
    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    @Override
    public void setPatrolTarget(@Nullable BlockPos pTarget) {
        this.patrolTarget = pTarget;
    }

    @Override
    public void setPatrolLeader(boolean pLeader) {
        this.leader = pLeader;
        this.setLighteyes(pLeader);
    }

    @Override
    public boolean isPatrolLeader() {
        return this.leader;
    }

    @Override
    public boolean canJoinPatrol() {
        return this.getDuel() == null && IPatroller.super.canJoinPatrol();
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        Entity entity;
        if (!this.m_9236_().f_46443_ && this.isPatrolLeader() && this.getDuel() == null && (entity = pDamageSource.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            MobEffectInstance effect = player.m_21124_(MobEffects.f_19594_);
            int i = 1;
            if (effect != null) {
                i += effect.m_19564_();
                player.m_6234_(MobEffects.f_19594_);
            } else {
                --i;
            }
            i = Mth.m_14045_((int)i, (int)0, (int)4);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19594_, 120000, i, false, false, true));
        }
        super.m_6667_(pDamageSource);
    }

    public static enum SoldierArmPose {
        BOW,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        TWO_HANDED,
        DEFAULT;

    }
}

