/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.shardbearer;

import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.attribute.StormwardAttributes;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.shardstorage.ShardStorage;
import us.amon.stormward.capability.shardstorage.ShardStorageHelper;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.entity.shardbearer.Antagonist;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.armor.ShardplateItem;
import us.amon.stormward.item.armortrim.StormwardTrimMaterials;
import us.amon.stormward.item.weapon.GrandbowItem;
import us.amon.stormward.item.weapon.ShardbladeItem;
import us.amon.stormward.item.weapon.StormlightStorageWeaponItem;
import us.amon.stormward.item.weapon.TwoHandedWeaponItem;
import us.amon.stormward.sound.StormwardSoundEvents;

public class Shardbearer
extends Antagonist
implements RangedAttackMob {
    private static final UUID MAX_HEALTH_MODIFIER_UUID = UUID.fromString("2a7f6089-854e-4c9e-a866-aae54062c413");
    private static final AttributeModifier MAX_HEALTH_MODIFIER = new AttributeModifier(MAX_HEALTH_MODIFIER_UUID, "Shardbearer modifier", 2.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final double DEFAULT_ATTACK_REACH = 0.83;
    private static final float SHARD_DROP_CHANCE = 1.0f;
    private final ShardStorage shards = new ShardStorage();
    private final LazyOptional<ShardStorage> optional = LazyOptional.of(() -> this.shards);
    private ServerBossEvent bossEvent;
    private boolean shardbearer;

    protected Shardbearer(EntityType<? extends Shardbearer> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createShardbearerAttributes() {
        return Shardbearer.createAntagonistAttributes().m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.83).m_22266_((Attribute)StormwardAttributes.JUMP_HEIGHT_ADDITION.get());
    }

    public void setShardbearer() {
        this.shardbearer = true;
        this.m_21530_();
        this.bossEvent = new ServerBossEvent((Component)this.m_5446_().m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"entity.stormward.shardbearer")), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null && !maxHealth.m_22109_(MAX_HEALTH_MODIFIER)) {
            maxHealth.m_22125_(MAX_HEALTH_MODIFIER);
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = 20;
    }

    public boolean isShardbearer() {
        return this.shardbearer;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isShardbearer() && this.bossEvent != null) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
        ShardStorageHelper.tickShardStorage((LivingEntity)this);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.isShardbearer()) {
            pCompound.m_128379_("Shardbearer", true);
        }
        pCompound.m_128365_(StormwardCapabilities.SHARD_STORAGE_KEY.m_135815_(), (Tag)this.shards.serializeNBT());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Shardbearer")) {
            this.setShardbearer();
        }
        this.shards.deserializeNBT(pCompound.m_128469_(StormwardCapabilities.SHARD_STORAGE_KEY.m_135815_()));
    }

    public void m_6457_(@NotNull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (this.isShardbearer() && this.bossEvent != null) {
            this.bossEvent.m_6543_(pPlayer);
        }
    }

    public void m_6452_(@NotNull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        if (this.isShardbearer() && this.bossEvent != null) {
            this.bossEvent.m_6539_(pPlayer);
        }
    }

    @NotNull
    protected AABB m_292684_() {
        AABB aabb;
        Entity entity = this.m_20202_();
        if (entity != null) {
            AABB aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        double reach = 0.83;
        if (this.m_21204_().m_22171_((Attribute)ForgeMod.ENTITY_REACH.get())) {
            reach = this.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        }
        return aabb.m_82377_(reach, 0.0, reach);
    }

    public void m_8119_() {
        super.m_8119_();
        StormlightStorageHelper.updateEntityStormlight((LivingEntity)this);
    }

    protected void m_6472_(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        super.m_6472_(pDamageSource, pDamageAmount);
        ShardplateItem.hurtShardplate((LivingEntity)this, pDamageSource, pDamageAmount);
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        ItemStack stack = this.m_21205_();
        if (stack.m_41720_() instanceof StormlightStorageWeaponItem) {
            stack.m_41622_(1, (LivingEntity)this, shardbearer -> shardbearer.m_21166_(EquipmentSlot.MAINHAND));
        }
        return super.m_7327_(pEntity);
    }

    protected boolean m_7808_(@NotNull ItemStack pCandidate, @NotNull ItemStack pExisting) {
        if (pCandidate.m_41720_() instanceof ShardplateItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)pExisting) || StormlightStorageHelper.isDun((ICapabilityProvider)pCandidate)) {
                return false;
            }
            return !(pExisting.m_41720_() instanceof ShardplateItem);
        }
        if (pCandidate.m_41720_() instanceof ArmorItem && pExisting.m_41720_() instanceof ShardplateItem) {
            return false;
        }
        if (this.m_5886_((ProjectileWeaponItem)StormwardItems.GRANDBOW.get())) {
            if (pCandidate.m_150930_((Item)StormwardItems.GRANDBOW.get())) {
                return !StormlightStorageHelper.isDun((ICapabilityProvider)pCandidate) && !(pExisting.m_41720_() instanceof ShardbladeItem);
            }
            if (pExisting.m_150930_((Item)StormwardItems.GRANDBOW.get())) {
                return pCandidate.m_41720_() instanceof ShardbladeItem;
            }
        }
        if (pExisting.m_41720_() instanceof TwoHandedWeaponItem || pCandidate.m_41720_() instanceof TwoHandedWeaponItem) {
            float candidateDamage;
            float existingDamage = this.getItemDamage(pExisting);
            if (existingDamage != (candidateDamage = this.getItemDamage(pCandidate))) {
                return candidateDamage > existingDamage;
            }
            return this.m_21477_(pCandidate, pExisting);
        }
        return super.m_7808_(pCandidate, pExisting);
    }

    private float getItemDamage(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            return sword.m_43299_();
        }
        item = stack.m_41720_();
        if (item instanceof TwoHandedWeaponItem) {
            TwoHandedWeaponItem twoHandedWeapon = (TwoHandedWeaponItem)item;
            return (float)twoHandedWeapon.getDamage();
        }
        return 0.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.SPAWN_EGG && this.f_19796_.m_188503_(10) == 0) {
            this.setShardbearer();
        }
        if (pReason != MobSpawnType.EVENT) {
            this.populateDefaultEquipment(pDifficulty);
        }
        this.m_213946_(this.f_19796_, pDifficulty);
        this.m_21553_(true);
        return pSpawnData;
    }

    public final void populateDefaultEquipment(@NotNull DifficultyInstance pDifficulty) {
        if (this.isShardbearer()) {
            this.populateShardbearerEquipmentSlots(this.f_19796_, pDifficulty);
        } else {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
    }

    protected void populateShardbearerEquipmentSlots(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        this.populateShardbearerEquipmentSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Shardbearer.getShardblade(pRandom.m_188503_(9))));
        int shardplateVariant = pRandom.m_188503_(9);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!slot.m_254934_()) continue;
            this.populateShardbearerEquipmentSlot(slot, new ItemStack((ItemLike)Shardbearer.getShardplateForSlot(slot, shardplateVariant)));
        }
        Shardbearer.trimArmorForEntity((LivingEntity)this);
    }

    public static void trimArmorForEntity(LivingEntity pEntity) {
        ResourceKey<TrimPattern> trimPattern = Shardbearer.getRandomTrimPattern(pEntity.m_217043_());
        if (trimPattern != null) {
            ResourceKey<TrimMaterial> trimMaterial = Shardbearer.getRandomTrimMaterial(pEntity.m_217043_());
            RegistryAccess registryAccess = pEntity.m_9236_().m_9598_();
            Registry patterns = registryAccess.m_175515_(Registries.f_266063_);
            Registry materials = registryAccess.m_175515_(Registries.f_266076_);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack;
                if (!slot.m_254934_() || (stack = pEntity.m_6844_(slot)).m_41619_()) continue;
                ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)stack, (ArmorTrim)new ArmorTrim(materials.m_263177_((Object)((TrimMaterial)materials.m_123013_(trimMaterial))), patterns.m_263177_((Object)((TrimPattern)patterns.m_123013_(trimPattern)))));
            }
        }
    }

    protected void populateShardbearerEquipmentSlot(EquipmentSlot slot, ItemStack stack) {
        StormlightStorageHelper.setFull((ICapabilityProvider)stack);
        this.m_8061_(slot, stack);
        this.m_21409_(slot, 1.0f);
    }

    protected static Item getShardblade(int pChance) {
        return switch (pChance) {
            case 8 -> (Item)StormwardItems.HIGHSPREN_SHARDBLADE.get();
            case 7 -> (Item)StormwardItems.PEAKSPREN_SHARDBLADE.get();
            case 6 -> (Item)StormwardItems.CRYPTIC_SHARDBLADE.get();
            case 5 -> (Item)StormwardItems.ASHSPREN_SHARDBLADE.get();
            case 4 -> (Item)StormwardItems.LIGHTSPREN_SHARDBLADE.get();
            case 3 -> (Item)StormwardItems.HONORSPREN_SHARDBLADE.get();
            case 2 -> (Item)StormwardItems.INKSPREN_SHARDBLADE.get();
            case 1 -> (Item)StormwardItems.CULTIVATIONSPREN_SHARDBLADE.get();
            default -> (Item)StormwardItems.MISTSPREN_SHARDBLADE.get();
        };
    }

    protected static Item getShardplateForSlot(EquipmentSlot pSlot, int pChance) {
        return switch (pSlot) {
            case EquipmentSlot.HEAD -> {
                switch (pChance) {
                    case 8: {
                        yield (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_HELMET.get();
                    }
                    case 7: {
                        yield (Item)StormwardItems.ROCKSPREN_SHARDPLATE_HELMET.get();
                    }
                    case 6: {
                        yield (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_HELMET.get();
                    }
                    case 5: {
                        yield (Item)StormwardItems.FLAMESPREN_SHARDPLATE_HELMET.get();
                    }
                    case 4: {
                        yield (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_HELMET.get();
                    }
                    case 3: {
                        yield (Item)StormwardItems.WINDSPREN_SHARDPLATE_HELMET.get();
                    }
                    case 2: {
                        yield (Item)StormwardItems.LOGICSPREN_SHARDPLATE_HELMET.get();
                    }
                    case 1: {
                        yield (Item)StormwardItems.LIFESPREN_SHARDPLATE_HELMET.get();
                    }
                }
                yield (Item)StormwardItems.RAINSPREN_SHARDPLATE_HELMET.get();
            }
            case EquipmentSlot.CHEST -> {
                switch (pChance) {
                    case 8: {
                        yield (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                    case 7: {
                        yield (Item)StormwardItems.ROCKSPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                    case 6: {
                        yield (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                    case 5: {
                        yield (Item)StormwardItems.FLAMESPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                    case 4: {
                        yield (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                    case 3: {
                        yield (Item)StormwardItems.WINDSPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                    case 2: {
                        yield (Item)StormwardItems.LOGICSPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                    case 1: {
                        yield (Item)StormwardItems.LIFESPREN_SHARDPLATE_CHESTPLATE.get();
                    }
                }
                yield (Item)StormwardItems.RAINSPREN_SHARDPLATE_CHESTPLATE.get();
            }
            case EquipmentSlot.LEGS -> {
                switch (pChance) {
                    case 8: {
                        yield (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_LEGGINGS.get();
                    }
                    case 7: {
                        yield (Item)StormwardItems.ROCKSPREN_SHARDPLATE_LEGGINGS.get();
                    }
                    case 6: {
                        yield (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_LEGGINGS.get();
                    }
                    case 5: {
                        yield (Item)StormwardItems.FLAMESPREN_SHARDPLATE_LEGGINGS.get();
                    }
                    case 4: {
                        yield (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_LEGGINGS.get();
                    }
                    case 3: {
                        yield (Item)StormwardItems.WINDSPREN_SHARDPLATE_LEGGINGS.get();
                    }
                    case 2: {
                        yield (Item)StormwardItems.LOGICSPREN_SHARDPLATE_LEGGINGS.get();
                    }
                    case 1: {
                        yield (Item)StormwardItems.LIFESPREN_SHARDPLATE_LEGGINGS.get();
                    }
                }
                yield (Item)StormwardItems.RAINSPREN_SHARDPLATE_LEGGINGS.get();
            }
            case EquipmentSlot.FEET -> {
                switch (pChance) {
                    case 8: {
                        yield (Item)StormwardItems.GRAVITATIONSPREN_SHARDPLATE_BOOTS.get();
                    }
                    case 7: {
                        yield (Item)StormwardItems.ROCKSPREN_SHARDPLATE_BOOTS.get();
                    }
                    case 6: {
                        yield (Item)StormwardItems.CREATIONSPREN_SHARDPLATE_BOOTS.get();
                    }
                    case 5: {
                        yield (Item)StormwardItems.FLAMESPREN_SHARDPLATE_BOOTS.get();
                    }
                    case 4: {
                        yield (Item)StormwardItems.PASSIONSPREN_SHARDPLATE_BOOTS.get();
                    }
                    case 3: {
                        yield (Item)StormwardItems.WINDSPREN_SHARDPLATE_BOOTS.get();
                    }
                    case 2: {
                        yield (Item)StormwardItems.LOGICSPREN_SHARDPLATE_BOOTS.get();
                    }
                    case 1: {
                        yield (Item)StormwardItems.LIFESPREN_SHARDPLATE_BOOTS.get();
                    }
                }
                yield (Item)StormwardItems.RAINSPREN_SHARDPLATE_BOOTS.get();
            }
            default -> Shardbearer.getShardblade(pChance);
        };
    }

    protected static ResourceKey<TrimPattern> getRandomTrimPattern(RandomSource pRandom) {
        return switch (pRandom.m_188503_(5)) {
            case 4 -> TrimPatterns.f_276615_;
            case 3 -> TrimPatterns.f_276435_;
            case 2 -> TrimPatterns.f_276604_;
            case 1 -> TrimPatterns.f_265901_;
            default -> null;
        };
    }

    @NotNull
    protected static ResourceKey<TrimMaterial> getRandomTrimMaterial(RandomSource pRandom) {
        return switch (pRandom.m_188503_(14)) {
            case 0 -> StormwardTrimMaterials.SMOKESTONE;
            case 1 -> StormwardTrimMaterials.TOPAZ;
            case 2 -> StormwardTrimMaterials.GARNET;
            case 3 -> StormwardTrimMaterials.RUBY;
            case 4 -> StormwardTrimMaterials.SAPPHIRE;
            case 5 -> StormwardTrimMaterials.ZIRCON;
            case 6 -> TrimMaterials.f_266000_;
            case 7 -> TrimMaterials.f_265870_;
            case 8 -> TrimMaterials.f_265969_;
            case 9 -> TrimMaterials.f_265937_;
            case 10 -> TrimMaterials.f_266071_;
            case 11 -> TrimMaterials.f_266027_;
            case 12 -> TrimMaterials.f_265981_;
            default -> TrimMaterials.f_265872_;
        };
    }

    public boolean m_5886_(ProjectileWeaponItem pProjectileWeapon) {
        return pProjectileWeapon.equals(StormwardItems.GRANDBOW.get());
    }

    public void m_6504_(@NotNull LivingEntity pTarget, float pVelocity) {
        if (this.m_21055_((Item)StormwardItems.GRANDBOW.get())) {
            ItemStack bowStack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item == StormwardItems.GRANDBOW.get()));
            ItemStack arrowStack = this.m_6298_(bowStack);
            AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)pVelocity);
            GrandbowItem.setShotFromGrandbow(arrow, 1.0f);
            this.shootArrow(pTarget, arrow, 3.9f, 0.1, (SoundEvent)StormwardSoundEvents.GRANDBOW.get());
            bowStack.m_41622_(1, (LivingEntity)this, shardbearer -> shardbearer.m_21166_(EquipmentSlot.MAINHAND));
        } else {
            ItemStack stack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
            AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)stack, (float)pVelocity);
            if (this.m_21205_().m_41720_() instanceof BowItem) {
                arrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(arrow);
            }
            this.shootArrow(pTarget, arrow, 1.6f, 0.2, SoundEvents.f_11687_);
        }
    }

    private void shootArrow(LivingEntity pTarget, AbstractArrow pArrow, float pVelocity, double pCompensation, SoundEvent pSound) {
        double offsetX = pTarget.m_20185_() - this.m_20185_();
        double offsetY = pTarget.m_20227_(0.3333333333333333) - pArrow.m_20186_();
        double offsetZ = pTarget.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
        pArrow.m_6686_(offsetX, offsetY + distance * pCompensation, offsetZ, pVelocity, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(pSound, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)pArrow);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == StormwardCapabilities.SHARD_STORAGE) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }
}

