/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.shardbearer;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.brain.WarformAi;
import us.amon.stormward.entity.brain.memory.StormwardMemoryModules;
import us.amon.stormward.entity.brain.sensing.StormwardSensors;
import us.amon.stormward.entity.navigation.JumpMoveControl;
import us.amon.stormward.entity.navigation.JumpPathNavigation;
import us.amon.stormward.entity.plateaurun.PlateauRunner;
import us.amon.stormward.entity.shardbearer.WarformListenerVariant;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.sound.StormwardSoundEvents;

public class WarformListener
extends PlateauRunner {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(WarformListener.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final ImmutableList<SensorType<? extends Sensor<? super WarformListener>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_26812_, (Object)((SensorType)StormwardSensors.HIGHSTORM_SENSOR.get()), (Object)((SensorType)StormwardSensors.WARFORM_SPECIFIC_SENSOR.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26379_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26372_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26373_, MemoryModuleType.f_26374_, MemoryModuleType.f_26377_, MemoryModuleType.f_26334_, MemoryModuleType.f_26335_, (MemoryModuleType)StormwardMemoryModules.NEARBY_WARFORM_LISTENERS.get(), (MemoryModuleType)StormwardMemoryModules.NEAREST_TARGETABLE_PLAYER_WEARING_CARAPACE.get(), (MemoryModuleType)StormwardMemoryModules.GEMHEART.get(), (MemoryModuleType)StormwardMemoryModules.EXTRACTOR.get(), (MemoryModuleType)StormwardMemoryModules.EXTRACTING_GEMHEART.get(), (MemoryModuleType)StormwardMemoryModules.CELEBRATING.get(), (MemoryModuleType)StormwardMemoryModules.EXPOSED_TO_HIGHSTORM.get(), (MemoryModuleType)StormwardMemoryModules.SHELTER.get()});

    public WarformListener(EntityType<? extends WarformListener> pEntityType, Level pLevel) {
        super((EntityType<? extends PlateauRunner>)pEntityType, pLevel);
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(true);
        PathNavigation pathNavigation = this.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundNavigation = (GroundPathNavigation)pathNavigation;
            groundNavigation.m_26477_(true);
        }
        this.f_21342_ = new JumpMoveControl((Mob)this);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)WarformListenerVariant.BLACK.getId());
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<WarformListener> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> pDynamic) {
        return WarformAi.makeBrain(this, (Brain<WarformListener>)this.m_5490_().m_22073_(pDynamic));
    }

    @NotNull
    public Brain<WarformListener> m_6274_() {
        return super.m_6274_();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        WarformAi.initMemories(this, pLevel.m_213780_());
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setVariant(this.f_19796_.m_188503_(WarformListenerVariant.values().length));
        return pSpawnData;
    }

    protected void m_213945_(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        if (pRandom.m_188503_(3) == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        } else {
            switch (pRandom.m_188503_(3)) {
                case 2: {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
                    break;
                }
                case 1: {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
                    break;
                }
                default: {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42420_));
                }
            }
        }
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new JumpPathNavigation((Mob)this, level);
    }

    @Override
    protected void m_8024_() {
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        WarformAi.updateActivity(this);
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WarformListener.createShardbearerAttributes().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public static boolean checkSpawnRules(EntityType<WarformListener> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WarformListener.checkAntagonistSpawnRules(type, (LevelAccessor)level, spawnType, pos, random) && level.m_45527_(pos);
    }

    public boolean canStartAttacking() {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        boolean result = super.m_6469_(pSource, pAmount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (result && pSource.m_7639_() instanceof LivingEntity) {
            WarformAi.wasHurtBy(this, (LivingEntity)pSource.m_7639_());
        }
        return result;
    }

    protected SoundEvent m_7515_() {
        return this.m_9236_().f_46443_ ? null : (SoundEvent)WarformAi.getSoundForCurrentActivity(this).orElse(null);
    }

    public int m_8100_() {
        return this.m_9236_().f_46443_ ? super.m_8100_() : WarformAi.getSoundIntervalForCurrentActivity(this).orElse(super.m_8100_()).intValue();
    }

    @Override
    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.WARFORM_LISTENER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.WARFORM_LISTENER_DEATH.get();
    }

    public void playSoundEvent(SoundEvent pSoundEvent) {
        this.m_5496_(pSoundEvent, this.m_6121_(), this.m_6100_());
    }

    @Override
    public boolean m_5886_(@NotNull ProjectileWeaponItem pProjectileWeapon) {
        return pProjectileWeapon instanceof BowItem || super.m_5886_(pProjectileWeapon);
    }

    public WarformArmPose getArmPose() {
        if (this.isExtractingGemheart()) {
            return WarformArmPose.EXTRACTING_GEMHEART;
        }
        if (this.m_5912_() && WarformAi.hasBow((LivingEntity)this)) {
            return WarformArmPose.BOW;
        }
        if (WarformAi.hasTwoHandedWeapon((LivingEntity)this)) {
            return WarformArmPose.TWO_HANDED;
        }
        if (this.isCelebrating()) {
            return WarformArmPose.CELEBRATING;
        }
        return WarformArmPose.DEFAULT;
    }

    public void setVariant(int pVariant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)pVariant);
    }

    public void setVariant(@NotNull WarformListenerVariant pVariant) {
        this.setVariant(pVariant.getId());
    }

    @NotNull
    public WarformListenerVariant getVariant() {
        return WarformListenerVariant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getVariant().getId());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setVariant(pCompound.m_128451_("Variant"));
    }

    public boolean m_7243_(@NotNull ItemStack pStack) {
        return this.m_7252_(pStack) && !pStack.m_150930_((Item)StormwardItems.CARAPACE_HELMET.get()) && !pStack.m_150930_((Item)StormwardItems.CARAPACE_CHESTPLATE.get()) && !pStack.m_150930_((Item)StormwardItems.CARAPACE_LEGGINGS.get()) && !pStack.m_150930_((Item)StormwardItems.CARAPACE_BOOTS.get());
    }

    public static enum WarformArmPose {
        BOW,
        TWO_HANDED,
        EXTRACTING_GEMHEART,
        CELEBRATING,
        DEFAULT;

    }
}

