/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.spren.overworld;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.spren.overworld.SprenOverworld;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.tag.StormwardEntityTypeTags;

public class Fearspren
extends SprenOverworld {
    public static final int SPAWN_CHANCE = 120;

    public Fearspren(Level pLevel) {
        this((EntityType)StormwardEntities.FEARSPREN.get(), pLevel);
    }

    public Fearspren(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void finalizeSpawn() {
        float range = this.getOffsetRange();
        this.m_146884_(this.m_20182_().m_82520_((double)((this.f_19796_.m_188501_() - 0.5f) * range), -0.75, (double)((this.f_19796_.m_188501_() - 0.5f) * range)));
        this.updateOffset();
        this.playSpawnEffects();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_213877_() && this.f_19796_.m_188503_(8) == 0) {
            double x = this.m_20185_();
            double y = this.m_20186_() + 0.125;
            double z = this.m_20189_();
            this.m_9236_().m_7106_((ParticleOptions)StormwardParticles.FEARSPREN.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void updateRotation() {
    }

    @Override
    protected int getOffsetChance() {
        return 40;
    }

    @Override
    protected float getOffsetRange() {
        return 0.5f;
    }

    @Override
    protected double getMoveSpeed() {
        return 0.01;
    }

    @Override
    protected double getMaxMoveSpeed() {
        return 0.07;
    }

    @Override
    protected boolean isBlockValidOrigin(BlockPos pPos) {
        BlockPos belowPos = pPos.m_7495_();
        return Fearspren.isBlockEmpty((LevelAccessor)this.m_9236_(), pPos) && this.m_9236_().m_8055_(belowPos).m_60838_((BlockGetter)this.m_9236_(), belowPos);
    }

    public static void tryAddForEntityGoal(LivingEntity pEntity) {
        Fearspren.tryAddForEntity(pEntity, 60);
    }

    public static void tryAddForEntity(LivingEntity pEntity) {
        Fearspren.tryAddForEntity(pEntity, 120);
    }

    protected static void tryAddForEntity(LivingEntity pEntity, int pSpawnChance) {
        Level level = pEntity.m_9236_();
        if (!level.m_5776_() && !pEntity.m_6095_().m_204039_(StormwardEntityTypeTags.NO_EMOTION) && Fearspren.spawnChance(level.f_46441_, pSpawnChance)) {
            SprenOverworld.addForEntity((EntityType)StormwardEntities.FEARSPREN.get(), pEntity);
        }
    }

    public static void tryAddForEntityInRaid(LivingEntity pEntity) {
        BlockPos pos;
        Raid raid;
        Level level = pEntity.m_9236_();
        if (!level.m_5776_() && !pEntity.m_6095_().m_204039_(StormwardEntityTypeTags.NO_EMOTION) && Fearspren.spawnChance(level.f_46441_, 120) && (raid = ((ServerLevel)level).m_8832_(pos = pEntity.m_20183_())) != null && raid.m_37782_() && !raid.m_37706_()) {
            SprenOverworld.addForEntity((EntityType)StormwardEntities.FEARSPREN.get(), pEntity);
        }
    }
}

