/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.spren.overworld;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import us.amon.stormward.Config;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.spren.overworld.Coldspren;
import us.amon.stormward.entity.spren.overworld.Flamespren;
import us.amon.stormward.entity.spren.overworld.Gravitationspren;
import us.amon.stormward.entity.spren.overworld.Lifespren;
import us.amon.stormward.entity.spren.overworld.Logicspren;
import us.amon.stormward.entity.spren.overworld.Rainspren;
import us.amon.stormward.entity.spren.overworld.Riverspren;
import us.amon.stormward.entity.spren.overworld.Rockspren;
import us.amon.stormward.entity.spren.overworld.SprenOverworld;
import us.amon.stormward.entity.spren.overworld.Starspren;
import us.amon.stormward.entity.spren.overworld.Windspren;
import us.amon.stormward.weather.Highstorm;

public class NaturalSprenSpawner {
    public static SpawnState createState(Iterable<Entity> pEntities) {
        Object2IntOpenHashMap sprenPerChunk = new Object2IntOpenHashMap();
        for (Entity entity : pEntities) {
            if (!(entity instanceof SprenOverworld)) continue;
            sprenPerChunk.addTo((Object)entity.m_146902_(), 1);
        }
        return new SpawnState((Object2IntMap<ChunkPos>)sprenPerChunk);
    }

    public static void spawnForChunk(ServerLevel pLevel, LevelChunk pChunk, SpawnState pSpawnState, boolean pSpawnFriendlies) {
        if (pSpawnFriendlies && pSpawnState.canSpawnForChunk(pChunk)) {
            for (int i = 0; i < (Integer)Config.SPREN_SPAWN_ATTEMPTS.get(); ++i) {
                BlockPos pos = NaturalSprenSpawner.getRandomPosWithin((Level)pLevel, pChunk);
                if (pos.m_123342_() < pLevel.m_141937_() + 1) continue;
                NaturalSprenSpawner.spawnForPosition(pLevel, pChunk, pos);
            }
        }
    }

    private static BlockPos getRandomPosWithin(Level pLevel, LevelChunk pChunk) {
        ChunkPos chunkpos = pChunk.m_7697_();
        int i = chunkpos.m_45604_() + pLevel.f_46441_.m_188503_(16);
        int j = chunkpos.m_45605_() + pLevel.f_46441_.m_188503_(16);
        int k = pChunk.m_5885_(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
        int l = Mth.m_216287_((RandomSource)pLevel.f_46441_, (int)pLevel.m_141937_(), (int)k);
        return new BlockPos(i, l, j);
    }

    private static boolean spawnForPosition(ServerLevel pLevel, LevelChunk pChunk, BlockPos pPos) {
        boolean exposed = Highstorm.isBlockExposed((LevelAccessor)pLevel, pPos);
        return NaturalSprenSpawner.trySpawnLogicspren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnFlamespren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnLifespren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnColdspren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnRockspren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnGravitationspren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnRainspren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnRiverspren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnStarspren(pLevel, pPos, exposed) || NaturalSprenSpawner.trySpawnWindspren(pLevel, pPos, exposed);
    }

    private static boolean trySpawnLogicspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (Logicspren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 0)) {
            SprenOverworld.addAtBlock((EntityType)StormwardEntities.LOGICSPREN.get(), (Level)pLevel, pPos);
            return true;
        }
        return false;
    }

    private static boolean trySpawnFlamespren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (Flamespren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 1)) {
            SprenOverworld.addClusterAtBlock((EntityType<? extends SprenOverworld>)((EntityType)StormwardEntities.FLAMESPREN.get()), (Level)pLevel, pPos, 2);
            return true;
        }
        return false;
    }

    private static boolean trySpawnLifespren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (Lifespren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 10)) {
            SprenOverworld.addAtBlock((EntityType)StormwardEntities.LIFESPREN.get(), (Level)pLevel, pPos);
            return true;
        }
        return false;
    }

    private static boolean trySpawnColdspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (Coldspren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 15)) {
            SprenOverworld.addAtBlock((EntityType)StormwardEntities.COLDSPREN.get(), (Level)pLevel, pPos);
            return true;
        }
        return false;
    }

    private static boolean trySpawnRockspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (!pExposed && Rockspren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 10)) {
            SprenOverworld.addAtBlock((EntityType)StormwardEntities.ROCKSPREN.get(), (Level)pLevel, pPos);
            return true;
        }
        return false;
    }

    private static boolean trySpawnGravitationspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (Gravitationspren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 20)) {
            SprenOverworld.addAtBlock((EntityType)StormwardEntities.GRAVITATIONSPREN.get(), (Level)pLevel, pPos);
            return true;
        }
        return false;
    }

    private static boolean trySpawnRainspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (pExposed && pLevel.m_46758_(pPos) && Rainspren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 20)) {
            SprenOverworld.addClusterAtBlock((EntityType<? extends SprenOverworld>)((EntityType)StormwardEntities.RAINSPREN.get()), (Level)pLevel, pPos, 2);
            return true;
        }
        return false;
    }

    private static boolean trySpawnRiverspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        if (Riverspren.checkSpawnRules((ServerLevelAccessor)pLevel, pPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 100)) {
            SprenOverworld.addAtBlock((EntityType)StormwardEntities.RIVERSPREN.get(), (Level)pLevel, pPos);
            return true;
        }
        return false;
    }

    private static boolean trySpawnStarspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        BlockPos skyPos = pPos.m_6630_(8 + pLevel.f_46441_.m_188503_(10));
        if (pExposed && pLevel.m_46462_() && Starspren.checkSpawnRules((ServerLevelAccessor)pLevel, skyPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 120)) {
            Starspren.addAtBlock((EntityType)StormwardEntities.STARSPREN.get(), (Level)pLevel, skyPos);
            return true;
        }
        return false;
    }

    private static boolean trySpawnWindspren(ServerLevel pLevel, BlockPos pPos, boolean pExposed) {
        BlockPos skyPos = pPos.m_6630_(2 + pLevel.f_46441_.m_188503_(10));
        if (pExposed && Windspren.checkSpawnRules((ServerLevelAccessor)pLevel, skyPos) && SprenOverworld.spawnChance(pLevel.f_46441_, 60)) {
            SprenOverworld.addClusterAtBlock((EntityType<? extends SprenOverworld>)((EntityType)StormwardEntities.WINDSPREN.get()), (Level)pLevel, skyPos, 3);
            return true;
        }
        return false;
    }

    public static class SpawnState {
        private final Object2IntMap<ChunkPos> sprenPerChunk;

        SpawnState(Object2IntMap<ChunkPos> pSprenPerChunk) {
            this.sprenPerChunk = pSprenPerChunk;
        }

        public boolean canSpawnForChunk(LevelChunk pChunk) {
            return this.sprenPerChunk.getInt((Object)pChunk.m_7697_()) < (Integer)Config.MAX_SPREN_PER_CHUNK.get();
        }
    }
}

