/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.spren.overworld;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import us.amon.stormward.block.stormlightstorage.StormlightTransferBlock;
import us.amon.stormward.blockentity.stormlightstorage.TransferenceStandEntity;
import us.amon.stormward.item.CagedGemItem;

public class SprenOverworld
extends Entity {
    private static final int DISAPPEAR_CHANCE = 600;
    private static final int MIN_LIFETIME = 150;
    private static final double DEFAULT_POS_ERROR = 0.25;
    private static final double DEFAULT_MOVE_SPEED = 0.02;
    private static final double DEFAULT_MAX_MOVE_SPEED = 0.15;
    private static final int DEFAULT_OFFSET_CHANCE = 20;
    private static final float DEFAULT_OFFSET_RANGE = 1.0f;
    private static final double MAX_Y_CHANGE_PER_TICK = 0.2;
    private static final float SPREN_PULL_RADIUS = 1.5f;
    private static final float SPREN_PULL_SPEED = 0.1f;
    private static final float SPREN_ABSORB_RADIUS = 0.05f;
    private static final EntityDataAccessor<OptionalInt> DATA_ORIGIN_ID = SynchedEntityData.m_135353_(SprenOverworld.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_ORIGIN_BLOCK = SynchedEntityData.m_135353_(SprenOverworld.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_INTEREST_BLOCK = SynchedEntityData.m_135353_(SprenOverworld.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Vector3f> DATA_OFFSET = SynchedEntityData.m_135353_(SprenOverworld.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private UUID originUUID;

    public SprenOverworld(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static <T extends SprenOverworld> T addAtBlock(EntityType<T> pEntityType, Level pLevel, BlockPos pPos) {
        SprenOverworld spren;
        if (SprenOverworld.canAddSpren(pLevel) && (spren = (SprenOverworld)pEntityType.m_20615_(pLevel)) != null && spren.isBlockValidOrigin(pPos)) {
            spren.setOrigin(pPos);
            spren.m_146884_(pPos.m_252807_());
            spren.finalizeSpawn();
            if (pLevel.m_7967_((Entity)spren)) {
                return (T)((Object)spren);
            }
            spren.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return null;
    }

    public static <T extends SprenOverworld> T addAroundBlock(EntityType<T> pEntityType, Level pLevel, BlockPos pPos, int pRadius, int pTries) {
        SprenOverworld spren;
        if (SprenOverworld.canAddSpren(pLevel) && (spren = (SprenOverworld)pEntityType.m_20615_(pLevel)) != null) {
            for (BlockPos randomPos : BlockPos.m_235650_((RandomSource)pLevel.f_46441_, (int)pTries, (BlockPos)pPos, (int)pRadius)) {
                if (!spren.isBlockValidOrigin(randomPos)) continue;
                spren.setOrigin(randomPos);
                spren.m_146884_(randomPos.m_252807_());
                spren.finalizeSpawn();
                if (!pLevel.m_7967_((Entity)spren)) break;
                return (T)((Object)spren);
            }
            spren.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return null;
    }

    public static <T extends SprenOverworld> T addForEntity(EntityType<T> pEntityType, LivingEntity pEntity) {
        SprenOverworld spren;
        Level level = pEntity.m_9236_();
        if (SprenOverworld.canAddSpren(level) && (spren = (SprenOverworld)pEntityType.m_20615_(level)) != null) {
            spren.setOrigin((Entity)pEntity);
            spren.m_146884_(pEntity.m_146892_());
            spren.finalizeSpawn();
            if (level.m_7967_((Entity)spren)) {
                return (T)((Object)spren);
            }
            spren.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return null;
    }

    public static boolean canAddSpren(Level pLevel) {
        return !pLevel.m_5776_() && pLevel.m_46472_() == Level.f_46428_ && pLevel.m_46469_().m_46207_(GameRules.f_46134_);
    }

    public static void addClusterAtBlock(EntityType<? extends SprenOverworld> pEntityType, Level pLevel, BlockPos pPos, int pMax) {
        int count = 1 + pLevel.f_46441_.m_188503_(pMax);
        for (int i = 0; i < count; ++i) {
            SprenOverworld.addAtBlock(pEntityType, pLevel, pPos);
        }
    }

    public static void addClusterForEntity(EntityType<? extends SprenOverworld> pEntityType, LivingEntity pEntity, int pMax) {
        int count = 1 + pEntity.m_217043_().m_188503_(pMax);
        for (int i = 0; i < count; ++i) {
            SprenOverworld.addForEntity(pEntityType, pEntity);
        }
    }

    public static boolean spawnChance(RandomSource pSource, int pChance) {
        return pChance <= 0 || pSource.m_188503_(pChance) == 0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ORIGIN_ID, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(DATA_ORIGIN_BLOCK, Optional.empty());
        this.f_19804_.m_135372_(DATA_INTEREST_BLOCK, Optional.empty());
        this.f_19804_.m_135372_(DATA_OFFSET, (Object)new Vector3f());
    }

    public void finalizeSpawn() {
        this.updateOffset();
        this.m_146884_(this.getMovePosition());
        this.playSpawnEffects();
    }

    public void m_6034_(double pX, double pY, double pZ) {
        super.m_6034_(pX, pY, pZ);
        if (pX == 0.0 && pY == 0.0 && pZ == 0.0) {
            return;
        }
        if (this.getOriginBlock() == null && this.getOriginId() < 0) {
            this.setOriginBlock(this.m_20183_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.canDisappear()) {
            if (this.f_19797_ > 150 && this.f_19796_.m_188503_(600) == 0) {
                this.disappear();
            } else if (this.getOriginId() > 0 && this.getOriginEntity() == null) {
                this.disappear();
            } else if (this.getOriginBlock() != null && !this.isBlockValidOrigin(this.getOriginBlock())) {
                this.disappear();
            }
        }
        if (!this.m_213877_()) {
            this.aiStep();
        }
    }

    public void m_6075_() {
        if (this.f_19803_) {
            this.syncOriginId();
        }
        super.m_6075_();
    }

    protected void aiStep() {
        if (this.m_21515_()) {
            this.tryUpdateOffset();
        }
        this.updateAbsorption();
        Vec3 travelVector = Vec3.f_82478_;
        if (!this.isAtMovePosition()) {
            Vec3 delta = this.getMovePosition().m_82546_(this.m_20182_());
            if (!this.canFly()) {
                delta = new Vec3(delta.f_82479_, 0.0, delta.f_82481_);
            }
            if (delta.m_82556_() > 1.0) {
                delta = delta.m_82541_();
            }
            travelVector = delta.m_82490_(this.getMoveSpeed());
        }
        this.travel(travelVector);
        this.updateRotation();
        this.m_20256_(this.m_20184_().m_82490_(this.canFly() ? 0.92 : 0.8));
    }

    protected void tryUpdateOffset() {
        if (this.isAtMovePosition() && (this.getOffsetChance() <= 0 || this.f_19796_.m_188503_(this.getOffsetChance()) == 0)) {
            this.updateOffset();
        }
    }

    protected void updateOffset() {
        float range = this.getOffsetRange();
        this.setOffset((this.f_19796_.m_188501_() - 0.5f) * range, this.f_19796_.m_188501_() * range, (this.f_19796_.m_188501_() - 0.5f) * range);
    }

    protected int getOffsetChance() {
        return 20;
    }

    protected float getOffsetRange() {
        return 1.0f;
    }

    protected void travel(Vec3 pTravelVector) {
        Vec3 deltaMovement = this.m_20184_().m_82549_(pTravelVector);
        if (deltaMovement.m_82556_() < this.getMaxMoveSpeed() * this.getMaxMoveSpeed()) {
            this.m_20256_(deltaMovement);
        }
        this.m_6034_(this.m_20185_() + deltaMovement.f_82479_, this.m_20186_() + deltaMovement.f_82480_, this.m_20189_() + deltaMovement.f_82481_);
        if (!this.canFly()) {
            this.ground();
        }
    }

    private void ground() {
        double height = (double)this.m_146904_() + this.m_9236_().m_45573_(this.m_20183_()) + 0.001;
        this.m_6034_(this.m_20185_(), this.m_20186_() + Mth.m_14008_((double)(height - this.m_20186_()), (double)-0.2, (double)0.2), this.m_20189_());
    }

    public void m_7618_(EntityAnchorArgument.Anchor pAnchor, Vec3 pTarget) {
        this.lookToward(pTarget.m_82546_(pAnchor.m_90377_((Entity)this)));
    }

    public void lookToward(Vec3 pDirection) {
        double hypotenuse = Math.sqrt(pDirection.f_82479_ * pDirection.f_82479_ + pDirection.f_82481_ * pDirection.f_82481_);
        this.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)pDirection.f_82480_, (double)hypotenuse) * 57.2957763671875)))));
        this.m_146922_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)pDirection.f_82481_, (double)pDirection.f_82479_) * 57.2957763671875) - 90.0f)));
        this.m_5616_(this.m_146908_());
    }

    protected void updateRotation() {
        this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.getInterestPosition().m_82520_(0.0, 0.5, 0.0));
    }

    protected void updateAbsorption() {
        BlockEntity blockEntity;
        if (this.getInterestBlock() != null && (blockEntity = this.m_9236_().m_7702_(this.getInterestBlock())) instanceof TransferenceStandEntity) {
            CagedGemItem gemItem;
            TransferenceStandEntity standEntity = (TransferenceStandEntity)blockEntity;
            Item item = standEntity.getItem().m_41720_();
            if (item instanceof CagedGemItem && (gemItem = (CagedGemItem)item).getSprenType() == this.m_6095_()) {
                Vec3 center = standEntity.getTransferPos();
                if (this.m_20238_(center) <= 2.25 && ((Boolean)standEntity.m_58900_().m_61143_((Property)StormlightTransferBlock.IS_TRANSFERRING)).booleanValue()) {
                    this.m_20256_(center.m_82546_(this.m_20182_()).m_82541_().m_82490_((double)0.1f));
                    if (this.m_21515_() && this.isAt(center, 0.05f)) {
                        standEntity.absorbSpren(this.m_9236_(), this.getInterestBlock(), this);
                    }
                }
            } else {
                this.setInterestBlock(null);
            }
        }
    }

    protected boolean isBlockValidOrigin(BlockPos pPos) {
        return SprenOverworld.isBlockEmpty((LevelAccessor)this.m_9236_(), pPos);
    }

    protected static boolean isBlockEmpty(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos).m_60812_((BlockGetter)pLevel, pPos).m_83281_();
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("Origin")) {
            this.originUUID = pCompound.m_128342_("Origin");
        } else if (pCompound.m_128441_("OriginBlock")) {
            this.setOriginBlock(NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("OriginBlock")));
        }
        if (pCompound.m_128441_("InterestBlock")) {
            this.setInterestBlock(NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("InterestBlock")));
        }
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.originUUID != null) {
            pCompound.m_128362_("Origin", this.originUUID);
        } else if (this.getOriginBlock() != null) {
            pCompound.m_128365_("OriginBlock", (Tag)NbtUtils.m_129224_((BlockPos)this.getOriginBlock()));
        }
        if (this.getInterestBlock() != null) {
            pCompound.m_128365_("InterestBlock", (Tag)NbtUtils.m_129224_((BlockPos)this.getInterestBlock()));
        }
    }

    public int getOriginId() {
        return ((OptionalInt)this.f_19804_.m_135370_(DATA_ORIGIN_ID)).orElse(-1);
    }

    public Entity getOriginEntity() {
        return this.m_9236_().m_6815_(this.getOriginId());
    }

    protected void setOriginId(int id) {
        this.f_19804_.m_135381_(DATA_ORIGIN_ID, (Object)OptionalInt.of(id));
    }

    private void syncOriginId() {
        ServerLevel serverLevel;
        Entity entity;
        if (this.originUUID == null) {
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(this.originUUID)) != null) {
            this.setOriginId(entity.m_19879_());
        }
    }

    @Nullable
    public BlockPos getOriginBlock() {
        return ((Optional)this.f_19804_.m_135370_(DATA_ORIGIN_BLOCK)).orElse(null);
    }

    protected void setOriginBlock(BlockPos pPos) {
        this.f_19804_.m_135381_(DATA_ORIGIN_BLOCK, Optional.ofNullable(pPos));
    }

    @Nullable
    public BlockPos getInterestBlock() {
        return ((Optional)this.f_19804_.m_135370_(DATA_INTEREST_BLOCK)).orElse(null);
    }

    public void setInterestBlock(BlockPos pPos) {
        this.f_19804_.m_135381_(DATA_INTEREST_BLOCK, Optional.ofNullable(pPos));
    }

    public Vec3 getOffset() {
        return new Vec3((Vector3f)this.f_19804_.m_135370_(DATA_OFFSET));
    }

    protected void setOffset(float pX, float pY, float pZ) {
        this.f_19804_.m_135381_(DATA_OFFSET, (Object)new Vector3f(pX, pY, pZ));
    }

    protected void setOffset(Vec3 pOffset) {
        this.f_19804_.m_135381_(DATA_OFFSET, (Object)pOffset.m_252839_());
    }

    public boolean m_5825_() {
        return true;
    }

    protected boolean m_20073_() {
        this.f_19799_.clear();
        this.forgeFluidTypeHeight.clear();
        return this.isInFluidType();
    }

    protected boolean canDisappear() {
        return this.getInterestBlock() == null;
    }

    public void disappear() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.playSpawnEffects();
    }

    public boolean canFly() {
        return true;
    }

    public void setOrigin(BlockPos pPos) {
        this.setOriginBlock(pPos);
        this.setOriginId(-1);
        this.originUUID = null;
    }

    public void setOrigin(Entity pEntity) {
        this.setOriginBlock(null);
        this.setOriginId(pEntity.m_19879_());
        this.originUUID = pEntity.m_20148_();
    }

    protected Vec3 getOriginPosition() {
        Entity entity;
        if (this.getOriginId() >= 0 && (entity = this.getOriginEntity()) != null) {
            return entity.m_20192_() > 0.5f ? entity.m_146892_().m_82492_(0.0, 0.5, 0.0) : entity.m_20182_();
        }
        if (this.getOriginBlock() != null) {
            return this.getOriginBlock().m_252807_().m_82492_(0.0, 0.5, 0.0);
        }
        return this.m_20182_();
    }

    protected Vec3 getInterestPosition() {
        if (this.getInterestBlock() != null) {
            return this.getInterestBlock().m_252807_().m_82492_(0.0, 0.5, 0.0);
        }
        return this.getOriginPosition();
    }

    @NotNull
    protected Vec3 getMovePosition() {
        return this.getInterestPosition().m_82549_(this.getOffset());
    }

    protected boolean isAtMovePosition() {
        return this.isAt(this.getMovePosition());
    }

    public boolean isAt(Vec3 pPosition) {
        return this.isAt(pPosition, 0.25);
    }

    public boolean isAt(Vec3 pPosition, double pError) {
        if (!this.canFly()) {
            return this.m_146904_() == Mth.m_14107_((double)pPosition.f_82480_) && this.m_20182_().m_82546_(pPosition).m_165925_() < pError * pError;
        }
        return pPosition.m_82557_(this.m_20182_()) <= pError * pError;
    }

    protected double getMoveSpeed() {
        return 0.02;
    }

    protected double getMaxMoveSpeed() {
        return 0.15;
    }

    public boolean m_6783_(double pDistance) {
        double range = 64.0;
        return pDistance < range * range;
    }

    protected void playSpawnEffects() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.0, 0.0, 0.0, 0.01);
        }
    }
}

