/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.stormlighttrader;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import us.amon.stormward.entity.stormlighttrader.IStormlightTrade;
import us.amon.stormward.item.StormwardItems;

public class TrueSprenTrades {
    public static final IStormlightTrade[] TRADES = new IStormlightTrade[]{new RandomTrade(30, (Item)StormwardItems.SMOKESTONE_MARK.get(), (Item)StormwardItems.TOPAZ_MARK.get(), (Item)StormwardItems.GARNET_MARK.get(), (Item)StormwardItems.RUBY_MARK.get(), (Item)StormwardItems.AMETHYST_MARK.get(), (Item)StormwardItems.SAPPHIRE_MARK.get(), (Item)StormwardItems.ZIRCON_MARK.get(), (Item)StormwardItems.DIAMOND_MARK.get(), (Item)StormwardItems.EMERALD_MARK.get()), new RandomTrade(100, (Item)StormwardItems.SMOKESTONE_BROAM.get(), (Item)StormwardItems.TOPAZ_BROAM.get(), (Item)StormwardItems.GARNET_BROAM.get(), (Item)StormwardItems.RUBY_BROAM.get(), (Item)StormwardItems.AMETHYST_BROAM.get(), (Item)StormwardItems.SAPPHIRE_BROAM.get(), (Item)StormwardItems.ZIRCON_BROAM.get(), (Item)StormwardItems.DIAMOND_BROAM.get(), (Item)StormwardItems.EMERALD_BROAM.get()), new RandomTrade(60, (Item)StormwardItems.GOLDEN_SPEAR.get(), Items.f_42430_), new RandomTrade(70, (Item)StormwardItems.IRON_SPEAR.get(), Items.f_42383_), new RandomTrade(100, (Item)StormwardItems.DIAMOND_SPEAR.get(), Items.f_42388_), new ItemTrade(70, Items.f_42411_), new ItemTrade(100, Items.f_42717_), new ItemTrade(30, Items.f_42412_, 4), new ItemTrade(20, Items.f_151052_), new ItemTrade(30, Items.f_42417_), new ItemTrade(30, Items.f_42416_), new RandomTrade(50, (Item)StormwardItems.SMOKESTONE_SHARD.get(), (Item)StormwardItems.TOPAZ.get(), (Item)StormwardItems.GARNET.get(), (Item)StormwardItems.RUBY.get(), Items.f_151049_, (Item)StormwardItems.SAPPHIRE.get(), (Item)StormwardItems.ZIRCON.get(), Items.f_42415_, Items.f_42616_), new ItemTrade(20, Items.f_42781_), new RandomTrade(30, Items.f_42453_, Items.f_42742_, Items.f_42743_, Items.f_42744_, Items.f_42746_, Items.f_220204_, Items.f_271386_, Items.f_244624_, (Item)StormwardItems.MARKEL_BOAT.get(), (Item)StormwardItems.STUMPWEIGHT_BOAT.get())};

    public static class RandomTrade
    implements IStormlightTrade {
        private final ItemStack[] items;
        private final int cost;

        public RandomTrade(int pCost, Item ... pItems) {
            this(pCost, Stream.of(pItems).map(ItemStack::new).toList());
        }

        public RandomTrade(int pCost, List<ItemStack> pItems) {
            this.items = pItems.toArray(new ItemStack[0]);
            this.cost = pCost;
        }

        public RandomTrade(int pCost, ItemStack ... pItems) {
            this.items = pItems;
            this.cost = pCost;
        }

        @Override
        public ItemStack getItem(RandomSource pRandom) {
            return this.items[pRandom.m_188503_(this.items.length)];
        }

        @Override
        public int getCost(RandomSource pRandom) {
            return this.cost;
        }
    }

    public static class ItemTrade
    implements IStormlightTrade {
        private final ItemStack item;
        private final int cost;

        public ItemTrade(int pCost, Item pItem) {
            this(pCost, pItem, 1);
        }

        public ItemTrade(int pCost, Item pItem, int pCount) {
            this(pCost, ItemTrade.stack(pItem, pCount));
        }

        private static ItemStack stack(Item pItem, int pCount) {
            ItemStack stack = new ItemStack((ItemLike)pItem);
            stack.m_41764_(pCount);
            return stack;
        }

        public ItemTrade(int pCost, ItemStack pItem) {
            this.item = pItem;
            this.cost = pCost;
        }

        @Override
        public ItemStack getItem(RandomSource pRandom) {
            return this.item;
        }

        @Override
        public int getCost(RandomSource pRandom) {
            return this.cost;
        }
    }
}

