/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.villager;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.entity.villager.SphereMerchantOffer;
import us.amon.stormward.entity.villager.SphereOfferTier;
import us.amon.stormward.gemstone.Gemstone;
import us.amon.stormward.item.StormwardItems;

public class StormwardVillagerTrades {
    public static final ImmutableMap<Item, Item> CONVERSIONS = new ImmutableMap.Builder().put((Object)Items.f_42461_, (Object)((Item)StormwardItems.CREM_SLUDGE.get())).put((Object)Items.f_42460_, (Object)((Item)StormwardItems.CREM_BRICK.get())).put((Object)Items.f_42054_, (Object)((Block)StormwardBlocks.LUMINOUS_CRYSTAL.get()).m_5456_()).put((Object)Items.f_42405_, (Object)((Item)StormwardItems.LAVIS_GRAIN.get())).put((Object)Items.f_42406_, (Object)((Item)StormwardItems.LAVIS_FLATBREAD.get())).put((Object)Items.f_42420_, (Object)((Item)StormwardItems.WOODEN_SPEAR.get())).put((Object)Items.f_42425_, (Object)((Item)StormwardItems.STONE_SPEAR.get())).put((Object)Items.f_42383_, (Object)((Item)StormwardItems.IRON_SPEAR.get())).put((Object)Items.f_42430_, (Object)((Item)StormwardItems.GOLDEN_SPEAR.get())).put((Object)Items.f_42388_, (Object)((Item)StormwardItems.DIAMOND_SPEAR.get())).put((Object)Items.f_42393_, (Object)((Item)StormwardItems.NETHERITE_SPEAR.get())).build();
    public static final ImmutableMap<VillagerProfession, Gemstone> GEMSTONE_TYPE = new ImmutableMap.Builder().put((Object)VillagerProfession.f_35586_, (Object)Gemstone.RUBY).put((Object)VillagerProfession.f_35587_, (Object)Gemstone.AMETHYST).put((Object)VillagerProfession.f_35588_, (Object)Gemstone.RUBY).put((Object)VillagerProfession.f_35589_, (Object)Gemstone.TOPAZ).put((Object)VillagerProfession.f_35590_, (Object)Gemstone.EMERALD).put((Object)VillagerProfession.f_35591_, (Object)Gemstone.AMETHYST).put((Object)VillagerProfession.f_35592_, (Object)Gemstone.SAPPHIRE).put((Object)VillagerProfession.f_35593_, (Object)Gemstone.EMERALD).put((Object)VillagerProfession.f_35594_, (Object)Gemstone.ZIRCON).put((Object)VillagerProfession.f_35595_, (Object)Gemstone.DIAMOND).put((Object)VillagerProfession.f_35597_, (Object)Gemstone.RUBY).put((Object)VillagerProfession.f_35598_, (Object)Gemstone.GARNET).put((Object)VillagerProfession.f_35599_, (Object)Gemstone.SMOKESTONE).build();

    public static MerchantOffer convertVanillaOffer(Villager pVillager, MerchantOffer pOffer) {
        ItemStack costA = StormwardVillagerTrades.convertCost(pOffer.m_45358_());
        ItemStack costB = StormwardVillagerTrades.convertCost(pOffer.m_45364_());
        Gemstone gemstone = (Gemstone)((Object)GEMSTONE_TYPE.get((Object)pVillager.m_7141_().m_35571_()));
        ItemStack result = StormwardVillagerTrades.convertResult(pOffer.m_45368_(), gemstone);
        if (!pOffer.m_45358_().m_150930_(Items.f_42616_)) {
            return new SphereMerchantOffer(costA, costB, result, pOffer.m_45371_(), pOffer.m_45373_(), pOffer.m_45379_(), pOffer.m_45378_(), pOffer.m_45375_());
        }
        if (pOffer.m_45364_() != ItemStack.f_41583_) {
            return new SphereMerchantOffer(StormwardVillagerTrades.getTier(costA), Gemstone.AMETHYST, costB, result, pOffer.m_45371_(), pOffer.m_45373_(), pOffer.m_45379_(), pOffer.m_45378_(), pOffer.m_45375_());
        }
        return new SphereMerchantOffer(StormwardVillagerTrades.getTier(costA), gemstone, gemstone, result, pOffer.m_45371_(), pOffer.m_45373_(), pOffer.m_45379_(), pOffer.m_45378_(), pOffer.m_45375_());
    }

    private static ItemStack convertCost(ItemStack pStack) {
        Item convertedItem = (Item)CONVERSIONS.get((Object)pStack.m_41720_());
        if (convertedItem != null) {
            ItemStack convertedStack = new ItemStack((ItemLike)convertedItem, pStack.m_41613_());
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)pStack).entrySet()) {
                if (!convertedStack.canApplyAtEnchantingTable((Enchantment)entry.getKey())) continue;
                convertedStack.m_41663_((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            return convertedStack;
        }
        return pStack;
    }

    private static ItemStack convertResult(ItemStack pStack, Gemstone pGemstone) {
        return pStack.m_150930_(Items.f_42616_) ? StormwardVillagerTrades.getTier(pStack).getCostA(pGemstone) : StormwardVillagerTrades.convertCost(pStack);
    }

    private static SphereOfferTier getTier(ItemStack pCost) {
        int count = pCost.m_41613_();
        if (count > 21) {
            return SphereOfferTier.BROAM;
        }
        if (count > 15) {
            return SphereOfferTier.MARK_MARK;
        }
        if (count > 9) {
            return SphereOfferTier.MARK_CHIP;
        }
        if (count > 3) {
            return SphereOfferTier.MARK;
        }
        if (count > 1) {
            return SphereOfferTier.CHIP_CHIP;
        }
        return SphereOfferTier.CHIP;
    }
}

