/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.events;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import us.amon.stormward.block.worldgen.CognitiveBeadsBlock;
import us.amon.stormward.gui.StormwardGui;
import us.amon.stormward.item.weapon.GrandbowItem;
import us.amon.stormward.item.weapon.TwoHandedWeaponItem;
import us.amon.stormward.weather.Highstorm;

@Mod.EventBusSubscriber(modid="stormward", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientEvents {
    @SubscribeEvent
    public static void onGuiRender(RenderGuiEvent.Pre event) {
        StormwardGui.onRenderPre(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public static void onGuiRender(RenderGuiEvent.Post event) {
        StormwardGui.onRenderPost(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public static void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        Highstorm.onComputeFogColor(event);
        CognitiveBeadsBlock.onComputeFogColor(event);
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Highstorm.onRenderFog(event);
        CognitiveBeadsBlock.onRenderFog(event);
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        TwoHandedWeaponItem.onRenderHand(event);
        GrandbowItem.onRenderHand(event);
    }

    @SubscribeEvent
    public static void onComputeFovModifier(ComputeFovModifierEvent event) {
        GrandbowItem.onComputeFovModifier(event);
        CognitiveBeadsBlock.onComputeFovModifier(event);
    }
}

