/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.events;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDrownEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import us.amon.stormward.attribute.StormwardAttributes;
import us.amon.stormward.block.worldgen.CognitiveBeadsBlock;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.shardstorage.ShardStorageHelper;
import us.amon.stormward.capability.tusks.TusksHelper;
import us.amon.stormward.command.FormatStructureElementCommand;
import us.amon.stormward.command.SpawnShardplateTrimsCommand;
import us.amon.stormward.entity.duel.Duel;
import us.amon.stormward.entity.spren.overworld.Creationspren;
import us.amon.stormward.entity.spren.overworld.Gloryspren;
import us.amon.stormward.entity.spren.overworld.Musicspren;
import us.amon.stormward.entity.spren.overworld.Painspren;
import us.amon.stormward.entity.spren.overworld.Passionspren;
import us.amon.stormward.item.RegrowerItem;
import us.amon.stormward.item.armor.ShardplateItem;
import us.amon.stormward.item.weapon.ShardhammerItem;
import us.amon.stormward.item.weapon.TwoHandedWeaponItem;
import us.amon.stormward.level.Duels;
import us.amon.stormward.level.PlateauRuns;
import us.amon.stormward.weather.Highstorm;

@Mod.EventBusSubscriber(modid="stormward", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        StormwardAttributes.onLivingJump(event.getEntity());
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        StormwardAttributes.onLivingFall(event);
    }

    @SubscribeEvent
    public static void onLivingEntityDamaged(LivingDamageEvent event) {
        ShardplateItem.onLivingEntityDamaged(event);
        Painspren.onLivingEntityDamaged(event);
        RegrowerItem.onLivingEntityDamaged(event);
    }

    @SubscribeEvent
    public static void onLivingEntityHurt(LivingHurtEvent event) {
        ShardhammerItem.onLivingEntityHurt(event);
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        ShardhammerItem.onShieldBlock(event);
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        Highstorm.onLivingEntityTick(event.getEntity());
        TusksHelper.onLivingEntityTick(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Highstorm.onPlayerTick(event.player, event.phase);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        StormwardCapabilities.onPlayerClone(event.isWasDeath(), event.getOriginal(), event.getEntity());
    }

    @SubscribeEvent
    public static void onLivingEntityUseItemStart(LivingEntityUseItemEvent.Start event) {
        TwoHandedWeaponItem.onLivingEntityUseItemStart(event);
    }

    @SubscribeEvent
    public static void onLivingEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        TwoHandedWeaponItem.onLivingEntityUseItemTick(event);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        SpawnShardplateTrimsCommand.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
        FormatStructureElementCommand.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Creationspren.onItemCrafted(event.getEntity(), event.getCrafting());
    }

    @SubscribeEvent
    public static void onAnimalTame(AnimalTameEvent event) {
        Passionspren.onAnimalTame(event.getAnimal());
    }

    @SubscribeEvent
    public static void onVanillaGameEvent(VanillaGameEvent event) {
        Gloryspren.onVanillaGameEvent(event);
        Musicspren.onVanillaGameEvent(event);
        Duel.onVanillaGameEvent(event);
        TusksHelper.onVanillaGameEvent(event);
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        PlateauRuns.onTickLevel(event);
        Duels.onTickLevel(event);
    }

    @SubscribeEvent
    public static void onLivingBreathe(LivingBreatheEvent event) {
        CognitiveBeadsBlock.onLivingBreathe(event);
    }

    @SubscribeEvent
    public static void onLivingDrown(LivingDrownEvent event) {
        CognitiveBeadsBlock.onLivingDrown(event);
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        StormwardCapabilities.onAttachCapabilitiesEntity(event);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        StormwardCapabilities.onPlayerLoggedIn(event.getEntity());
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        ShardStorageHelper.onEntityTravelToDimension(event.getEntity(), (ResourceKey<Level>)event.getDimension());
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ShardStorageHelper.onLivingDeath(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ShardStorageHelper.onPlayerRespawn(event.getEntity());
    }
}

