/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.effect.StormwardEffects;
import us.amon.stormward.item.armor.ShardplateItem;
import us.amon.stormward.weather.Highstorm;

public class StormwardGui {
    protected static final ResourceLocation HIGHSTORM_OVERLAY = new ResourceLocation("stormward", "textures/misc/highstorm_overlay.png");
    private static final ResourceLocation SHARDHELM_OVERLAY = new ResourceLocation("stormward", "textures/misc/shardplate_helmet.png");
    private static final ResourceLocation TERROR_OVERLAY = new ResourceLocation("stormward", "textures/misc/terror.png");

    public static void onRenderPre(GuiGraphics pGuiGraphics, float pPartialTick) {
        ForgeGui gui = (ForgeGui)Minecraft.m_91087_().f_91065_;
        Entity entity = gui.getMinecraft().m_91288_();
        if (entity != null && !Minecraft.m_91087_().f_91063_.m_109153_().m_90594_()) {
            Level level = entity.m_9236_();
            if (Highstorm.isEntityExposedToHighstorm(entity)) {
                gui.setupOverlayRenderState(true, false);
                StormwardGui.renderHighstormOverlay(pGuiGraphics, level.f_46438_, pGuiGraphics.m_280182_(), pGuiGraphics.m_280206_(), (float)gui.m_93079_() + pPartialTick);
            }
            if (entity instanceof LivingEntity) {
                MobEffectInstance terror;
                LivingEntity living = (LivingEntity)entity;
                ItemStack stack = living.m_6844_(EquipmentSlot.HEAD);
                if (stack.m_41720_() instanceof ShardplateItem && !StormlightStorageHelper.isDun((ICapabilityProvider)stack)) {
                    gui.setupOverlayRenderState(true, false);
                    StormwardGui.renderShardhelmOverlay(pGuiGraphics, pGuiGraphics.m_280182_(), pGuiGraphics.m_280206_());
                }
                if ((terror = living.m_21124_((MobEffect)StormwardEffects.TERROR.get())) != null) {
                    gui.setupOverlayRenderState(true, false);
                    StormwardGui.renderTerrorOverlay(pGuiGraphics, (float)(terror.m_19564_() + 1) / 4.0f, pGuiGraphics.m_280182_(), pGuiGraphics.m_280206_());
                }
            }
        }
    }

    public static void onRenderPost(GuiGraphics pGuiGraphics, float pPartialTick) {
    }

    protected static void renderTextureOverlay(GuiGraphics pGuiGraphics, ResourceLocation pShaderLocation, float pAlpha, int screenWidth, int screenHeight, float offsetX, float offsetY) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, pAlpha);
        pGuiGraphics.m_280398_(pShaderLocation, 0, 0, -90, -offsetX, -offsetY, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void renderHighstormOverlay(GuiGraphics pGuiGraphics, float pAlpha, int screenWidth, int screenHeight, float pTick) {
        StormwardGui.renderTextureOverlay(pGuiGraphics, HIGHSTORM_OVERLAY, pAlpha, screenWidth, screenHeight, pTick * 48.0f, pTick * 48.0f);
    }

    protected static void renderShardhelmOverlay(GuiGraphics pGuiGraphics, int screenWidth, int screenHeight) {
        StormwardGui.renderTextureOverlay(pGuiGraphics, SHARDHELM_OVERLAY, 1.0f, screenWidth, screenHeight, 0.0f, 0.0f);
    }

    protected static void renderTerrorOverlay(GuiGraphics pGuiGraphics, float pAlpha, int screenWidth, int screenHeight) {
        StormwardGui.renderTextureOverlay(pGuiGraphics, TERROR_OVERLAY, pAlpha, screenWidth, screenHeight, 0.0f, 0.0f);
    }
}

