/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.Config;
import us.amon.stormward.attribute.StormwardAttributes;
import us.amon.stormward.capability.shardstorage.ShardStorageHelper;
import us.amon.stormward.capability.stormlightstorage.StormlightConfigStorageProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.armor.ShardplateMaterial;
import us.amon.stormward.item.shard.IShardItem;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItemHelper;
import us.amon.stormward.tag.StormwardDamageTypeTags;

public class ShardplateItem
extends ArmorItem
implements IShardItem {
    private final Multimap<Attribute, AttributeModifier> shardplateModifiers;
    private final UUID uuid;
    private final int baseStormlight;

    public ShardplateItem(ShardplateMaterial pShardplateMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super((ArmorMaterial)pShardplateMaterial, pType, pProperties.m_41497_(Rarity.EPIC));
        this.baseStormlight = pShardplateMaterial.getBaseStormlightForType(pType);
        Multimap defaultModifiers = super.m_7167_(pType.m_266308_());
        this.uuid = ((AttributeModifier)defaultModifiers.get((Object)Attributes.f_22284_).stream().findAny().orElseThrow()).m_22209_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(defaultModifiers);
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(this.uuid, "Shardplate modifier", (double)0.02f, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)StormwardAttributes.JUMP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(this.uuid, "Shardplate modifier", 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(this.uuid, "Shardplate modifier", 0.25, AttributeModifier.Operation.ADDITION));
        this.shardplateModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? ImmutableMultimap.of() : super.getAttributeModifiers(slot, stack);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        if (pEquipmentSlot == this.f_265916_.m_266308_()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder().putAll(this.shardplateModifiers);
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.uuid, "Shardplate modifier", ((Double)Config.SHARDPLATE_DAMAGE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return ImmutableMultimap.of();
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        StormlightStorageItemHelper.damageItem(stack, amount * 2, entity, onBroken);
        if (StormlightStorageHelper.isDun((ICapabilityProvider)stack) && !(entity instanceof Player)) {
            ItemEntity itementity = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), stack.m_41777_());
            itementity.m_32060_();
            entity.m_9236_().m_7967_((Entity)itementity);
            return 1;
        }
        return 0;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? 0 : super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? Map.of() : EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new StormlightConfigStorageProvider(Config.SHARDPLATE_STORMLIGHT_MULTIPLIER, this.baseStormlight);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return StormlightStorageItemHelper.getShareTag(stack);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        StormlightStorageItemHelper.readShareTag(stack, nbt);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return StormlightStorageItemHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.isBarVisible(pStack);
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarWidth(pStack);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarColor(pStack);
    }

    public void m_7373_(@NotNull ItemStack pStack, @javax.annotation.Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        StormlightStorageItemHelper.appendHoverText(pStack, pLevel, pTooltip, pFlag);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageItemHelper.canApplyAtEnchantingTable(enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        ShardStorageHelper.tickShardStorage(level, (Entity)player, stack, slotIndex);
    }

    public static void onLivingEntityDamaged(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        boolean bypassed = source.m_269533_(StormwardDamageTypeTags.BYPASSES_SHARDPLATE);
        if (!bypassed) {
            float multiplier = 1.0f;
            for (ItemStack stack : entity.m_6168_()) {
                Item item = stack.m_41720_();
                if (!(item instanceof ShardplateItem)) continue;
                ShardplateItem shardplateItem = (ShardplateItem)item;
                if (StormlightStorageHelper.isDun((ICapabilityProvider)stack)) continue;
                multiplier -= ShardplateMaterial.getDamageReductionForType(shardplateItem.m_266204_());
            }
            event.setAmount(amount * multiplier);
        }
        if (source.m_269533_(DamageTypeTags.f_268490_) && (!bypassed || source.m_269533_(StormwardDamageTypeTags.BYPASSES_AND_DAMAGES_SHARDPLATE))) {
            ShardplateItem.hurtShardplate(entity, source, amount);
        }
    }

    public static void hurtShardplate(LivingEntity pEntity, @NotNull DamageSource pDamageSource, float pDamageAmount) {
        if (pDamageAmount > 0.0f) {
            if ((pDamageAmount /= 4.0f) < 1.0f) {
                pDamageAmount = 1.0f;
            }
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                ItemStack itemstack = pEntity.m_6844_(type.m_266308_());
                if (!(itemstack.m_41720_() instanceof ShardplateItem) || pDamageSource.m_269533_(DamageTypeTags.f_268745_) && itemstack.m_41720_().m_41475_() || pDamageSource.m_269533_(StormwardDamageTypeTags.BYPASSES_SHARDPLATE) && !pDamageSource.m_269533_(StormwardDamageTypeTags.BYPASSES_AND_DAMAGES_SHARDPLATE)) continue;
                itemstack.m_41622_((int)pDamageAmount, pEntity, shardbearer -> shardbearer.m_21166_(type.m_266308_()));
            }
        }
    }
}

