/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.properties;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.tool.EssenceDetectorItem;

public class EssenceDetectorPropertyFunction
implements ClampedItemPropertyFunction {
    private final DetectorWobble mainWobble = new DetectorWobble();
    private final DetectorWobble offWobble = new DetectorWobble();
    private final DetectorWobble randomWobble = new DetectorWobble();

    public float m_142187_(@NotNull ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
        LivingEntity entity;
        Object object = entity = pEntity != null ? pEntity : pStack.m_41609_();
        if (entity == null) {
            return 0.0f;
        }
        return (pLevel = this.tryFetchLevelIfMissing((Entity)entity, pLevel)) == null ? 0.0f : this.getDetectorRotation(pStack, pLevel, (Entity)entity);
    }

    private float getDetectorRotation(ItemStack pStack, ClientLevel pLevel, Entity pEntity) {
        BlockPos pos = EssenceDetectorItem.getPos(pStack);
        long gameTime = pLevel.m_46467_();
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            boolean local = player.m_7578_();
            if (pos != null) {
                if (this.hasMatchingPos(player.m_21205_(), pos)) {
                    return this.getRotationTowardsDetectorTarget(pEntity, pos, gameTime, local ? this.mainWobble : null);
                }
                if (this.hasMatchingPos(player.m_21206_(), pos)) {
                    return this.getRotationTowardsDetectorTarget(pEntity, pos, gameTime, local ? this.offWobble : null);
                }
            } else {
                if (pStack == player.m_21205_()) {
                    return this.getRotationToward(gameTime, Math.random(), local ? this.mainWobble : this.randomWobble);
                }
                if (pStack == player.m_21206_()) {
                    return this.getRotationToward(gameTime, Math.random(), local ? this.offWobble : this.randomWobble);
                }
            }
        }
        return 0.0f;
    }

    private boolean hasMatchingPos(ItemStack pHeldStack, @NotNull BlockPos pPos) {
        return pHeldStack.m_150930_((Item)StormwardItems.ESSENCE_DETECTOR.get()) && pPos.equals((Object)EssenceDetectorItem.getPos(pHeldStack));
    }

    private float getRotationTowardsDetectorTarget(Entity pEntity, BlockPos pPos, long pTicks, @Nullable DetectorWobble pWobble) {
        double entityToPos = this.getAngleFromEntityToPos(pEntity, pPos);
        double visualRot = this.getWrappedVisualRotationY(pEntity);
        if (pWobble != null) {
            if (pWobble.shouldUpdate(pTicks)) {
                pWobble.update(pTicks, entityToPos + 0.5 - (visualRot - 0.25));
            }
            return Mth.m_14091_((float)((float)pWobble.rotation), (float)1.0f);
        }
        double unwobbled = Mth.m_14008_((double)(0.5 - (visualRot - 0.25 - entityToPos)), (double)-0.125, (double)0.125);
        return Mth.m_14091_((float)((float)unwobbled), (float)1.0f);
    }

    private float getRotationToward(long pTicks, double pRotation, DetectorWobble pWobble) {
        if (pWobble.shouldUpdate(pTicks)) {
            pWobble.update(pTicks, pRotation);
        }
        return Mth.m_14091_((float)((float)pWobble.rotation), (float)1.0f);
    }

    @Nullable
    private ClientLevel tryFetchLevelIfMissing(Entity pEntity, @Nullable ClientLevel pLevel) {
        return pLevel == null && pEntity.m_9236_() instanceof ClientLevel ? (ClientLevel)pEntity.m_9236_() : pLevel;
    }

    private double getAngleFromEntityToPos(Entity pEntity, BlockPos pPos) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pPos);
        return Math.atan2(vec3.m_7094_() - pEntity.m_20189_(), vec3.m_7096_() - pEntity.m_20185_()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(Entity pEntity) {
        return Mth.m_14109_((double)(pEntity.m_213816_() / 360.0f), (double)1.0);
    }

    static class DetectorWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        DetectorWobble() {
        }

        boolean shouldUpdate(long pTicks) {
            return this.lastUpdateTick != pTicks;
        }

        void update(long pTicks, double pRotation) {
            this.lastUpdateTick = pTicks;
            double d0 = pRotation - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation += this.deltaRotation;
            if (this.rotation > 0.125) {
                this.rotation = 0.125;
                this.deltaRotation *= -0.9;
            } else if (this.rotation < -0.125) {
                this.rotation = -0.125;
                this.deltaRotation *= -0.9;
            }
        }
    }
}

