/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.shard;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.entity.goal.TrueSprenFollowBondGoal;
import us.amon.stormward.entity.spren.shadesmar.TrueSprenShadesmar;
import us.amon.stormward.item.shard.IShardItem;
import us.amon.stormward.worldgen.dimension.StormwardDimensions;

public interface ISprenShardItem
extends IShardItem {
    public static final String SPREN_KEY = "spren";

    @Override
    default public void onShardStored(Entity pEntity, ItemStack pStack) {
        TrueSprenShadesmar spren;
        if (!pEntity.m_9236_().f_46443_ && (spren = this.spawnSpren(this.getSprenType(), pEntity)) != null) {
            if (pStack.m_41788_()) {
                spren.m_6593_(pStack.m_41786_());
            }
            CompoundTag tag = pStack.m_41784_();
            tag.m_128362_(SPREN_KEY, spren.m_20148_());
        }
    }

    @Override
    default public void onShardReturned(Entity pEntity, ItemStack pStack) {
        CompoundTag tag;
        Level level = pEntity.m_9236_();
        if (!level.f_46443_ && pStack.m_41782_() && (tag = pStack.m_41783_()).m_128403_(SPREN_KEY) && level instanceof ServerLevel) {
            Entity spren;
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_46472_() != StormwardDimensions.SHADESMAR_DIMENSION) {
                MinecraftServer server = serverLevel.m_7654_();
                serverLevel = server.m_129880_(StormwardDimensions.SHADESMAR_DIMENSION);
            }
            if ((spren = serverLevel.m_8791_(tag.m_128342_(SPREN_KEY))) != null) {
                spren.m_146870_();
            }
            tag.m_128473_(SPREN_KEY);
        }
    }

    @Nullable
    default public EntityType<? extends TrueSprenShadesmar> getSprenType() {
        return null;
    }

    default public TrueSprenShadesmar spawnSpren(EntityType<? extends TrueSprenShadesmar> pSprenType, Entity pEntity) {
        TrueSprenShadesmar spren;
        if (pSprenType != null && (spren = (TrueSprenShadesmar)pSprenType.m_20615_(pEntity.m_9236_())) != null) {
            if (!TrueSprenFollowBondGoal.teleport(spren, pEntity)) {
                spren.m_146884_(pEntity.m_20182_());
            }
            spren.m_5616_(spren.m_217043_().m_188501_() * 360.0f);
            spren.setDeadeye(true);
            spren.setNahelBond(pEntity);
            if (pEntity.m_9236_().m_7967_((Entity)spren)) {
                return spren;
            }
        }
        return null;
    }

    public static ItemStack getShardFromSpren(TrueSprenShadesmar pSpren) {
        Entity bondedEntity;
        if (pSpren.hasNahelBond() && pSpren.isDeadeye() && (bondedEntity = pSpren.getBondedEntity()) != null) {
            return bondedEntity.getCapability(StormwardCapabilities.SHARD_STORAGE).map(shards -> {
                for (ItemStack shard : shards.getShards()) {
                    CompoundTag tag;
                    if (!shard.m_41782_() || !(tag = shard.m_41783_()).m_128403_(SPREN_KEY) || !tag.m_128342_(SPREN_KEY).equals(pSpren.m_20148_())) continue;
                    return shard;
                }
                return ItemStack.f_41583_;
            }).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }
}

