/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.soulcaster;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.wood.StormwardLogBlock;

public enum Essence {
    SMOKE("smoke", Style.f_131099_.m_178520_(10722725), () -> ((Block)Blocks.f_50016_).m_49966_()),
    GOLD("gold", Style.f_131099_.m_178520_(13996609), () -> ((Block)Blocks.f_152600_).m_49966_()),
    COPPER("copper", Style.f_131099_.m_178520_(15294033), () -> ((Block)Blocks.f_152599_).m_49966_()),
    COAL("coal", Style.f_131099_.m_178520_(12069944), () -> ((Block)Blocks.f_50353_).m_49966_()),
    MEAT("meat", Style.f_131099_.m_178520_(10116294), () -> ((Block)StormwardBlocks.SOULCAST_MEAT_BLOCK.get()).m_49966_()),
    IRON("iron", Style.f_131099_.m_178520_(4159182), () -> ((Block)Blocks.f_152598_).m_49966_()),
    REDSTONE("redstone", Style.f_131099_.m_178520_(2868187), () -> ((Block)Blocks.f_50330_).m_49966_()),
    WOOD("wood", Style.f_131099_.m_178520_(7269586), () -> ((StormwardLogBlock)((Object)((Object)StormwardBlocks.MARKEL_WOOD.get()))).m_49966_()),
    GRAIN("grain", Style.f_131099_.m_178520_(1155126), () -> ((Block)StormwardBlocks.LAVIS_GRAIN_BLOCK.get()).m_49966_());

    private static final Essence[] BY_ID;
    private final String name;
    private final Style style;
    private final Supplier<BlockState> blockState;

    private Essence(String pName, Style pStyle, Supplier<BlockState> pBlockState) {
        this.name = pName;
        this.style = pStyle;
        this.blockState = pBlockState;
    }

    public String getName() {
        return this.name;
    }

    public BlockState getBlockState() {
        return this.blockState.get();
    }

    public Style getStyle() {
        return this.style;
    }

    public Tag toTag() {
        return IntTag.m_128679_((int)this.ordinal());
    }

    public static Essence fromTag(Tag tag) {
        Essence essence;
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            essence = BY_ID[intTag.m_7047_()];
        } else {
            essence = null;
        }
        return essence;
    }

    public static Essence fromBlockState(BlockState pState) {
        for (Essence essence : Essence.values()) {
            if (!essence.getBlockState().m_60734_().equals(pState.m_60734_())) continue;
            return essence;
        }
        return null;
    }

    static {
        BY_ID = (Essence[])Arrays.stream(Essence.values()).sorted(Comparator.comparingInt(Enum::ordinal)).toArray(Essence[]::new);
    }
}

