/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.soulcaster;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.FabrialItem;
import us.amon.stormward.item.soulcaster.Essence;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItem;

public class SoulcasterItem
extends StormlightStorageItem {
    private static final int SOULCAST_RATE = 15;
    private static final int COST = 2;
    private static final String TARGET = "Target";
    private static final String ESSENCES = "Essences";

    public SoulcasterItem(Item.Properties pProperties) {
        super(100, pProperties.m_41497_(Rarity.RARE));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        ItemStack stack = pContext.m_43722_();
        BlockPos targetPos = pContext.m_8083_();
        Essence currentEssence = Essence.fromBlockState(level.m_8055_(targetPos));
        ListTag essencesTag = SoulcasterItem.getOrCreateEssenceTag(stack);
        if (StormlightStorageHelper.isDun((ICapabilityProvider)stack) || essencesTag.isEmpty() || essencesTag.size() == 1 && Essence.fromTag(essencesTag.get(0)).equals((Object)currentEssence)) {
            return InteractionResult.FAIL;
        }
        this.soulcast(level, stack, targetPos);
        if (player != null) {
            stack.m_41622_(2, (LivingEntity)player, living -> living.m_21190_(player.m_7655_()));
            player.m_6672_(pContext.m_43724_());
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(TARGET, (Tag)NbtUtils.m_129224_((BlockPos)targetPos));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return SoulcasterItem.getOrCreateEssenceTag(pStack).size() > 1 ? 72000 : 0;
    }

    public void m_5929_(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (!pStack.m_41782_() || !pStack.m_41783_().m_128441_(TARGET)) {
                player.m_5810_();
                return;
            }
            BlockPos targetPos = NbtUtils.m_129239_((CompoundTag)pStack.m_41783_().m_128469_(TARGET));
            if (!this.playerLookingAtTarget(player, targetPos)) {
                player.m_5810_();
                this.m_5551_(pStack, pLevel, pLivingEntity, this.m_8105_(pStack) - pRemainingUseDuration);
                return;
            }
            if (pRemainingUseDuration < this.m_8105_(pStack) && pRemainingUseDuration % 15 == 0) {
                this.soulcast(pLevel, pStack, targetPos);
            }
        }
    }

    private void soulcast(Level pLevel, ItemStack pStack, BlockPos pPos) {
        int index;
        ListTag essencesTag = SoulcasterItem.getOrCreateEssenceTag(pStack);
        Essence nextEssence = Essence.fromTag(essencesTag.get(0));
        Essence currentEssence = Essence.fromBlockState(pLevel.m_8055_(pPos));
        if (currentEssence != null && (index = SoulcasterItem.getEssenceIndex(pStack, currentEssence)) >= 0) {
            nextEssence = Essence.fromTag(essencesTag.get((index + 1) % essencesTag.size()));
        }
        if (!pLevel.m_5776_()) {
            pLevel.m_46597_(pPos, nextEssence.getBlockState());
        } else {
            this.playSoulcastSound(pLevel, pPos, nextEssence.getBlockState());
            if (nextEssence == Essence.SMOKE) {
                this.playSmokeEffects(pLevel, pPos);
            }
        }
    }

    private boolean playerLookingAtTarget(@NotNull Player pPlayer, BlockPos pTarget) {
        Vec3 start = pPlayer.m_20299_(0.0f);
        Vec3 end = start.m_82549_(pPlayer.m_20252_(0.0f).m_82490_(pPlayer.getBlockReach()));
        return (Boolean)BlockGetter.m_151361_((Vec3)start, (Vec3)end, (Object)pTarget, (target, pos) -> pos.equals(target) ? Boolean.valueOf(true) : null, target -> false);
    }

    private void playSoulcastSound(Level pLevel, BlockPos pPos, BlockState pState) {
        SoundType type = pState.m_60827_();
        pLevel.m_245747_(pPos, type.m_56777_(), SoundSource.BLOCKS, (type.m_56773_() + 1.0f) / 2.0f, type.m_56774_() * 0.8f, false);
    }

    private void playSmokeEffects(Level pLevel, BlockPos pPos) {
        for (int i = 0; i < 32; ++i) {
            Vec3 center = pPos.m_252807_();
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, center.f_82479_ + pLevel.f_46441_.m_188500_() - 0.5, center.f_82480_ + pLevel.f_46441_.m_188500_() - 0.5, center.f_82481_ + pLevel.f_46441_.m_188500_() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void m_5551_(ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, int pTimeCharged) {
        CompoundTag tag = pStack.m_41784_();
        tag.m_128473_(TARGET);
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        ListTag essencesTag = SoulcasterItem.getOrCreateEssenceTag(pStack);
        if (!essencesTag.isEmpty()) {
            pTooltip.add((Component)Component.m_237119_());
            pTooltip.add((Component)Component.m_237115_((String)"item.stormward.soulcaster.essences").m_130940_(ChatFormatting.GRAY));
        }
        for (Tag essenceTag : essencesTag) {
            Essence essence = Essence.fromTag(essenceTag);
            if (essence == null) continue;
            pTooltip.add((Component)Component.m_237115_((String)("item.stormward.soulcaster." + essence.getName())).m_130948_(essence.getStyle()));
        }
    }

    public static boolean canAddFabrial(ItemStack pStack, FabrialItem pFabrial) {
        return !SoulcasterItem.hasEssence(pStack, pFabrial.getSoulcasterEssence());
    }

    public static void addFabrial(ItemStack pStack, FabrialItem pFabrial) {
        if (SoulcasterItem.canAddFabrial(pStack, pFabrial)) {
            SoulcasterItem.addEssence(pStack, pFabrial.getSoulcasterEssence());
        }
    }

    public static void addEssence(ItemStack pStack, Essence pEssencess) {
        Tag essenceTag;
        ListTag essencesTag = SoulcasterItem.getOrCreateEssenceTag(pStack);
        if (!essencesTag.contains((Object)(essenceTag = pEssencess.toTag()))) {
            essencesTag.add((Object)essenceTag);
        }
    }

    protected static boolean isEmpty(ItemStack pStack) {
        return SoulcasterItem.getOrCreateEssenceTag(pStack).isEmpty();
    }

    protected static boolean hasEssence(ItemStack pStack, Essence pEssence) {
        return SoulcasterItem.getOrCreateEssenceTag(pStack).contains((Object)pEssence.toTag());
    }

    protected static int getEssenceIndex(ItemStack pStack, Essence pEssence) {
        return SoulcasterItem.getOrCreateEssenceTag(pStack).indexOf((Object)pEssence.toTag());
    }

    protected static ListTag getOrCreateEssenceTag(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        if (tag.m_128441_(ESSENCES)) {
            return tag.m_128437_(ESSENCES, 3);
        }
        ListTag essencesTag = new ListTag();
        tag.m_128365_(ESSENCES, (Tag)essencesTag);
        return essencesTag;
    }

    public static ItemStack addAllEssences(ItemStack pStack) {
        for (Essence essence : Essence.values()) {
            SoulcasterItem.addEssence(pStack, essence);
        }
        return pStack;
    }
}

