/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.stormlightstorage;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItemHelper;

public class StormlightStorageItem
extends Item {
    private final int maxStormlight;

    public StormlightStorageItem(int pMaxStormlight, Item.Properties pProperties) {
        super(pProperties.m_41499_(pMaxStormlight));
        this.maxStormlight = pMaxStormlight;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return StormlightStorageItemHelper.initCapabilities(this.maxStormlight);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return StormlightStorageItemHelper.getShareTag(stack);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        StormlightStorageItemHelper.readShareTag(stack, nbt);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return StormlightStorageItemHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return StormlightStorageItemHelper.damageItem(stack, amount, entity, onBroken);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? 0 : super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? Map.of() : EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageItemHelper.canApplyAtEnchantingTable(enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.isBarVisible(pStack);
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarWidth(pStack);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarColor(pStack);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        StormlightStorageItemHelper.appendHoverText(pStack, pLevel, pTooltip, pFlag);
    }
}

