/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.Config;
import us.amon.stormward.capability.stormlightstorage.StormlightConfigStorageProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItemHelper;
import us.amon.stormward.item.tool.IAugmentedTool;

public class AugmentedPickaxeItem
extends PickaxeItem
implements IAugmentedTool {
    private final Multimap<Attribute, AttributeModifier> brokenModifiers;

    public AugmentedPickaxeItem(int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(AUGMENTED_TIER, pAttackDamageModifier, pAttackSpeedModifier, pProperties.m_41497_(Rarity.RARE));
        this.brokenModifiers = this.buildBrokenModifiers(f_41375_, pAttackSpeedModifier);
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, @NotNull BlockState state) {
        return !this.isBroken(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public float m_8102_(@NotNull ItemStack pStack, @NotNull BlockState pState) {
        return this.isCorrectToolForDrops(pStack, pState) ? this.f_40980_ : 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && this.isBroken(stack)) {
            return this.brokenModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext pContext) {
        if (this.isBroken(pContext.m_43722_())) {
            return InteractionResult.PASS;
        }
        return super.m_6225_(pContext);
    }

    @javax.annotation.Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
        return new StormlightConfigStorageProvider(Config.AUGMENTED_PICKAXE_STORMLIGHT);
    }

    @javax.annotation.Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return StormlightStorageItemHelper.getShareTag(stack);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        StormlightStorageItemHelper.readShareTag(stack, nbt);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return StormlightStorageItemHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.isBarVisible(pStack);
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarWidth(pStack);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarColor(pStack);
    }

    public void m_7373_(@NotNull ItemStack pStack, @javax.annotation.Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        StormlightStorageItemHelper.appendHoverText(pStack, pLevel, pTooltip, pFlag);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return StormlightStorageItemHelper.damageItem(stack, amount, entity, onBroken);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? 0 : super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? Map.of() : EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageItemHelper.canApplyAtEnchantingTable(enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

