/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.tool;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.stormlightstorage.StormlightTransferBlock;
import us.amon.stormward.sound.StormwardSoundEvents;

public class TuningForkItem
extends Item {
    public TuningForkItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext pContext) {
        BlockPos pos;
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos = pContext.m_8083_());
        if (state.m_60734_() instanceof StormlightTransferBlock) {
            ItemStack stack = pContext.m_43722_();
            if (TuningForkItem.hasResonancePos(stack)) {
                BlockPos resonancePos = TuningForkItem.readResonancePos(stack);
                TuningForkItem.clearResonancePos(stack);
                if (StormlightTransferBlock.tryAddReceiver(level, resonancePos, pos)) {
                    this.takeUseDamage(pContext);
                    level.m_5594_(null, pos, (SoundEvent)StormwardSoundEvents.TUNING_FORK_SUCCESS.get(), SoundSource.BLOCKS, 0.8f, 1.0f + level.f_46441_.m_188501_() * 0.1f);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else if (StormlightTransferBlock.canExtractStormlight(level, pos)) {
                TuningForkItem.saveResonancePos(stack, pos);
                level.m_5594_(null, pos, (SoundEvent)StormwardSoundEvents.TUNING_FORK_SUCCESS.get(), SoundSource.BLOCKS, 0.8f, 1.0f + level.f_46441_.m_188501_() * 0.1f);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            level.m_5594_(null, pos, (SoundEvent)StormwardSoundEvents.TUNING_FORK_FAIL.get(), SoundSource.BLOCKS, 0.8f, 1.0f - level.f_46441_.m_188501_() * 0.1f);
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (TuningForkItem.hasResonancePos(pStack) && pEntity.m_20238_(TuningForkItem.readResonancePos(pStack).m_252807_()) > 36.0) {
            pLevel.m_5594_(null, pEntity.m_20183_(), (SoundEvent)StormwardSoundEvents.TUNING_FORK_FAIL.get(), SoundSource.BLOCKS, 0.8f, 1.0f - pLevel.f_46441_.m_188501_() * 0.1f);
            TuningForkItem.clearResonancePos(pStack);
        }
    }

    private void takeUseDamage(UseOnContext pContext) {
        if (pContext.m_43723_() != null) {
            pContext.m_43722_().m_41622_(1, (LivingEntity)pContext.m_43723_(), player -> player.m_21190_(pContext.m_43724_()));
        }
    }

    public static void saveResonancePos(ItemStack pStack, BlockPos pPos) {
        CompoundTag tag = pStack.m_41784_();
        tag.m_128365_("Resonance", (Tag)NbtUtils.m_129224_((BlockPos)pPos));
        pStack.m_41751_(tag);
    }

    public static boolean hasResonancePos(ItemStack pStack) {
        return pStack.m_41784_().m_128441_("Resonance");
    }

    public static BlockPos readResonancePos(ItemStack pStack) {
        return NbtUtils.m_129239_((CompoundTag)pStack.m_41784_().m_128469_("Resonance"));
    }

    public static void clearResonancePos(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        tag.m_128473_("Resonance");
        pStack.m_41751_(tag);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pIsAdvanced) {
        if (TuningForkItem.hasResonancePos(pStack) && pIsAdvanced.m_7050_()) {
            pTooltip.add((Component)Component.m_237110_((String)"item.stormward.tuning_fork_text", (Object[])new Object[]{TuningForkItem.readResonancePos(pStack).m_123344_()}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltip, pIsAdvanced);
    }
}

