/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.weapon;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.Config;
import us.amon.stormward.capability.stormlightstorage.StormlightConfigStorageProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.client.GrandbowItemExtensions;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItemHelper;
import us.amon.stormward.sound.StormwardSoundEvents;
import us.amon.stormward.util.IAbstractArrow;

public class GrandbowItem
extends ProjectileWeaponItem
implements Vanishable {
    public static final int DEFAULT_RANGE = 30;
    public static final int MAX_DRAW_DURATION = 40;
    public static final float VELOCITY = 3.9f;
    public static final double GRAVITY_REDUCTION = 0.015;
    public static final float BASE_DAMAGE = 2.5f;
    public static final int MAX_PIERCE_LEVEL = 2;

    public GrandbowItem(Item.Properties pProperties) {
        super(pProperties.m_41497_(Rarity.RARE));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new GrandbowItemExtensions());
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            boolean flag = player.m_150110_().f_35937_ || pStack.getEnchantmentLevel(Enchantments.f_44952_) > 0;
            ItemStack itemstack = player.m_6298_(pStack);
            int i = this.m_8105_(pStack) - pTimeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)i, (!itemstack.m_41619_() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || flag) {
                float f;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!((double)(f = GrandbowItem.getPowerForTime(i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, pStack, player);
                    if (!pLevel.f_46443_) {
                        int k;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow abstractarrow = arrowitem.m_6394_(pLevel, itemstack, (LivingEntity)player);
                        abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.9f, 0.0f);
                        GrandbowItem.setShotFromGrandbow(abstractarrow, f);
                        int j = pStack.getEnchantmentLevel(Enchantments.f_44988_);
                        if (j > 0) {
                            abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = pStack.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
                            abstractarrow.m_36735_(k);
                        }
                        if (pStack.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                            abstractarrow.m_20254_(100);
                        }
                        pStack.m_41622_(1, (LivingEntity)player, p_296888_ -> p_296888_.m_21190_(player.m_7655_()));
                        if (flag1 || player.m_150110_().f_35937_ && (itemstack.m_150930_(Items.f_42737_) || itemstack.m_150930_(Items.f_42738_))) {
                            abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        pLevel.m_7967_((Entity)abstractarrow);
                    }
                    pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StormwardSoundEvents.GRANDBOW.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public static void setShotFromGrandbow(AbstractArrow pArrow, float pPower) {
        ((IAbstractArrow)pArrow).stormward$setShotFromGrandbow(true);
        pArrow.m_36781_(2.5);
        if (pPower == 1.0f) {
            pArrow.m_36762_(true);
        }
        pArrow.m_36767_((byte)Mth.m_14143_((float)(pPower * 2.0f)));
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 40.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.CUSTOM;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        boolean flag;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        boolean bl = flag = !pPlayer.m_6298_(itemstack).m_41619_();
        if (StormlightStorageHelper.isDun((ICapabilityProvider)itemstack)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!pPlayer.m_150110_().f_35937_ && !flag) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public int m_6615_() {
        return 30;
    }

    public static float getPullAmount(LivingEntity pEntity, ItemStack pStack) {
        return pEntity.m_21211_() != pStack ? 0.0f : (float)(pStack.m_41779_() - pEntity.m_21212_()) / 40.0f;
    }

    public static void onRenderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_6117_() && player.m_21211_().m_150930_((Item)StormwardItems.GRANDBOW.get()) && event.getHand() != player.m_7655_()) {
            event.setCanceled(true);
        }
    }

    public static void onComputeFovModifier(ComputeFovModifierEvent event) {
        if (event.getPlayer().m_6117_() && event.getPlayer().m_21211_().m_150930_((Item)StormwardItems.GRANDBOW.get())) {
            int i = event.getPlayer().m_21252_();
            float f1 = (float)i / 40.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewFovModifier(event.getNewFovModifier() * (1.0f - f1 * 0.15f));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new StormlightConfigStorageProvider(Config.GRANDBOW_STORMLIGHT);
    }

    public int getMaxDamage(ItemStack stack) {
        return StormlightStorageHelper.getMaxStormlight((ICapabilityProvider)stack);
    }

    public boolean m_41465_() {
        return true;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return StormlightStorageItemHelper.getShareTag(stack);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        StormlightStorageItemHelper.readShareTag(stack, nbt);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return StormlightStorageItemHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.isBarVisible(pStack);
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarWidth(pStack);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return StormlightStorageItemHelper.getBarColor(pStack);
    }

    public void m_7373_(@NotNull ItemStack pStack, @javax.annotation.Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        StormlightStorageItemHelper.appendHoverText(pStack, pLevel, pTooltip, pFlag);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return StormlightStorageItemHelper.damageItem(stack, amount, entity, onBroken);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? 0 : super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)stack) ? Map.of() : EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return StormlightStorageItemHelper.canApplyAtEnchantingTable(enchantment) && (super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.f_44990_ || enchantment == Enchantments.f_44952_ || enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44989_);
    }
}

