/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.weapon;

import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.Config;
import us.amon.stormward.capability.shardstorage.ShardStorageHelper;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.entity.spren.shadesmar.TrueSprenShadesmar;
import us.amon.stormward.item.shard.ISprenShardItem;
import us.amon.stormward.item.weapon.StormlightStorageWeaponItem;

public class ShardbladeItem
extends StormlightStorageWeaponItem
implements ISprenShardItem {
    private final Supplier<? extends EntityType<? extends TrueSprenShadesmar>> typeSupplier;

    public ShardbladeItem(Supplier<? extends EntityType<? extends TrueSprenShadesmar>> pTypeSupplier, Item.Properties pProperties) {
        super(-3.2f, 0.0f, 0.8f, pProperties.m_41497_(Rarity.EPIC));
        this.typeSupplier = pTypeSupplier;
    }

    @Override
    public double getDamage() {
        return (Double)Config.SHARDBLADE_DAMAGE.get();
    }

    @Override
    protected ForgeConfigSpec.ConfigValue<Integer> getUsesConfigValue() {
        return Config.SHARDBLADE_STORMLIGHT;
    }

    public int m_6473_() {
        return 12;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.f_44980_;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (StormlightStorageHelper.isDun((ICapabilityProvider)stack)) {
            return false;
        }
        return !StormlightStorageHelper.isDun((ICapabilityProvider)stack) && TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.IRON, (BlockState)state);
    }

    public float m_8102_(@NotNull ItemStack pStack, @NotNull BlockState pState) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)pStack) ? 1.0f : 12.0f;
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        ShardStorageHelper.tickShardStorage(level, (Entity)player, stack, slotIndex);
    }

    @Override
    @Nullable
    public EntityType<? extends TrueSprenShadesmar> getSprenType() {
        return this.typeSupplier.get();
    }
}

