/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.level;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.duel.Duel;

public class Duels
extends SavedData {
    public static final String NAME = "duels";
    private final Map<Integer, Duel> duelMap = Maps.newHashMap();
    private final ServerLevel level;
    private int nextAvailableID;
    private int tick;

    public static SavedData.Factory<Duels> factory(ServerLevel pLevel) {
        return new SavedData.Factory(() -> new Duels(pLevel), compoundTag -> Duels.load(pLevel, compoundTag), DataFixTypes.LEVEL);
    }

    public Duels(ServerLevel pLevel) {
        this.level = pLevel;
        this.nextAvailableID = 1;
        this.m_77762_();
    }

    public static Duels get(ServerLevel pLevel) {
        return (Duels)pLevel.m_8895_().m_164861_(Duels.factory(pLevel), NAME);
    }

    public static Duels load(ServerLevel pLevel, CompoundTag pTag) {
        Duels duels = new Duels(pLevel);
        duels.nextAvailableID = pTag.m_128451_("NextAvailableID");
        ListTag duelsTag = pTag.m_128437_("Duels", 10);
        for (int i = 0; i < duelsTag.size(); ++i) {
            CompoundTag duelTag = duelsTag.m_128728_(i);
            Duel duel = new Duel(pLevel, duelTag);
            duels.duelMap.put(duel.getId(), duel);
        }
        return duels;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        pCompoundTag.m_128405_("NextAvailableID", this.nextAvailableID);
        ListTag duelsTag = new ListTag();
        for (Duel duel : this.duelMap.values()) {
            CompoundTag runTag = new CompoundTag();
            duel.save(runTag);
            duelsTag.add((Object)runTag);
        }
        pCompoundTag.m_128365_("Duels", (Tag)duelsTag);
        return pCompoundTag;
    }

    public Duel getById(int pId) {
        return this.duelMap.get(pId);
    }

    public Duel getByPos(BlockPos pPos) {
        for (Duel duel : this.duelMap.values()) {
            if (!duel.getArenaCenter().equals((Object)pPos)) continue;
            return duel;
        }
        return null;
    }

    public static void onTickLevel(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Duels.get(serverLevel).tick();
        }
    }

    public void tick() {
        Iterator<Duel> iterator = this.duelMap.values().iterator();
        while (iterator.hasNext()) {
            Duel duel = iterator.next();
            if (duel.isStopped()) {
                iterator.remove();
                this.m_77762_();
                continue;
            }
            duel.tick();
        }
        if (++this.tick % 200 == 0) {
            this.m_77762_();
        }
    }

    public void startDuel(BlockPos pArenaCenter) {
        Duel duel = this.getOrCreateDuel(pArenaCenter);
        if (!this.duelMap.containsKey(duel.getId())) {
            this.duelMap.put(duel.getId(), duel);
            this.m_77762_();
        }
    }

    private Duel getOrCreateDuel(BlockPos pArenaCenter) {
        Duel duel = this.getByPos(pArenaCenter);
        return duel != null ? duel : new Duel(this.getUniqueId(), this.level, pArenaCenter);
    }

    private int getUniqueId() {
        return ++this.nextAvailableID;
    }
}

