/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.level;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.Config;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.command.StormwardGameRules;
import us.amon.stormward.entity.plateaurun.PlateauRun;
import us.amon.stormward.tag.StormwardBlockTags;
import us.amon.stormward.worldgen.biome.StormwardBiomes;
import us.amon.stormward.worldgen.processor.RandomizeProcessor;

public class PlateauRuns
extends SavedData {
    public static final String NAME = "plateauruns";
    public static final int MIN_SPAWN_RADIUS = 32;
    public static final int MAX_SPAWN_RADIUS = 96;
    private static final ResourceLocation STRUCTURE = new ResourceLocation("stormward", "chrysalis");
    private static final BlockPos OFFSET = new BlockPos(3, 1, 3);
    private static final BlockPos GEMHEART_OFFSET = new BlockPos(0, 6, 0);
    private final Map<Integer, PlateauRun> plateauRunMap = Maps.newHashMap();
    private final ServerLevel level;
    private int nextAvailableID;
    private int tick;
    private int spawnCountdownTicks;

    public static SavedData.Factory<PlateauRuns> factory(ServerLevel pLevel) {
        return new SavedData.Factory(() -> new PlateauRuns(pLevel), compoundTag -> PlateauRuns.load(pLevel, compoundTag), DataFixTypes.LEVEL);
    }

    public PlateauRuns(ServerLevel pLevel) {
        this.level = pLevel;
        this.nextAvailableID = 1;
        this.m_77762_();
    }

    public static PlateauRuns get(ServerLevel pLevel) {
        return (PlateauRuns)pLevel.m_8895_().m_164861_(PlateauRuns.factory(pLevel), NAME);
    }

    public static void onTickLevel(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PlateauRuns.get(serverLevel).tick();
        }
    }

    public void tick() {
        ++this.tick;
        this.updateChrysalisSpawns();
        this.updateExistingPlateauRuns();
        if (this.tick % 200 == 0) {
            this.m_77762_();
        }
    }

    public static PlateauRuns load(ServerLevel pLevel, CompoundTag pTag) {
        PlateauRuns runs = new PlateauRuns(pLevel);
        runs.nextAvailableID = pTag.m_128451_("NextAvailableID");
        runs.tick = pTag.m_128451_("Tick");
        runs.spawnCountdownTicks = pTag.m_128451_("CountdownTicks");
        ListTag runsTag = pTag.m_128437_("PlateauRuns", 10);
        for (int i = 0; i < runsTag.size(); ++i) {
            CompoundTag runTag = runsTag.m_128728_(i);
            PlateauRun run = new PlateauRun(pLevel, runTag);
            runs.plateauRunMap.put(run.getId(), run);
        }
        return runs;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        pCompoundTag.m_128405_("NextAvailableID", this.nextAvailableID);
        pCompoundTag.m_128405_("Tick", this.tick);
        pCompoundTag.m_128405_("CountdownTicks", this.spawnCountdownTicks);
        ListTag runsTag = new ListTag();
        for (PlateauRun run : this.plateauRunMap.values()) {
            CompoundTag runTag = new CompoundTag();
            run.save(runTag);
            runsTag.add((Object)runTag);
        }
        pCompoundTag.m_128365_("PlateauRuns", (Tag)runsTag);
        return pCompoundTag;
    }

    public PlateauRun get(int pId) {
        return this.plateauRunMap.get(pId);
    }

    private void updateExistingPlateauRuns() {
        Iterator<PlateauRun> iterator = this.plateauRunMap.values().iterator();
        while (iterator.hasNext()) {
            PlateauRun run = iterator.next();
            if (this.level.m_46469_().m_46207_(StormwardGameRules.RULE_DISABLE_PLATEAU_RUNS)) {
                run.stop();
            }
            if (run.isStopped()) {
                iterator.remove();
                this.m_77762_();
                continue;
            }
            run.tick();
        }
    }

    public PlateauRun createPlateauRun(BlockPos pGemheartPos) {
        if (this.level.m_46469_().m_46207_(StormwardGameRules.RULE_DISABLE_PLATEAU_RUNS)) {
            return null;
        }
        PlateauRun run = this.getOrCreatePlateauRun(this.level, pGemheartPos);
        if (!run.isStarted() && !this.plateauRunMap.containsKey(run.getId())) {
            this.plateauRunMap.put(run.getId(), run);
        }
        run.playSound(pGemheartPos);
        this.m_77762_();
        return run;
    }

    private PlateauRun getOrCreatePlateauRun(ServerLevel pServerLevel, BlockPos pGemheartPos) {
        PlateauRun run = this.getPlateauRunForGemheart(pGemheartPos);
        return run != null ? run : new PlateauRun(this.getUniqueId(), pServerLevel, pGemheartPos);
    }

    private int getUniqueId() {
        return ++this.nextAvailableID;
    }

    @Nullable
    public PlateauRun getPlateauRunForGemheart(BlockPos pGemheartPos) {
        for (PlateauRun run : this.plateauRunMap.values()) {
            if (!run.isActive() || !pGemheartPos.equals((Object)run.getGemheartPos())) continue;
            return run;
        }
        return null;
    }

    private void updateChrysalisSpawns() {
        int spawnInterval = (Integer)Config.PLATEAU_RUN_SPAWN_INTERVAL.get();
        if (this.spawnCountdownTicks > spawnInterval) {
            this.spawnCountdownTicks = spawnInterval;
        }
        --this.spawnCountdownTicks;
        if (this.spawnCountdownTicks > 0) {
            return;
        }
        this.spawnCountdownTicks += spawnInterval;
        BlockPos.MutableBlockPos center = this.getChrysalisLocation(this.level, this.level.m_6907_().stream().filter(player -> !player.m_5833_()).toList(), this.level.f_46441_, 20);
        if (center == null) {
            return;
        }
        if (!this.spawnChrysalis((BlockPos)center, this.level.f_46441_)) {
            return;
        }
        this.createPlateauRun(center.m_121955_((Vec3i)GEMHEART_OFFSET));
    }

    protected BlockPos.MutableBlockPos getChrysalisLocation(ServerLevel pLevel, List<ServerPlayer> players, RandomSource pRandom, int pTries) {
        if (players.isEmpty()) {
            return null;
        }
        for (int i = 0; i < pTries; ++i) {
            Holder holder;
            ServerPlayer player = players.get(pRandom.m_188503_(players.size()));
            int k = (32 + pRandom.m_188503_(64)) * (pRandom.m_188499_() ? -1 : 1);
            int l = (32 + pRandom.m_188503_(64)) * (pRandom.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos pos = player.m_20183_().m_122032_().m_122184_(k, 0, l);
            if (!pLevel.m_7232_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_())) || !(holder = pLevel.m_204166_((BlockPos)pos)).m_203565_(StormwardBiomes.SHATTERED_PLAINS)) continue;
            pos.m_122190_((Vec3i)pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)pos));
            if (!pLevel.m_8055_(pos.m_7495_()).m_60713_((Block)StormwardBlocks.HARDENED_CREM.get())) continue;
            return pos;
        }
        return null;
    }

    protected boolean spawnChrysalis(BlockPos pCenter, RandomSource pRandom) {
        Optional optional;
        StructureTemplateManager structuretemplatemanager = this.level.m_215082_();
        try {
            optional = structuretemplatemanager.m_230407_(STRUCTURE);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return false;
        }
        if (optional.isEmpty()) {
            return false;
        }
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().m_74379_(Rotation.m_221990_((RandomSource)pRandom)).m_74385_(OFFSET);
        structureplacesettings.m_74394_().m_74383_((StructureProcessor)new RandomizeProcessor(StormwardBlockTags.GEMHEARTS, ForgeRegistries.BLOCKS.tags().getTag(StormwardBlockTags.GEMHEARTS).stream().map(Block::m_49966_).toList())).m_74383_((StructureProcessor)new BlockIgnoreProcessor(List.of(Blocks.f_50016_, Blocks.f_50626_)));
        BlockPos corner = pCenter.m_7918_(-OFFSET.m_123341_(), -OFFSET.m_123342_(), -OFFSET.m_123343_());
        return ((StructureTemplate)optional.get()).m_230328_((ServerLevelAccessor)this.level, corner, corner, structureplacesettings, pRandom, 2);
    }
}

